import numpy as np
black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)
def main(input_grid: np.ndarray) -> np.ndarray:
    # Find all blue rectangles in the input grid
    blue_rectangles = []
    for i in range(input_grid.shape[0]):
        for j in range(input_grid.shape[1]):
            if input_grid[i][j] == blue:
                # Check if this blue pixel is part of an existing blue rectangle
                found = False
                for rect in blue_rectangles:
                    if (i >= rect[0] and i <= rect[2] and j >= rect[1] and j <= rect[3]):
                        rect[4] += 1
                        found = True
                        break
                # If not, create a new blue rectangle
                if not found:
                    h, w = 0, 0
                    while i+h < input_grid.shape[0] and input_grid[i+h][j] == blue:
                        w = 0
                        while j+w < input_grid.shape[1] and input_grid[i+h][j+w] == blue:
                            w += 1
                        h += 1
                    blue_rectangles.append([i, j, i+h-1, j+w-1, 1])
    # Find the blue rectangle with the most red pixels
    max_red_pixels = 0
    max_red_rectangle = None
    for rect in blue_rectangles:
        red_pixels = 0
        for i in range(rect[0], rect[2]+1):
            for j in range(rect[1], rect[3]+1):
                if input_grid[i][j] == red:
                    red_pixels += 1
        if red_pixels > max_red_pixels:
            max_red_pixels = red_pixels
            max_red_rectangle = rect
    # Create the output grid with the blue rectangle with the most red pixels
    output_grid = np.zeros((max_red_rectangle[2]-max_red_rectangle[0]+1, max_red_rectangle[3]-max_red_rectangle[1]+1))
    for i in range(max_red_rectangle[0], max_red_rectangle[2]+1):
        for j in range(max_red_rectangle[1], max_red_rectangle[3]+1):
            if input_grid[i][j] == blue or input_grid[i][j] == red:
                output_grid[i-max_red_rectangle[0]][j-max_red_rectangle[1]] = input_grid[i][j]
    return output_grid