import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the major and minor colors in the input grid
    unique_colors, counts = np.unique(input_grid, return_counts=True)
    major_color = unique_colors[np.argmax(counts)]
    minor_color = unique_colors[np.argmin(counts)]

    # Find the number of vertical and horizontal lines in the input grid
    num_vertical_lines = np.sum(input_grid[0] == minor_color)
    num_horizontal_lines = np.sum(input_grid[:, 0] == minor_color)

    # Create the output grid with the appropriate dimensions and fill it with the major color
    output_grid = np.full((num_horizontal_lines+1, num_vertical_lines+1), major_color)

    return output_grid
