import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    output_grid = np.zeros_like(input_grid)

    for i in range(input_grid.shape[0]):
        for j in range(input_grid.shape[1]):
            if input_grid[i][j] == blue:
                output_grid[i][j] = blue
                if i-1 >= 0:
                    output_grid[i-1][j] = red
                if j-1 >= 0:
                    output_grid[i][j-1] = orange
                if j+1 < input_grid.shape[1]:
                    output_grid[i][j+1] = pink
                if i+1 < input_grid.shape[0]:
                    output_grid[i+1][j] = teal
    return output_grid