import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Initialize output grid as a copy of the input grid
    output_grid = np.copy(input_grid)
    
    # Find the max blue rectangle by finding the max and min coordinates of the blue points
    blue_points = np.argwhere(input_grid == 1)
    if len(blue_points) > 0:
        min_x, min_y = np.min(blue_points, axis=0)
        max_x, max_y = np.max(blue_points, axis=0)
        
        # Mark the sides of the max blue rectangle with red points
        for i in range(min_x, max_x+1):
            if output_grid[i][min_y] == black:
                output_grid[i][min_y] = red
            if output_grid[i][max_y] == black:
                output_grid[i][max_y] = red
        for j in range(min_y, max_y+1):
            if output_grid[min_x][j] == black:
                output_grid[min_x][j] = red
            if output_grid[max_x][j] == black:
                output_grid[max_x][j] = red
                
        # Check which row or column within the max blue rectangle area (not including the edge) has more than two blue points
        for i in range(min_x+1, max_x):
            if np.sum(output_grid[i, min_y+1:max_y]) > 2:
                for j in range(min_y+1, max_y):
                    if output_grid[i][j] == black:
                        output_grid[i][j] = red
        for j in range(min_y+1, max_y):
            if np.sum(output_grid[min_x+1:max_x, j]) > 2:
                for i in range(min_x+1, max_x):
                    if output_grid[i][j] == black:
                        output_grid[i][j] = red
            
    return output_grid