import numpy as np
from typing import *
(black, blue, red, green, yellow, grey, pink, orange, teal, maroon) = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the non-black blocks in the input_grid
    non_black_blocks = np.where(input_grid != black)

    # Create the output_grid of the same size as the non-black blocks
    output_grid = np.zeros((np.max(non_black_blocks[0]) - np.min(non_black_blocks[0]) + 1,
                            np.max(non_black_blocks[1]) - np.min(non_black_blocks[1]) + 1), dtype=np.int32)

    # Set the non-black blocks in the output_grid to their corresponding color
    for i, j in zip(non_black_blocks[0], non_black_blocks[1]):
        output_grid[i - np.min(non_black_blocks[0])][j - np.min(non_black_blocks[1])] = input_grid[i][j]

    # Perform mirror inversion to the output_grid
    output_grid = np.fliplr(output_grid)

    return output_grid