import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    ngrid = np.copy(input_grid)

    # Traverse each row in the input_grid
    for i in range(ngrid.shape[0]):
        if np.all(ngrid[i,:] == black):
            # Paint the corresponding row in the ngrid red
            ngrid[i,:] = red

    # Traverse each column in input_grid
    for j in range(input_grid.shape[1]):
        if np.all(input_grid[:,j] == black):
            # Paint the corresponding column in ngrid red
            ngrid[:,j] = red

    return ngrid