import numpy as np
from CANN_1D import CANN_v2
import matplotlib.pyplot as plt
from scipy import ndimage
import os


# set font type to make it editable in illustrator in eps format
plt.rcParams['pdf.fonttype'] = 42
plt.rcParams['ps.fonttype'] = 42
# set figure style
plt.style.use('seaborn-white')

# set no margin for the figure
plt.rcParams['axes.xmargin'] = 0
plt.rcParams['axes.ymargin'] = 0

figsize = [8,8]

# set the figure path
figure_path = '../figures/NeurIPS_Figures/0/'
# determine if the folder exists
if not os.path.exists(figure_path):
    os.makedirs(figure_path)

def Au(k,a=0.5,J0=1,rho=512/(2*np.pi)):
    # num = 1 + np.sqrt(1 - 8*k/(J0**2 * np.sqrt(2*np.pi) * a * rho))
    # den = 2 * np.sqrt(2*np.pi) * a * k * rho
    num = np.sqrt(np.pi) * a * rho * J0 + np.sqrt(np.pi * a**2 * rho**2 *J0**2 - 4 * k * rho * np.sqrt(2*np.pi) * a)
    den = 2 * k * rho * np.sqrt(2*np.pi) * a
    return num / den

N = 512
tau = 1
trans = True

a = 0.5
cor = np.arange(-np.pi, np.pi, 2*np.pi/N)
# A = np.sqrt(2*np.pi*a**2)
J0 = 1
rho = N / (2*np.pi)

kc = np.pi*a*rho*J0**2/(4*np.sqrt(2*np.pi))
k = 0.04*kc
print('kc:',kc)

exp = np.exp(-(cor)**2/(4*a**2))
Jexp = np.exp(-(cor)**2/(2*a**2))
# w = 0.02
J = J0 * Jexp #+ w * H2(cor, 0, a)
J = np.roll(J,shift=int(N/2))

T = 300
dt = 0.1
frames = int(T/dt)

net = CANN_v2(N,k,J,tau,trans)


In = exp
shift = int(N/5)
I0 = np.roll(In,shift=shift)
start = cor[np.argmax(I0)]
print('start:', start)

seq_start = np.argmax(In)
seq_end = np.argmax(I0)
length = seq_end - seq_start

center = cor[I0.argmax()]
target = cor[In.argmax()]
tres = 0.001

print('target:',target)

Alphas = np.arange(0.01,0.08,0.002)
trials = Alphas.shape[0]
Interval = np.zeros(trials)
Aus = np.zeros(trials)

final_center = np.zeros(trials)
final_z = np.zeros(trials)
set_time = 100

fano = 0.01
sampling_times = 50

React_times = np.zeros([trials,sampling_times])

for trial in range(trials):
    print('trial:',trial)
    alpha = Alphas[trial]
    for i in range(sampling_times):
        net.reset()
        distance_c = 10
        t = 0
        while distance_c > tres*2*np.pi:
            
            if t < 100:
                I_ext = alpha * I0 
            else:
                I_ext = alpha * In

            I_ext = I_ext + np.sqrt(tau*net.U*fano)*np.random.randn(N)


            smooth_U = ndimage.gaussian_filter1d(net.U,sigma=10)

            t += 1

            net.update(I_ext,dt)

            smooth_center = cor[smooth_U.argmax()]
            center = np.angle(np.exp(1j*(cor-smooth_center))) @ net.r / net.r.sum() + smooth_center
            # print(center)
            distance_c = np.abs(center-target)
        print('sampling {} t={}'.format(i,(t-100)*dt))
        React_times[trial][i] = (t-100)*dt

mean_react = React_times.mean(axis=1)
var_react = React_times.std(axis=1)

# fit the relationship between mean and variance using sklearn
from sklearn.linear_model import LinearRegression

X = mean_react.reshape(-1,1)
y = var_react

reg = LinearRegression().fit(X, y)
print('slope:',reg.coef_)
print('intercept:',reg.intercept_)
print('score:',reg.score(X,y))

# plot the relationship between mean and variance and the fitted line
plt.figure(figsize=figsize)
# make ticks visible
plt.tick_params(which='both',direction='out',length=4,width=1)
plt.scatter(mean_react,var_react)
plt.plot(X,reg.predict(X),color='red',label='Fitted Line')
plt.xlabel('Mean Reaction Time')
plt.ylabel('Standard Deviation')
plt.legend()
# save as pdf
plt.savefig(figure_path+'weber.pdf',bbox_inches='tight',dpi=1000,format='pdf')
plt.show()
