# coding: utf-8

"""
    Lightly API

    Lightly.ai enables you to do self-supervised learning in an easy and intuitive way. The lightly.ai OpenAPI spec defines how one can interact with our REST API to unleash the full potential of lightly.ai  # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: support@lightly.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from lightly.openapi_generated.swagger_client.configuration import Configuration


class DockerTaskDescription(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'embeddings_filename': 'str',
        'embeddings_hash': 'str',
        'method': 'SamplingMethod',
        'existing_selection_column_name': 'str',
        'active_learning_scores_column_name': 'str',
        'masked_out_column_name': 'str',
        'sampling_config': 'SamplingConfig',
        'n_data': 'float'
    }

    attribute_map = {
        'embeddings_filename': 'embeddingsFilename',
        'embeddings_hash': 'embeddingsHash',
        'method': 'method',
        'existing_selection_column_name': 'existingSelectionColumnName',
        'active_learning_scores_column_name': 'activeLearningScoresColumnName',
        'masked_out_column_name': 'maskedOutColumnName',
        'sampling_config': 'samplingConfig',
        'n_data': 'nData'
    }

    def __init__(self, embeddings_filename=None, embeddings_hash=None, method=None, existing_selection_column_name=None, active_learning_scores_column_name=None, masked_out_column_name=None, sampling_config=None, n_data=None, _configuration=None):  # noqa: E501
        """DockerTaskDescription - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._embeddings_filename = None
        self._embeddings_hash = None
        self._method = None
        self._existing_selection_column_name = None
        self._active_learning_scores_column_name = None
        self._masked_out_column_name = None
        self._sampling_config = None
        self._n_data = None
        self.discriminator = None

        self.embeddings_filename = embeddings_filename
        self.embeddings_hash = embeddings_hash
        self.method = method
        self.existing_selection_column_name = existing_selection_column_name
        self.active_learning_scores_column_name = active_learning_scores_column_name
        self.masked_out_column_name = masked_out_column_name
        self.sampling_config = sampling_config
        self.n_data = n_data

    @property
    def embeddings_filename(self):
        """Gets the embeddings_filename of this DockerTaskDescription.  # noqa: E501


        :return: The embeddings_filename of this DockerTaskDescription.  # noqa: E501
        :rtype: str
        """
        return self._embeddings_filename

    @embeddings_filename.setter
    def embeddings_filename(self, embeddings_filename):
        """Sets the embeddings_filename of this DockerTaskDescription.


        :param embeddings_filename: The embeddings_filename of this DockerTaskDescription.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and embeddings_filename is None:
            raise ValueError("Invalid value for `embeddings_filename`, must not be `None`")  # noqa: E501

        self._embeddings_filename = embeddings_filename

    @property
    def embeddings_hash(self):
        """Gets the embeddings_hash of this DockerTaskDescription.  # noqa: E501


        :return: The embeddings_hash of this DockerTaskDescription.  # noqa: E501
        :rtype: str
        """
        return self._embeddings_hash

    @embeddings_hash.setter
    def embeddings_hash(self, embeddings_hash):
        """Sets the embeddings_hash of this DockerTaskDescription.


        :param embeddings_hash: The embeddings_hash of this DockerTaskDescription.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and embeddings_hash is None:
            raise ValueError("Invalid value for `embeddings_hash`, must not be `None`")  # noqa: E501

        self._embeddings_hash = embeddings_hash

    @property
    def method(self):
        """Gets the method of this DockerTaskDescription.  # noqa: E501


        :return: The method of this DockerTaskDescription.  # noqa: E501
        :rtype: SamplingMethod
        """
        return self._method

    @method.setter
    def method(self, method):
        """Sets the method of this DockerTaskDescription.


        :param method: The method of this DockerTaskDescription.  # noqa: E501
        :type: SamplingMethod
        """
        if self._configuration.client_side_validation and method is None:
            raise ValueError("Invalid value for `method`, must not be `None`")  # noqa: E501

        self._method = method

    @property
    def existing_selection_column_name(self):
        """Gets the existing_selection_column_name of this DockerTaskDescription.  # noqa: E501


        :return: The existing_selection_column_name of this DockerTaskDescription.  # noqa: E501
        :rtype: str
        """
        return self._existing_selection_column_name

    @existing_selection_column_name.setter
    def existing_selection_column_name(self, existing_selection_column_name):
        """Sets the existing_selection_column_name of this DockerTaskDescription.


        :param existing_selection_column_name: The existing_selection_column_name of this DockerTaskDescription.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and existing_selection_column_name is None:
            raise ValueError("Invalid value for `existing_selection_column_name`, must not be `None`")  # noqa: E501

        self._existing_selection_column_name = existing_selection_column_name

    @property
    def active_learning_scores_column_name(self):
        """Gets the active_learning_scores_column_name of this DockerTaskDescription.  # noqa: E501


        :return: The active_learning_scores_column_name of this DockerTaskDescription.  # noqa: E501
        :rtype: str
        """
        return self._active_learning_scores_column_name

    @active_learning_scores_column_name.setter
    def active_learning_scores_column_name(self, active_learning_scores_column_name):
        """Sets the active_learning_scores_column_name of this DockerTaskDescription.


        :param active_learning_scores_column_name: The active_learning_scores_column_name of this DockerTaskDescription.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and active_learning_scores_column_name is None:
            raise ValueError("Invalid value for `active_learning_scores_column_name`, must not be `None`")  # noqa: E501

        self._active_learning_scores_column_name = active_learning_scores_column_name

    @property
    def masked_out_column_name(self):
        """Gets the masked_out_column_name of this DockerTaskDescription.  # noqa: E501


        :return: The masked_out_column_name of this DockerTaskDescription.  # noqa: E501
        :rtype: str
        """
        return self._masked_out_column_name

    @masked_out_column_name.setter
    def masked_out_column_name(self, masked_out_column_name):
        """Sets the masked_out_column_name of this DockerTaskDescription.


        :param masked_out_column_name: The masked_out_column_name of this DockerTaskDescription.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and masked_out_column_name is None:
            raise ValueError("Invalid value for `masked_out_column_name`, must not be `None`")  # noqa: E501

        self._masked_out_column_name = masked_out_column_name

    @property
    def sampling_config(self):
        """Gets the sampling_config of this DockerTaskDescription.  # noqa: E501


        :return: The sampling_config of this DockerTaskDescription.  # noqa: E501
        :rtype: SamplingConfig
        """
        return self._sampling_config

    @sampling_config.setter
    def sampling_config(self, sampling_config):
        """Sets the sampling_config of this DockerTaskDescription.


        :param sampling_config: The sampling_config of this DockerTaskDescription.  # noqa: E501
        :type: SamplingConfig
        """
        if self._configuration.client_side_validation and sampling_config is None:
            raise ValueError("Invalid value for `sampling_config`, must not be `None`")  # noqa: E501

        self._sampling_config = sampling_config

    @property
    def n_data(self):
        """Gets the n_data of this DockerTaskDescription.  # noqa: E501

        the number of samples in the current embeddings file  # noqa: E501

        :return: The n_data of this DockerTaskDescription.  # noqa: E501
        :rtype: float
        """
        return self._n_data

    @n_data.setter
    def n_data(self, n_data):
        """Sets the n_data of this DockerTaskDescription.

        the number of samples in the current embeddings file  # noqa: E501

        :param n_data: The n_data of this DockerTaskDescription.  # noqa: E501
        :type: float
        """
        if self._configuration.client_side_validation and n_data is None:
            raise ValueError("Invalid value for `n_data`, must not be `None`")  # noqa: E501

        self._n_data = n_data

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DockerTaskDescription, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DockerTaskDescription):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DockerTaskDescription):
            return True

        return self.to_dict() != other.to_dict()
