library(ggplot2)
library(extrafont) 
library(tidyverse)
library(readxl)
library(sfsmisc)
loadfonts()
mu=1
t=(0:100)/100
df=data.frame(t=(0:100)/100,tf1=pnorm(qnorm(1-t)-mu),tf2=1-sqrt(t)
              ,tf3=1-t^(1/3),tf4=1-t^(2/3))
#Figure1(b)
ggplot(data =df,aes(t)) +
  geom_line(data=df,aes(t,tf1,linetype="dashed"),color='black',size=0.6)+
  geom_line(data=df,aes(t,tf2,linetype="solid"),color='black',size=0.6)+
  geom_line(data=df,aes(t,tf3,linetype="solid"),color='black',size=0.6)+
  geom_line(data=df,aes(t,tf4,linetype="dashed"),color='black',size=0.6)+
  coord_fixed(ratio = 1)+
  scale_linetype_manual(labels=c("Lemma 1 holds","Lemma 1 does not hold"), values=c("solid", "dashed"))+
  xlab(expression(italic(alpha)))+
  ylab(expression(italic(f(alpha))))+
  theme(legend.title = element_blank(),legend.key.size = unit(0.5, "cm"),legend.position = c(0.68,0.905),text=element_text(size=21),        axis.title.x=element_text(family=fonts()[1], face = "italic"),
        axis.title.y=element_text(family=fonts()[1], face = "italic"))

library(ggplot2)
mu=1
t=(0:100)/100
#Figure1(a)
df1=data.frame(t=c((0:100)/100,(0:100)/100,(0:100)/100,(0:200)/200,rep(0,201)),
               values=c(
                 (1-exp(0.4)*(0:100)/100+exp(-0.4)*(1-(0:100)/100)+abs(1-exp(0.4)*(0:100)/100-exp(-0.4)*(1-(0:100)/100)))/2,
                 (1-exp(6.4)*(0:100)/100+exp(-6.4)*(1-(0:100)/100)+abs(1-exp(6.4)*(0:100)/100-exp(-6.4)*(1-(0:100)/100)))/2,
                 pnorm(qnorm(1-(0:100)/100)-mu),
                 rep(0,201),
                 (0:200)/200),
               class=factor(c(rep("0.4-LDP",101),
                       rep("6.4-LDP",101),
                       rep("1-GLDP",101),
                       rep("Non-private",201),
                       rep("nonpriv",201)),levels=c("0.4-LDP","6.4-LDP","1-GLDP","Non-private","nonpriv")
                       )
               )
ggplot(data =df1,aes(t,values,color=forcats::fct_inorder(class))) +geom_line(size=0.6)+
#  geom_line(aes(rep(0,101),(0:100)/100,color='Non-private'),size=0.6)+
  scale_color_manual(values = c("0.4-LDP"='red',"6.4-LDP"='green',"1-GLDP"='blue',"Non-private"='cyan',"nonpriv"='cyan'),breaks = c("0.4-LDP","6.4-LDP","1-GLDP","Non-private"))+
  coord_fixed(ratio = 1)+
  xlab(expression(italic(alpha)))+
  ylab(expression(italic(f(alpha))))+
  theme(legend.title = element_blank(),legend.key.size = unit(0.5, "cm"),legend.position = c(0.8,0.855),text=element_text(size=21),
        axis.title.x=element_text(family=fonts()[1], face = "italic"),
        axis.title.y=element_text(family=fonts()[1], face = "italic"))

library(readxl)
estimation=read_excel("n_new__2000.xlsx",col_names = F)
nonpriv_den=estimation[1:100,]
alpha_exact_den=estimation[101:200,]
alpha_2_den=estimation[201:300,]
alpha_4_den=estimation[301:400,]
alpha_8_den=estimation[401:500,]
alpha_16_den=estimation[501:600,]
Lap_ext_den=estimation[601:700,]
Lap_2_den=estimation[701:800,]
Lap_4_den=estimation[801:900,]
Lap_8_den=estimation[901:1000,]
Lap_16_den=estimation[1001:1100,]
GDP_den=estimation[1101:1200,]
GDP_2_den=estimation[1201:1300,]
nonpriv_u=sapply(nonpriv_den,function(x) quantile(x,probs=c(0.025,0.975)))[1,]
nonpriv_d=sapply(nonpriv_den,function(x) quantile(x,probs=c(0.025,0.975)))[2,]
alpha_exact_u=sapply(alpha_exact_den,function(x) quantile(x,probs=c(0.025,0.975)))[1,]
alpha_exact_d=sapply(alpha_exact_den,function(x) quantile(x,probs=c(0.025,0.975)))[2,]
alpha_2_u=sapply(alpha_2_den,function(x) quantile(x,probs=c(0.025,0.975)))[1,]
alpha_2_d=sapply(alpha_2_den,function(x) quantile(x,probs=c(0.025,0.975)))[2,]
alpha_4_u=sapply(alpha_4_den,function(x) quantile(x,probs=c(0.025,0.975)))[1,]
alpha_4_d=sapply(alpha_4_den,function(x) quantile(x,probs=c(0.025,0.975)))[2,]
alpha_8_u=sapply(alpha_8_den,function(x) quantile(x,probs=c(0.025,0.975)))[1,]
alpha_8_d=sapply(alpha_8_den,function(x) quantile(x,probs=c(0.025,0.975)))[2,]
alpha_16_u=sapply(alpha_16_den,function(x) quantile(x,probs=c(0.025,0.975)))[1,]
alpha_16_d=sapply(alpha_16_den,function(x) quantile(x,probs=c(0.025,0.975)))[2,]
gdp_u=sapply(GDP_den,function(x) quantile(x,probs=c(0.025,0.975)))[1,]
gdp_d=sapply(GDP_den,function(x) quantile(x,probs=c(0.025,0.975)))[2,]
gdp_2_u=sapply(GDP_2_den,function(x) quantile(x,probs=c(0.025,0.975)))[1,]
gdp_2_d=sapply(GDP_2_den,function(x) quantile(x,probs=c(0.025,0.975)))[2,]

df2=data.frame(t=(0:100)/100,alpha_exact_u,alpha_exact_d,alpha_2_u,alpha_2_d,alpha_4_u,alpha_4_d,alpha_8_u,alpha_8_d,alpha_16_u,alpha_16_d,gdp_u,gdp_d,gdp_2_u,gdp_2_d,nonpriv_u,nonpriv_d,beta=dbeta(t, shape1 = 5, shape2 = 5))

#Figure2(a)
ggplot(data=df2)+
  geom_ribbon(aes(x = t,
                ymin = alpha_exact_d,
                ymax = alpha_exact_u,fill = "red"),
            )+
  geom_ribbon(aes(x = t,
                  ymin = alpha_16_d,
                  ymax = alpha_16_u,fill = "green")
              )+
  geom_ribbon(aes(x = t,
                  ymin = gdp_2_d,
                  ymax = gdp_2_u,fill = "blue")
              )+
  geom_ribbon(aes(x = t,
                  ymin = nonpriv_d,
                  ymax = nonpriv_u,fill = "cyan")
              )+
  geom_ribbon(aes(x = t,
                  ymin = beta-0.01,
                  ymax = beta+0.01,fill = "black")
  )+
  scale_fill_manual(labels=c("True","1-GLDP","Non-private","6.4-LDP","0.4-LDP"), values=c("black","blue","cyan","green", "red"))+
  xlab("")+
  ylab("density")+
  coord_fixed(ratio = 0.12)+
  theme(legend.title = element_blank(),legend.key.size = unit(0.5, "cm"),legend.position = c(0.816,0.845),text=element_text(size=21))


#Figure2(b)
err_mean=read_excel("Table.xlsx")
n=c(100,200,300,500,750,1000,1500,2000)
err_se=matrix(as.numeric(as.matrix(read_excel("Table_se.xlsx"))),ncol=9)
df4=data.frame(n=rep(n,8),
               values=c(rev(as.matrix(err_mean[,2])),rev(as.matrix(err_mean[,6])),rev(as.matrix(err_mean[,3])),rev(as.matrix(err_mean[,7])),rev(as.matrix(err_mean[,4])),rev(as.matrix(err_mean[,8])),rev(as.matrix(err_mean[,5])),rev(as.matrix(err_mean[,9]))),
               privacy=c(rep("0.4-LDP",8),rep("6.4-LDP",8),rep("0.8-LDP",8),rep("0.5-GLDP",8),rep("1.6-LDP",8),rep("1-GLDP",8),rep("3.2-LDP",8),rep("Non-private",8)),
               se=c(rev(err_se[,2]),rev(err_se[,6]),rev(err_se[,3]),rev(err_se[,7]),rev(err_se[,4]),rev(err_se[,8]),rev(err_se[,5]),rev(err_se[,9]))
)
#df4=data.frame(n=rep(n,8),
#               values=c(rev(as.matrix(err_mean[,2])),rev(as.matrix(err_mean[,3])),rev(as.matrix(err_mean[,4])),rev(as.matrix(err_mean[,5])),rev(as.matrix(err_mean[,6])),rev(as.matrix(err_mean[,7])),rev(as.matrix(err_mean[,8])),rev(as.matrix(err_mean[,9]))),
#               privacy=c(rep("0.4-LDP",8),rep("0.8-LDP",8),rep("1.6-LDP",8),rep("3.2-LDP",8),rep("6.4-LDP",8),rep("0.5-GLDP",8),rep("1-GLDP",8),rep("Non-private",8)),
#               se=c(rev(err_se[,2]),rev(err_se[,3]),rev(err_se[,4]),rev(err_se[,5]),rev(err_se[,6]),rev(err_se[,7]),rev(err_se[,8]),rev(err_se[,9]))
#               )
ggplot(data=df4,aes(n,values,color=forcats::fct_inorder(privacy)))+geom_line(size=0.6)+
  geom_point(aes(n,values,fill=forcats::fct_inorder(privacy)),shape=23)+
  geom_errorbar(aes(ymax = values+se, ymin = values - se,color=forcats::fct_inorder(privacy)),width=0.1)+
  xlab("sample size")+
  ylab("mean squared error")+
  scale_x_discrete(limits=c(100,200,300,500,750,1000,1500,2000))+
  scale_y_continuous(trans='log10',limits=c(0.001,100),breaks = c(100,10,1,0.1,0.01,0.001),labels = c(pretty10exp(100,drop.1 = T),pretty10exp(10,drop.1 = T),pretty10exp(1,drop.1 = T),pretty10exp(0.1,drop.1 = T),pretty10exp(0.01,drop.1 = T),pretty10exp(0.001,drop.1 = T))) +
  scale_x_continuous(trans='log10',breaks = c(100,200,300,500,1000,2000)) +
  scale_color_manual(values=c("red","green","#528B8B","purple","#8B0A50","blue", "#EE1289","black"))+
  scale_fill_manual(values=c("red", "green","#528B8B","purple","#8B0A50","blue","#EE1289","black"))+
  coord_fixed(ratio=0.25)+
  theme(legend.title = element_blank(),
        legend.key.size = unit(0.5, "cm"),
        legend.position = c(0.5,0.1),text=element_text(size=17),legend.direction="horizontal")
  
#Fig S1.(a)
#Trade-off fig for mean est
df5=data.frame(t=c((0:100)/100,#0.4
                   (0:100)/100,#0.8
                   (0:100)/100,#1.6
                   (0:100)/100,#3.2
                   (0:100)/100,#6.4
                   (0:100)/100,#1
                   (0:100)/100,#0.5
                   (0:200)/200,
                   rep(0,201)),
               values=c(
                 (1-exp(0.4)*(0:100)/100+exp(-0.4)*(1-(0:100)/100)+abs(1-exp(0.4)*(0:100)/100-exp(-0.4)*(1-(0:100)/100)))/2,
                 (1-exp(0.8)*(0:100)/100+exp(-0.8)*(1-(0:100)/100)+abs(1-exp(0.8)*(0:100)/100-exp(-0.8)*(1-(0:100)/100)))/2,
                 (1-exp(1.6)*(0:100)/100+exp(-1.6)*(1-(0:100)/100)+abs(1-exp(1.6)*(0:100)/100-exp(-1.6)*(1-(0:100)/100)))/2,
                 (1-exp(3.2)*(0:100)/100+exp(-3.2)*(1-(0:100)/100)+abs(1-exp(3.2)*(0:100)/100-exp(-3.2)*(1-(0:100)/100)))/2,
                 (1-exp(6.4)*(0:100)/100+exp(-6.4)*(1-(0:100)/100)+abs(1-exp(6.4)*(0:100)/100-exp(-6.4)*(1-(0:100)/100)))/2,
                 pnorm(qnorm(1-(0:100)/100)-mu),
                 pnorm(qnorm(1-(0:100)/100)-mu/2),
                 rep(0,201),
                 (0:200)/200),
               class=factor(c(rep("0.4-LDP",101),
                              rep("0.8-LDP",101),
                              rep("1.6-LDP",101),
                              rep("3.2-LDP",101),
                              rep("6.4-LDP",101),
                              rep("1-GLDP",101),
                              rep("0.5-GLDP",101),
                              rep("Non-private",201),
                              rep("nonpriv",201)),levels=c("0.4-LDP","0.8-LDP","1.6-LDP","3.2-LDP","6.4-LDP","1-GLDP","0.5-GLDP","Non-private","nonpriv")
               )
)

ggplot(data =df5,aes(t,values,color=forcats::fct_inorder(class))) +geom_line(size=0.6)+
  #  geom_line(aes(rep(0,101),(0:100)/100,color='Non-private'),size=0.6)+
  scale_color_manual(values = c("0.4-LDP"='red',"0.8-LDP"="#528B8B","1.6-LDP"="#8B0A50","3.2-LDP"="#EE1289","6.4-LDP"='green',"0.5-GLDP"='purple',"1-GLDP"='blue',"Non-private"='black',"nonpriv"='black'),breaks = c("0.4-LDP","0.8-LDP","1.6-LDP","3.2-LDP","6.4-LDP","0.5-GLDP","1-GLDP","Non-private"))+
  coord_fixed(ratio = 1)+#"red","purple","#528B8B","blue","#8B0A50", "#EE1289","green","black"
  xlab(expression(italic(alpha)))+
  ylab(expression(italic(f(alpha))))+
  theme(legend.title = element_blank(),legend.key.size = unit(0.5, "cm"),legend.position = c(0.785,0.75),text=element_text(size=21),
        axis.title.x=element_text(family=fonts()[1], face = "italic"),
        axis.title.y=element_text(family=fonts()[1], face = "italic"))

#Fig S1.(b)
err_mean_1=matrix(as.numeric(as.matrix(read_excel("Mean_est_mean_table.xlsx"))),ncol=9)
err_se_1=matrix(as.numeric(as.matrix(read_excel("Mean_est_variance_table.xlsx"))),ncol=9)
n=c(10,25,50,75,100)
df6=data.frame(n=rep(n,8),
               values=c(rev(as.matrix(err_mean_1[,2])),rev(as.matrix(err_mean_1[,6])),rev(as.matrix(err_mean_1[,3])),rev(as.matrix(err_mean_1[,7])),rev(as.matrix(err_mean_1[,4])),rev(as.matrix(err_mean_1[,8])),rev(as.matrix(err_mean_1[,5])),rev(as.matrix(err_mean_1[,9]))),
               privacy=c(rep("0.4-LDP",5),rep("6.4-LDP",5),rep("0.8-LDP",5),rep("0.5-GLDP",5),rep("1.6-LDP",5),rep("1-GLDP",5),rep("3.2-LDP",5),rep("Non-private",5)),
               se=c(rev(err_se_1[,2]),rev(err_se_1[,6]),rev(err_se_1[,3]),rev(err_se_1[,7]),rev(err_se_1[,4]),rev(err_se_1[,8]),rev(err_se_1[,5]),rev(err_se_1[,9]))
)
ggplot(data=df6,aes(n,values,color=forcats::fct_inorder(privacy)))+geom_line(size=0.6)+
  geom_point(aes(n,values,fill=forcats::fct_inorder(privacy)),shape=23)+
  geom_errorbar(aes(ymax = values+se, ymin = values - se,color=forcats::fct_inorder(privacy)),width=0.1)+
  xlab("sample size")+
  ylab("mean squared error")+
  scale_x_discrete(limits=c(10,25,50,75,100))+  
  scale_color_manual(values=c("red","green","#528B8B","purple","#8B0A50","blue", "#EE1289","black"))+
  scale_fill_manual(values=c("red", "green","#528B8B","purple","#8B0A50","blue","#EE1289","black"))+
  scale_x_continuous(trans='log10',breaks = c(10,25,50,75,100))+
  scale_y_continuous(limits=c(-1,6),breaks = c(0,2,4))+
  coord_fixed(ratio=0.16)+
  theme(legend.title = element_blank(),
        legend.key.size = unit(0.5, "cm"),
        legend.position = c(0.5,0.07),text=element_text(size=14),legend.direction="horizontal")
