import logging
from .utils import Configurations, unpack_configs_from_hdf5
import os
from typing import Dict

#The Machine Learning landscape of top taggers, Kasieczka, Gregor and al

def load(directory: str, top_n_objs = 64) -> Dict[str, Configurations]:
    logging.info('Loading Tag Jet Dataset')
    path_train = os.path.join(directory, 'train.h5')
    path_valid = os.path.join(directory, 'val.h5')
    return unpack_configs_from_hdf5(path=path_train, top_n_objs=top_n_objs), unpack_configs_from_hdf5(path=path_valid, top_n_objs=top_n_objs)

