import random

def gen_input(n):
    input_str = str(n) + '\n'
    cells = set()
    while len(cells) < n:
        x = random.randint(-10 ** 9, 10 ** 9)
        y = random.randint(-10 ** 9, 10 ** 9)
        if (x, y) not in cells:
            cells.add((x, y))
    colors = [1, 2, 3] * (n // 3)
    random.shuffle(colors)
    for ((x, y), c) in zip(cells, colors):
        input_str += f'{x} {y} {c}\n'
    return input_str

def batch_gen_inputs(batch_size,):
    test_cases = []
    n_list = [3, 6, 9, 12, 15]
    for _ in range(batch_size):
        test_cases.append(gen_input(random.choice(n_list)))
    return test_cases
