import random

def gen_input(num_cases: int) -> str:
    """Generate test input for the problem"""
    input_str = str(num_cases) + '\n'
    for _ in range(num_cases):
        n = random.randint(1, 1000)
        input_str += str(n) + '\n'
    return input_str

def batch_gen_inputs(batch_size,) -> list:
    """Generate a batch of test inputs"""
    test_inputs = []
    for _ in range(batch_size):
        num_cases = random.randint(1, 100)
        test_input = gen_input(num_cases)
        test_inputs.append(test_input)
    return test_inputs
