# TEST_RESULT: True
from typing import List
from itertools import combinations


def eliminate(arr: List[int], indices: List[int]) -> List[int]:
    """Performs the elimination operation on the given array using the provided indices."""
    x = min([arr[i] for i in indices])
    for i in indices:
        arr[i] -= x
    return arr

def is_zero(arr: List[int]) -> bool:
    """Checks if all elements of the array are zero."""
    return all((a == 0 for a in arr))

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    t = int(lines[0])
    lines = lines[1:]
    results = []
    for _ in range(t):
        n = int(lines[0])
        arr = list(map(int, lines[1].split()))
        lines = lines[2:]
        valid_ks = []
        for k in range(1, n + 1):
            for comb in combinations(range(n), k):
                arr_after_elim = eliminate(arr.copy(), comb)
                if is_zero(arr_after_elim):
                    valid_ks.append(k)
                    break
        results.append(' '.join(map(str, valid_ks)))
    return '\n'.join(results)
