import random


def gen_input(num_nodes: int, num_edges: int) -> str:
    N = random.randint(2, num_nodes)
    M = random.randint(1, min(num_edges, N * (N - 1) // 2))
    edges = set()
    while len(edges) < M:
        U = random.randint(1, N)
        V = random.randint(1, N)
        if U != V:
            edges.add(tuple(sorted((U, V))))
    input_str = f'{N} {M}\n'
    for (U, V) in edges:
        input_str += f'{U} {V}\n'
    return input_str

def batch_gen_inputs(batch_size,) -> list[str]:
    inputs = []
    for _ in range(batch_size):
        inputs.append(gen_input(10, 15))
    return inputs
