import random

def gen_input(n: int, q: int) -> str:
    """
    Generate a single test input for the bubble popping game.

    Parameters:
    n (int): The number of bubbles.
    q (int): The number of finalists.

    Returns:
    str: The generated test input.
    """
    bubbles = ['{} {}'.format(random.randint(-10 ** 9, 10 ** 9), random.randint(-10 ** 9, 10 ** 9)) for _ in range(n)]
    finalists = ['{} {} {}'.format(random.randint(-10 ** 9, 10 ** 9), random.randint(-10 ** 9, 10 ** 9), random.randint(1, n)) for _ in range(q)]
    return '{}\n{}\n{}\n{}'.format(n, '\n'.join(bubbles), q, '\n'.join(finalists))

def batch_gen_inputs(batch_size,) -> list:
    """
    Generate a batch of test inputs for the bubble popping game.

    Returns:
    list: The list of generated test inputs.
    """
    inputs = [gen_input(random.randint(1, 10), random.randint(1, 10)) for _ in range(batch_size)]
    return inputs
