import random


def gen_input(t_max=100, n_max=1000):
    t = random.randint(1, t_max)
    input_str = str(t) + '\n'
    for _ in range(t):
        n = random.randint(2, n_max // 2) * 2
        input_str += str(n) + '\n'
        for _ in range(n):
            days = [0] * 5
            convenient_day = random.randint(0, 4)
            days[convenient_day] = 1
            for i in range(5):
                if i != convenient_day and random.random() < 0.5:
                    days[i] = 1
            input_str += ' '.join(map(str, days)) + '\n'
    return input_str

def batch_gen_inputs(batch_size,):
    inputs = []
    for _ in range(batch_size):
        inputs.append(gen_input(t_max=10, n_max=20))
    return inputs
