# TEST_RESULT: True
from itertools import product

def is_rainbow_path(path, edge_coloring):
    colors = set()
    for i in range(len(path) - 1):
        edge = (path[i], path[i + 1])
        color = edge_coloring[edge]
        colors.add(color)
    return len(colors) >= 2

def is_valid_coloring(edge_coloring, n, k):
    for i in range(1, n + 1):
        for j in range(i + 1, n + 1):
            for path_length in range(k, n):
                if j + path_length - 1 > n:
                    continue
                path = list(range(i, j + path_length))
                if not is_rainbow_path(path, edge_coloring):
                    return False
    return True

def solution(stdin: str) -> str:
    (n, k) = map(int, stdin.split())
    edges = [(i, j) for i in range(1, n) for j in range(i + 1, n + 1)]
    c = 1
    while True:
        colorings = product(range(1, c + 1), repeat=len(edges))
        for coloring in colorings:
            edge_coloring = {edges[i]: coloring[i] for i in range(len(edges))}
            if is_valid_coloring(edge_coloring, n, k):
                result = str(c) + '\n' + ' '.join(map(str, coloring))
                return result
        c += 1
