% Experiment 1.0 - CVV-Pro only - Fraction of Violated Constraints
%
clear all
load('cvv-pro/test.mat')

figure
x = [1:10:Nrounds-1];
plot(x,mean(fractionViolatedConstraints(x),1))
xlabel('rounds')
ylabel('Fraction of Violated Constraints')
saveas(gcf,'results/FractionOfViolatedConstraints.fig')



% Experiment 2.1 - Projection Time
%
clear all
load('cvv-pro/test.mat')

figure
x = [1:10:Nrounds-1];
plot(x, mean(localTimes(x),1))
hold on

clear all
load('ogd/test.mat')

x = [1:10:Nrounds-1];
plot(x, mean(localTimes(x),1))
hold off
xlabel('rounds')
ylabel('Projection Time (s)')
legend('CVV-Pro','OGD', 'Location','NorthEast')
saveas(gcf,'results/ProjectionTime.fig')



% Experiment 2.2 - Projection Time
%
D = ones(2,200);

clearvars -except D 
load('cvv-pro/test.mat')

x = [1:10:Nrounds-1];
D(1,:) = mean(localTimes(x),1);

clearvars -except D 
load('ogd/test.mat')

x = [1:10:Nrounds-1];
D(2,:) = mean(localTimes(x),1);

figure
cla()
boxplot(D', 'symbol', '', 'labels', {'CVV-Pro','OGD'})
ylabel('iteration projection time (s)')
ylim([0, 0.25])
saveas(gcf,'results/IterationProjectionTime.fig')



% Experiment 2.3 - Projection Time
%
clear all
load('cvv-pro/test.mat')

figure
x = [1:10:Nrounds-1];
plot(x, cumsum(mean(localTimes(x),1)))
hold on

clear all
load('ogd/test.mat')

x = [1:10:Nrounds-1];
plot(x, cumsum(mean(localTimes(x),1)))
hold off
xlabel('rounds')
ylabel('total projection time (s)')
legend('CVV-Pro','OGD', 'Location','NorthWest')
saveas(gcf,'results/TotalProjectionTime.fig')



% Experiment 3.0 - Regret
%
clear all
load('cvv-pro/test.mat')

min_regret = min(regret, [], 1);
max_regret = max(regret, [], 1);
mean_regret = (1/sn) .* sum(regret, 1);

figure
x = [1:10:Nrounds-1];
plot(x, mean_regret(x), 'b', 'LineWidth', 1)
hold on
plot(x, min_regret(x), 'b', 'LineWidth', 0.1, 'HandleVisibility', 'off')
plot(x, max_regret(x), 'b', 'LineWidth', 0.1, 'HandleVisibility', 'off')

clear all
load('ogd/test.mat')

min_regret = min(regret, [], 1);
max_regret = max(regret, [], 1);
mean_regret = (1/sn) .* sum(regret, 1);

x = [1:10:Nrounds-1];

plot(x, mean_regret(x), 'r', 'LineWidth', 1)
plot(x, min_regret(x), 'r', 'LineWidth', 0.1, 'HandleVisibility', 'off')
plot(x, max_regret(x), 'r', 'LineWidth', 0.1, 'HandleVisibility', 'off')
plot(x, 5.*sqrt(x), '--', 'color', '#77AC30', 'LineWidth', 1)
hold off
xlim([1 Nrounds])
xlabel('rounds')
ylabel('regret')
legend('CVV-Pro', 'OGD', '5*sqrt(x)', 'Location','NorthWest')
saveas(gcf,'results/regret.fig')

