def get_metric_objects(filename, examples = 5):
    with open(filename, 'r') as f:
        metrics = f.read().splitlines()

    psnr_sorted = sorted(metrics, reverse=True, key=lambda x:float(x.split('\t')[1]))

    object_ids = [metric.split('\t')[0] for metric in psnr_sorted]

    debug = True
    if debug:
        print(psnr_sorted[:examples])

    return object_ids[:examples]


if __name__ == '__main__':
    filename = '../metrics/abo_chairs_512_metrics.txt'

    object_ids = get_metric_objects(filename, examples = 10)

    print(object_ids)