import pandas as pd
import random 
import time
import os

# from cp_infinite import data_model
# from res_gp import resgp
from model_dec.conAR import data_model as conAR
from model_dec.res_gp import resgp as resgp
from model_dec.ar import ar as ar
 
'''initial setting'''

# 'Poisson_mfGent_v5', 'Heat_mfGent_v5', 'Burget_mfGent_v5_15', 'TopOP_mfGent_v6', 'plasmonic2_MF'
data_name_list = ['TopOP_mfGent_v6']
model_list = {'conAR': conAR, 'resgp': resgp, 'ar': ar}

model_name = ['conAR', 'resgp', 'ar']
 
seed = [0, 1, 2, 3, 4]
dec_rate = 0.75
fidelity_num = 5

for data_name in data_name_list:
        for k in seed:
                recording = {}
                for i in model_name:
                        recording[i] = {'train_sample_num':[], 'rmse':[], 'nrmse':[], 'r2':[], 'nll':[], 'time':[]}
                for _name in model_name:
                        for train_sample_num in [32, 64, 96, 128]:
                                random.seed(k)
                                model = model_list[_name]
                                T1 = time.time()
                                mod = model(data_name,
                                        train_begin_index = 0, 
                                        test_begin_index = 0,
                                        train_samples_num = train_sample_num, 
                                        test_samples_num = 128, 
                                        # test_samples_num = 100,
                                        dec_rate = dec_rate,
                                        fidelity_num = fidelity_num,
                                        seed = k,
                                        need_inerp = True)
                                T2 = time.time()
                                recording[_name]['train_sample_num'].append(train_sample_num)
                                recording[_name]['rmse'].append(mod['rmse'])
                                recording[_name]['nrmse'].append(mod['nrmse'])
                                recording[_name]['r2'].append(mod['r2'])
                                recording[_name]['nll'].append(mod['nll'])
                                recording[_name]['time'].append(T2 - T1)

                        path_csv = os.path.join( 'exp', str(_name), data_name, 'dec_'+ str(dec_rate))
                        if not os.path.exists(path_csv):
                                os.makedirs(path_csv)

                        data = {'train_sample_num': recording[_name]['train_sample_num'], 
                        'rmse': recording[_name]['rmse'],
                        'nrmse': recording[_name]['nrmse'], 
                        'r2': recording[_name]['r2'], 
                        'nll': recording[_name]['nll'], 
                        'time': recording[_name]['time']
                        }
                        df = pd.DataFrame(data)
                        df.to_csv(path_csv + '/result_' + str(k) + '.csv', index = False)