import numpy as np
import mne
from utils.extract_EEG_features import get_eeg_frequency_band_data


def sliding_window(
    signals, valence, arousal, subject_id, modality, use_wavelet, **options
):
    """Convert an array of X, Y values into a dataset matrix for a CNN"""

    look_back = options.pop("look_back", None)
    dataX, dataValenceScore, dataArousalScore = [], [], []

    # Sliding window step size
    step_size = look_back # no overlap

    if modality == "eeg": print('Extracting EEG features from frequency bands (please wait)...')
    if use_wavelet: print('Extracting wavelet decomposition features (please wait)...')

    # Loop through signals with 50% overlap
    for i in range(0, len(signals) - look_back + 1, step_size):
        windowed_signals = signals[i : (i + look_back)]
        windowed_valence = valence[i : (i + look_back)]
        windowed_arousal = arousal[i : (i + look_back)]

        if modality == "eeg":
            # Convert EEG signals to frequency bands for each window
            windowed_signals = get_eeg_frequency_band_data(
                windowed_signals, use_wavelet
            )

        dataX.append(windowed_signals)
        dataValenceScore.append(windowed_valence)
        dataArousalScore.append(windowed_arousal)

    # Generate a single most frequently occurring label for each window
    dataValenceScore = [np.argmax(np.bincount(x.astype(int))) for x in dataValenceScore]
    dataArousalScore = [np.argmax(np.bincount(x.astype(int))) for x in dataArousalScore]

    return np.array(dataX), np.array(dataValenceScore), np.array(dataArousalScore)
