#pragma once
#include <random>
#include <vector>
#include <cstddef>
struct bandit{
    size_t K;
    size_t D;
    double H;
    size_t seed{42};
    double sigma;
    std::mt19937 gen;
    size_t optimal_arm; //  only defined for 1d bandit
    std::vector<double> suboptimal_gaps;
    std::vector<size_t> action_space;
    std::vector<size_t> optimal_arms;
    std::vector<std::vector<double>> arms_means;
    std::vector<std::vector<double>> cov;
    bandit() = default;
    explicit bandit(const std::vector<std::vector<double>>&);
    virtual std::vector<std::vector<double>> sample(const std::vector<size_t>&)=0;
    void reset_env(size_t);
};
struct bernoulli: bandit{
    bernoulli() = default;
    explicit bernoulli(const std::vector<std::vector<double>>&);
    std::vector<std::vector<double>> sample(const std::vector<size_t> &) override;
};

struct gaussian: bandit {
    gaussian() = default;
    gaussian(const std::vector<std::vector<double>> &means,const std::vector<double>& stddev);
    std::vector<std::vector<double>> sample(const std::vector<size_t> &) override;
    std::vector<double> stddev;
};