# Why Did This Model Forecast This Future? Information-Theoretic Saliency for Counterfactual Explanations of Probabilistic Regression Models

## Requirements

Dependencies can be installed in a conda environment using `environment.yml`:

```setup
conda env create -f environment.yml
```

## Code Organization

Here's a brief overview of the main directories in this repo:

- **dataset** : contains the synthesized conversation dataset
- **data/**: contains code for data generation, preprocessing, loading, and custom type definition used throughout the codebase.
- **explainability/**: contains code for computing closed-form saliency in given forecasts
- **run/**: contains executable script for reproducing the empirical demonstration for the paper

## Reproducing Paper Results

For reproducing the results from the paper, run the following command from the root directory of this repository:

```
python -m run.run_empirical_demo --csv synthetic-conversation.csv --group_id 1 --obs_window1 1063 1163 --fut_window1 1163 1208 --obs_window2 223 323 --fut_window2 323 368 --time_stride 3 --overlap 0.95 --future_len 15 --batch_size 64
```

## License

This repository (including all its contents) is available under the MIT license.
