

# Main experiments
Use one of the following commands to train an agent on distracted Walker Walk.

```
# RePo
python experiments/train_dreamer.py --algo dreamer_invariant --env_id dmc_distracted-walker-walk --expr_name benchmark --seed 0

# Dreamer 
python experiments/train_dreamer.py --algo dreamer --env_id dmc_distracted-walker-walk --expr_name benchmark --seed 0

# TIA 
python experiments/train_dreamer.py --algo tia --env_id dmc_distracted-walker-walk --expr_name benchmark --seed 0

# DBC
python experiments/train_bisim.py --algo bisim --env_id dmc_distracted-walker-walk --expr_name benchmark --seed 0

# DeepMDP
python experiments/train_bisim.py --algo bisim --env_id dmc_distracted-walker-walk --expr_name benchmark --seed 0
```

# Adaptation experiments
To run adaptation experiments, first train an agent on the source domain and save the replay buffer:
```
python experiments/train_dreamer.py --algo dreamer_invariant --env_id dmc-walker-walk --expr_name benchmark --seed 0 --save_buffer True
```
Then run the adaptation experiment on the target domain using one of the following commands:
```
# Support constraint + calibration
python experiments/adapt_dreamer.py --algo dreamer_calibrate --env_id dmc_distracted-walker-walk --expr_name adaptaion --source_dir logdir/dreamer_invariant/dmc-walker-walk/benchmark/0 --seed 0

# Distribution matching + calibration
python experiments/adapt_dreamer.py --algo dreamer_calibrate --env_id dmc_distracted-walker-walk --expr_name adaptaion --source_dir logdir/dreamer_invariant/dmc-walker-walk/benchmark/0 --seed 0 --alignment_mode distribution
```