% Experiment 1. DSEPL/DSEGD vs. SEPL/SEGD inner running script
% The purpose of this experiment is to show the effect of momentum for SPL
% and SGD. The script is launched with all the algorithm parameters ready

fprintf("%s\n", sub_exp);

% SGD + SPL
sgditer2opt  = ones(ntest, nalpha) * maxiter * m;
spliter2opt  = ones(ntest, nalpha) * maxiter * m;

% SEGD + SEPL
segditer2opt = ones(ntest, nalpha) * maxiter * m;
sepliter2opt = ones(ntest, nalpha) * maxiter * m;

% DSGD + DSPL
dsgditer2opt  = ones(ntest, nalpha) * maxiter * m;
dspliter2opt  = ones(ntest, nalpha) * maxiter * m;

% DSEGD + DSEPL
dsegditer2opt = ones(ntest, nalpha) * maxiter * m;
dsepliter2opt = ones(ntest, nalpha) * maxiter * m;


for i = 1:nalpha

    test_sgd = true;
    test_spl = true;
    test_segd = true;
    test_sepl = true;
    test_dsgd = true;
    test_dspl = true;
    test_dsegd = true;
    test_dsepl = true;
    
    alpha_0 = alpharange(i);
    
    for k = 1:ntest
        
        % SGD + SPL
        if test_sgd
            [sgdsol, sgdinfo] = proxsgd(A, b, gamma, 0.0, init_x, maxiter, tol, ...
                early_stop, alpha_0, show_info);
        end % End if
        
        if sgdinfo.niter >= maxiter * m - 1
            test_sgd = false;
        end % End if
        
        if test_spl
            [splsol, splinfo] = proxlin(A, b, gamma, 0.0, init_x, maxiter, tol, ...
                early_stop, alpha_0, show_info);
        end % End if
        
        if splinfo.niter >= maxiter * m - 1
            test_spl = false;
        end % End if
        
        % SEGD + SPL
        if test_segd
            [segdsol, segdinfo] = proxsgd(A, b, gamma, beta, init_x, maxiter, tol, ...
                early_stop, alpha_0, show_info);
        end % End if
        
        if segdinfo.niter >= maxiter * m - 1
            test_segd = false;
        end % End if
        
        if test_sepl
            [seplsol, seplinfo] = proxlin(A, b, gamma, beta, init_x, maxiter, tol, ...
                early_stop, alpha_0, show_info);
        end % End if
        
        if seplinfo.niter >= maxiter * m - 1
            test_sepl = false;
        end % End if
        
        % DSGD + DSPL
        if test_dsgd
            [dsgdsol, dsgdinfo] = proxsgdtau(A, b, gamma, 0.0, init_x, maxiter, tol, ...
                early_stop, alpha_0, taups, show_info);
        end % End if
        
        if dsgdinfo.niter >= maxiter * m - 1
            test_dsgd = false;
        end % End if
        
        if test_dspl
            [dsplsol, dsplinfo] = proxlintau(A, b, gamma, 0.0, init_x, maxiter, tol, ...
                early_stop, alpha_0, taups, show_info);
        end % End if
        
        if dsplinfo.niter >= maxiter * m - 1
            test_dspl = false;
        end % End if
        
        % DSEGD + DSEPL
        if test_dsegd
            [dsegdsol, dsegdinfo] = proxsgdtau(A, b, gamma, beta, init_x, maxiter, tol, ...
                early_stop, alpha_0, taups, show_info);
        end % End if
        
        if dsegdinfo.niter >= maxiter * m - 1
            test_dsegd = false;
        end % End if
        
        if test_dsepl
            [dseplsol, dseplinfo] = proxlintau(A, b, gamma, beta, init_x, maxiter, tol, ...
                early_stop, alpha_0, taups, show_info);
        end % End if
        
        if dseplinfo.niter >= maxiter * m - 1
            test_dsepl = false;
        end % End if
        
        % Collect information
        sgditer2opt(k, i) = sgdinfo.niter;
        spliter2opt(k, i) = splinfo.niter;
        
        segditer2opt(k, i) = segdinfo.niter;
        sepliter2opt(k, i) = seplinfo.niter;
        
        dsgditer2opt(k, i) = dsgdinfo.niter;
        dspliter2opt(k, i) = dsplinfo.niter;
        
        dsegditer2opt(k, i) = dsegdinfo.niter;
        dsepliter2opt(k, i) = dseplinfo.niter;
        
    end % End for
end % End for



save(mat_name);

