% Experiment 1. DSEPL/DSEGD vs. SEPL/SEGD inner running script
% The purpose of this experiment is to show the effect of momentum for SPL
% and SGD. The script is launched with all the algorithm parameters ready

fprintf("%s\n", sub_exp);

% SGD + SPL
sgditer2opt  = zeros(ntest, nalpha);
spliter2opt  = zeros(ntest, nalpha);

% SEGD + SEPL
segditer2opt = zeros(ntest, nalpha);
sepliter2opt = zeros(ntest, nalpha);

% DSGD + DSPL
dsgditer2opt  = zeros(ntest, nalpha);
dspliter2opt  = zeros(ntest, nalpha);

% DSEGD + DSEPL
dsegditer2opt = zeros(ntest, nalpha);
dsepliter2opt = zeros(ntest, nalpha);


for i = 1:nalpha
    alpha_0 = alpharange(i);
    
    for k = 1:ntest
        
        % SGD + SPL
        [sgdsol, sgdinfo] = proxsgd(A, b, gamma, 0.0, init_x, maxiter, tol, ...
            early_stop, alpha_0, show_info);
        [splsol, splinfo] = proxlin(A, b, gamma, 0.0, init_x, maxiter, tol, ...
            early_stop, alpha_0, show_info);
        
        % SEGD + SPL
        [segdsol, segdinfo] = proxsgd(A, b, gamma, beta, init_x, maxiter, tol, ...
            early_stop, alpha_0, show_info);
        [seplsol, seplinfo] = proxlin(A, b, gamma, beta, init_x, maxiter, tol, ...
            early_stop, alpha_0, show_info);
        
        % DSGD + DSPL
        [dsgdsol, dsgdinfo] = proxsgdtau(A, b, gamma, 0.0, init_x, maxiter, tol, ...
            early_stop, alpha_0, taups, show_info);
        [dsplsol, dsplinfo] = proxlintau(A, b, gamma, 0.0, init_x, maxiter, tol, ...
            early_stop, alpha_0, taups, show_info);
        
        % DSEGD + DSEPL
        [dsegdsol, dsegdinfo] = proxsgdtau(A, b, gamma, beta, init_x, maxiter, tol, ...
            early_stop, alpha_0, taups, show_info);
        [dseplsol, dseplinfo] = proxlintau(A, b, gamma, beta, init_x, maxiter, tol, ...
            early_stop, alpha_0, taups, show_info);
        
        % Collect information
        sgditer2opt(k, i) = sgdinfo.niter;
        spliter2opt(k, i) = splinfo.niter;
        
        segditer2opt(k, i) = segdinfo.niter;
        sepliter2opt(k, i) = seplinfo.niter;
        
        dsgditer2opt(k, i) = dsgdinfo.niter;
        dspliter2opt(k, i) = dsplinfo.niter;
        
        dsegditer2opt(k, i) = dsegdinfo.niter;
        dsepliter2opt(k, i) = dseplinfo.niter;
        
    end % End for
end % End for



save(mat_name);

