% Experiment 1. DSEPL/DSEGD vs. SEPL/SEGD outer running script
clear; clc; close all;

% Experiment information
exp_time = datetime;
exp_name = "E1. DSEPL/DSEGD vs. SEPL/SEGD outer running script";

% Data configuration
kapparange = [1, 10];
pfailrange = [2, 3];

addpath(fullfile('..', '..', 'data'));

ntest      = 20;
nalpha     = 10;
alpharange = logspace(-2, 1, nalpha);
betarange  = [0.6];
maxiter    = 400;
early_stop = true;
tauubrange = logspace(1, 3, 10);
typerange  = ['p', 'c', 'g'];
show_info  = false;

for kappa = kapparange
    for pfail = pfailrange
        load("kappa_" + kappa + "_pfail_" + pfail + ".mat");
        
        rng(100);
        
        A = data.A;
        b = data.b;
        [m, n] = size(A);
        
        init_x = randn(n, 1);
        init_x = init_x / norm(init_x);
        gamma = sqrt(maxiter * m);
        tol = data.bestloss * 1.5;
        
        for beta = betarange
            for ub = tauubrange
                tauub = ceil(ub);
                for type = typerange
                    tic;
                    
                    if type == 'p'
                        p = tauub / 2;
                    elseif type == 'c'
                        p = 0.0;
                    else
                        p = 2 / tauub;
                    end % End if
                    
                    taups = genpmf(p, ceil(tauub), type);
                    
                    sub_exp = "E1. beta: " + beta +...
                        " tauub: " + tauub + " type: " + type;
                    mat_name = "E1_kappa_" + kappa + "_pfail_" + pfail + "_beta_" + beta * 10 +...
                        "_tauub_" + tauub + "_type_" + type + ".mat";
                    exp_inner_1;
                    t = toc;
                    fprintf("T: %f\n\n", t);
                    
                end % End for
            end % End for
        end % End for
        
    end % End for
end % End for






