% Experiment 1. DSEPL/DSEGD vs. SEPL/SEGD inner running script (BlindDeconv)
% The purpose of this experiment is to show the effect of momentum for SPL
% and SGD. The script is launched with all the algorithm parameters ready

fprintf("%s\n", sub_exp);

% SGD + SPL
sgditer2opt  = ones(ntest, nalpha) * maxiter * m;
spliter2opt  = ones(ntest, nalpha) * maxiter * m;

% SEGD + SEPL
segditer2opt = ones(ntest, nalpha) * maxiter * m;
sepliter2opt = ones(ntest, nalpha) * maxiter * m;

% DSGD + DSPL
dsgditer2opt  = ones(ntest, nalpha) * maxiter * m;
dspliter2opt  = ones(ntest, nalpha) * maxiter * m;

% DSEGD + DSEPL
dsegditer2opt = ones(ntest, nalpha) * maxiter * m;
dsepliter2opt = ones(ntest, nalpha) * maxiter * m;

for i = 1:nalpha
    alpha_0 = alpharange(i);
    
    test_sgd = true;
    test_spl = true;
    test_segd = true;
    test_sepl = true;
    test_dsgd = true;
    test_dspl = true;
    test_dsegd = true;
    test_dsepl = true;
    
    for k = 1:ntest
        
        % SGD + SPL
        if test_sgd
            [sgdsol, sgdinfo] = proxsgdblind(U, V, b, gamma, 0.0, init_z, maxiter, tol, ...
                early_stop, alpha_0, show_info);
        end % End if
        
        if sgdinfo.status ~= "*"
            test_sgd = false;
            sgdinfo.niter = maxiter * m;
        end % End if
        
        if test_spl
            [splsol, splinfo] = proxlinblind(U, V, b, gamma, 0.0, init_z, maxiter, tol, ...
                early_stop, alpha_0, show_info);
        end % End if
        
        if splinfo.status ~= "*"
            test_spl = false;
            splinfo.niter = maxiter * m;
        end % End if
        
        % SEGD + SPL
        if test_segd
            [segdsol, segdinfo] = proxsgdblind(U, V, b, gamma, beta, init_z, maxiter, tol, ...
                early_stop, alpha_0, show_info);
        end % End if
        
        if segdinfo.status ~= "*"
            test_segd = false;
            segdinfo.niter = maxiter * m;
        end % End if
        
        if test_sepl
            [seplsol, seplinfo] = proxlinblind(U, V, b, gamma, beta, init_z, maxiter, tol, ...
                early_stop, alpha_0, show_info);
        end % End if
        
        if seplinfo.status ~= "*"
            test_sepl = false;
            seplinfo.niter = maxiter * m;
        end % End if
        
        % DSGD + DSPL
        if test_dsgd
            [dsgdsol, dsgdinfo] = proxsgdtaublind(U, V, b, gamma, 0.0, init_z, maxiter, tol, ...
                early_stop, alpha_0, taups, show_info);
        end % End if
        
        if dsgdinfo.status ~= "*"
            test_dsgd = false;
            dsgdinfo.niter = maxiter * m;
        end % End if
        
        if test_dspl
            [dsplsol, dsplinfo] = proxlintaublind(U, V, b, gamma, 0.0, init_z, maxiter, tol, ...
                early_stop, alpha_0, taups, show_info);
        end % End if
        
        if dsplinfo.status ~= "*"
            test_dspl = false;
            dsplinfo.niter = maxiter * m;
        end % End if
        
        % DSEGD + DSEPL
        if test_dsegd
            [dsegdsol, dsegdinfo] = proxsgdtaublind(U, V, b, gamma, beta, init_z, maxiter, tol, ...
                early_stop, alpha_0, taups, show_info);
        end % End if
        
        if dsegdinfo.status ~= "*"
            test_dsegd = false;
            dsegdinfo.niter = maxiter * m;
        end % End if
        
        if test_dsepl
            [dseplsol, dseplinfo] = proxlintaublind(U, V, b, gamma, beta, init_z, maxiter, tol, ...
                early_stop, alpha_0, taups, show_info);
        end % End if
        
        if dseplinfo.status ~= "*"
            test_dsepl = false;
            dseplinfo.niter = maxiter * m;
        end % End if
        
        % Collect information
        sgditer2opt(k, i) = sgdinfo.niter;
        spliter2opt(k, i) = splinfo.niter;
        
        segditer2opt(k, i) = segdinfo.niter;
        sepliter2opt(k, i) = seplinfo.niter;
        
        dsgditer2opt(k, i) = dsgdinfo.niter;
        dspliter2opt(k, i) = dsplinfo.niter;
        
        dsegditer2opt(k, i) = dsegdinfo.niter;
        dsepliter2opt(k, i) = dseplinfo.niter;
        
    end % End for
end % End for



save(mat_name);

