### Readme

This **readme** file introduces the structure of the supplementary materials of paper  

```
Delayed Algorithms for Distributed Stochastic Weakly Convex Optimization
```

and the materials contain

``` supplementary/
supplementary/  									# Supplementary materials
├── exp 													# Experiments
│   ├── data 											# MATLAB data
│   ├── matlab										# MATLAB scripts
│   └── mpi												# MPI Python Implementation and test scripts
└── Readme.md											# This readme file
```

and we note that **the supplementary material fixes some typos in our earlier main submission and includes appendix sections on the proof and additional experiments**.

To reproduce the experiments, ensure that 

- Python (with Numpy, mpi4py package)
- MATLAB R20XX (XX >= 19)

 are both available. Then with paths properly set, one can execute

``` 
cd exp/mpi
# chmod +x *.sh 
./test_pr.sh		# Phase retrieval
./test_bl.sh    # Blind deconvolution
```

to reproduce the MPI experiments and execute the following scripts in MATLAB to repoduce the simulated experiments.

```test
test/
├── exp_inner_1_blind.m 
├── exp_inner_1.m				
├── exp_outer_2_robust.m  # Adversarial delay
├── exp_outer_1_blind.m		# Blind deconvolution
├── exp_outer_1.m					# Phase retrieval (synthetic)
└── exp_outer_1_zipcode.m	# Phase retrieval (Zipcode).
```

We note that the mainframe our MPI implementation is referenced from [1, 2].

### References

[1] Xu, Yangyang, et al. "Distributed Stochastic Inertial-Accelerated Methods with Delayed Derivatives for Nonconvex Problems." *SIAM Journal on Imaging Sciences* 15.2 (2022): 550-590.

[2] https://github.com/RPI-OPT/Inertial-SsGM
