%-------------------------------------------------------------------------%
% Filename: set_legend.m  
% Part of the paper "CS4ML: A general framework for active learning with
% arbitrary data based on Christoffel functions". 
%
% Description: generates legends for Figures in Appendix D, geometric 
% testing error vs the number of samples.
%-------------------------------------------------------------------------%
% Inputs:
% fig_num - figure number (either 1, 2 or 3)
% row_num - row number (either 1, 2 or 3) 
%-------------------------------------------------------------------------%

space = ' ';

if main_figure == 1
    name_curve_1 = ['$\tanh$',space,'$5\times50$','-', 'CAS'];  
    name_curve_2 = ['$\tanh$',space,'$5\times50$','-', 'MCS'];  
    name_curve_3 = ['sigmoid',space,'$5\times50$','-', 'CAS'];  
    name_curve_4 = ['sigmoid',space,'$5\times50$','-', 'MCS'];  

elseif fig_num == 1
    name_curve_1 = ['ReLU',space,'$5\times50$','-', 'CAS'];  
    name_curve_2 = ['ReLU',space,'$5\times50$','-', 'MCS'];  
    name_curve_3 = ['ELU',space,'$5\times50$','-', 'CAS'];  
    name_curve_4 = ['ELU',space,'$5\times50$','-', 'MCS'];  

elseif fig_num == 2
    if row_num == 1
        name_curve_1 = ['$\tanh$',space,'$3\times30$','-', 'CAS'];  
        name_curve_2 = ['$\tanh$',space,'$3\times30$','-', 'MCS'];  
        name_curve_3 = ['sigmoid',space,'$3\times30$','-', 'CAS'];  
        name_curve_4 = ['sigmoid',space,'$3\times30$','-', 'MCS'];  
    
    elseif row_num == 2
        name_curve_1 = ['ReLU',space,'$3\times30$','-', 'CAS'];  
        name_curve_2 = ['ReLU',space,'$3\times30$','-', 'MCS'];  
        name_curve_3 = ['ELU',space,'$3\times30$','-', 'CAS'];  
        name_curve_4 = ['ELU',space,'$3\times30$','-', 'MCS'];  
    else
        disp('incorrect row number try 1 or 2');
    end

elseif fig_num == 3
    if row_num == 1
        name_curve_1 = ['$\tanh$',space,'$10\times100$','-', 'CAS'];  
        name_curve_2 = ['$\tanh$',space,'$10\times100$','-', 'MCS'];  
        name_curve_3 = ['sigmoid',space,'$10\times100$','-', 'CAS'];  
        name_curve_4 = ['sigmoid',space,'$10\times100$','-', 'MCS'];  
    
    elseif row_num == 2
        name_curve_1 = ['ReLU',space,'$10\times100$','-', 'CAS'];  
        name_curve_2 = ['ReLU',space,'$10\times100$','-', 'MCS'];  
        name_curve_3 = ['ELU',space,'$10\times100$','-', 'CAS'];  
        name_curve_4 = ['ELU',space,'$10\times100$','-', 'MCS'];  
    else
        disp('incorrect row number try 1 or 2');
    end

else
    disp('incorrect fig_num: try 1, 2, or 3. Or main_figure = 1');
end

leg = legend(hPlot, name_curve_1, name_curve_2, name_curve_3, name_curve_4);

if isequal(['fig_AppD'],fig_name(1:8))
    if fig_num == 1
        location_plot = 'southeast';
    else
        location_plot = 'best';
    end
else
    location_plot = 'best';
end

num_cols = 1;
font_size = 20;

set(leg,'Interpreter','LaTex',...
        'Location',location_plot,...
        'color','white','box','on',...
        'fontsize',font_size,...
        'NumColumns',num_cols,...
        'Orientation','Horizontal');
