import jpype
import jpype.imports
from typing import Optional

import os


def ghidra_running() -> bool:
    """Checks whether Ghidra is running"""
    if jpype.isJVMStarted():
        from ghidra.framework import Application
        return Application.isInitialized()
    else:
        return False
        

def start_ghidra(jar_path: Optional[str] = None) -> None:
    """Starts Ghidra
    
    Args:
        jar_path: Path to Ghidra fat JAR. If not specified, read the path from the environment variable `GHIDRA_JAR`.
    """
    if jar_path is None:
        jar_path = os.environ['GHIDRA_JAR']
    if not jpype.isJVMStarted():
        jpype.startJVM("-Djava.locale.providers=COMPAT", classpath=[jar_path])
    
    from ghidra import GhidraJarApplicationLayout
    from ghidra.framework import HeadlessGhidraApplicationConfiguration, Application

    layout = GhidraJarApplicationLayout()
    configuration = HeadlessGhidraApplicationConfiguration()
    configuration.setInitializeLogging(False)

    Application.initializeApplication(layout, configuration)