# Replicable RL

# Installation

To install the python dependencies, run

```python
pip install -r requirements.txt
```

# Executing the code

Navigate to the base replicable_rl folder and execute 

```python
python main.py
```

This code-bases uses hydra-core to manage parameters which means you can either change the
parameters in the config/* files or overwrite them in the command line. As an example, 
in order to get the value function visualizations from the paper, exectute

```python
python main.py plot=True
```

You can change the algorithms using the keyword algo. Options are
* pvi
* replicable_pvi
* value_iteration

Additionally, to obtain the experiments in the paper, in the replicable_rpvi algorithm set 

* set_calls_to=(13000 * \<number you want\>)
* reprod_param=(0.2 * \<scaling of rho you want\>), the code will divide rho by num_states and num_actions to match the theoretical requirements. So, if you would list to have 0.2 / num_actions, you need to input 0.2 * num_states here.
