import random
import numpy as np

def getRandomPrime(lower, upper):
    primes = [i for i in range(lower,upper) if isPrime(i)]
    return random.choice(primes)

def isPrime(x):
    count = 0
    for i in range(int(x/2)):
        if x % (i+1) == 0:
            count = count+1
    return count == 1

def fastPower(a, b, p):
    '''a^b mod p'''
    a = a % p
    if a == 0:
        return 0

    res = 1
    while b > 0:
        if (b & 1) == 1: # odd
            res = (res * a) % p
        b = b >> 1 # divide by two
        a = (a * a) % p

    return res

class HashFns():
    def __init__(self, n):
        '''
        Initialize randomness for hash functions
        '''
        if n < 4501199:
            self.prime = 4501199
        else:
            self.prime = 2763947111 # getRandomPrime(2*n, 2*n+10000)
            assert(n < self.prime)
        self.cwSeed = np.random.randint(low=0, high=self.prime, size=4)

    def cwHash(self, item):
        '''Carter Wegman 4-wise independent hash'''
        # TODO: change to Dietzfelbinger?
        res = self.cwSeed[0]
        for k in range(1,4):
            res += (self.cwSeed[k] * fastPower(item, k, self.prime))
        res = res % self.prime

        return res 

if __name__ == "__main__":
    hashes = HashFns(10000)
    hashes.cwHash(20)
    hashes.cwHash(21)
