# sh feat_extractor.sh
DATA=~/efs/imagenet/
OUTPUT='./clip_feat/'
SEED=42
ENCODER=$1  # rn50, rn101, vit_b32 or vit_b16

# oxford_pets oxford_flowers fgvc_aircraft dtd eurosat stanford_cars food101 sun397 caltech101 ucf101 imagenet
for DATASET in imagenet # imagenet_21k
do
    for SPLIT in train val test
    do
        python feat_extractor.py \
        --split ${SPLIT} \
        --root ${DATA} \
        --seed ${SEED} \
        --dataset-config-file ../configs/datasets/${DATASET}.yaml \
        --config-file ../configs/trainers/CoOp/${ENCODER}_val.yaml \
        --output-dir ${OUTPUT} \
        --encoder ${ENCODER} \
        --eval-only
    done
done

# CUDA_VISIBLE_DEVICES=0 sh feat_extractor.sh rn50
# CUDA_VISIBLE_DEVICES=1 sh feat_extractor.sh vit_b32
# CUDA_VISIBLE_DEVICES=2 sh feat_extractor.sh vit_b16