#!/bin/bash

# custom config
#DATA=~/efs/CoOp/data/
DATA=~/efs/imagenet/
TRAINER=POMP
DATASET=$1
SEED=$2
TAG=$3
UNC=$4  # number of update class
EPOCH=$5

CFG=vit_b16_ep20
SHOTS=16
NCTX=16

if [ ! $EPOCH ]; then
  DIR=output/evaluation/${TRAINER}_${TAG}/${CFG}_unc${UNC}_${SHOTS}shots_nctx${NCTX}_best_val_${DATASET}/seed${SEED}
  if [ -d "$DIR" ]; then
      echo "Oops! The results exist at ${DIR} (so skip this job)"
  else
      python train.py \
      --root ${DATA} \
      --seed ${SEED} \
      --trainer ${TRAINER} \
      --dataset-config-file configs/datasets/${DATASET}.yaml \
      --config-file configs/trainers/${TRAINER}/${CFG}.yaml \
      --output-dir ${DIR} \
      --model-dir output/imagenet_21k/${TRAINER}_${TAG}/${CFG}_unc${UNC}_${SHOTS}shots/nctx${NCTX}_cscFalse_ctpend/seed${SEED} \
      --eval-only \
      TRAINER.POMP.N_CTX ${NCTX}
  fi
else
  DIR=output/evaluation/${TRAINER}_${TAG}/${CFG}_unc${UNC}_${SHOTS}shots_nctx${NCTX}_epoch${EPOCH}_${DATASET}/seed${SEED}
  if [ -d "$DIR" ]; then
      echo "Oops! The results exist at ${DIR} (so skip this job)"
  else
#      python train.py \
      python -m torch.distributed.launch --nproc_per_node 8 --master_port 12346 train.py \
      --world-size 8 \
      --root ${DATA} \
      --seed ${SEED} \
      --trainer ${TRAINER} \
      --dataset-config-file configs/datasets/${DATASET}.yaml \
      --config-file configs/trainers/${TRAINER}/${CFG}.yaml \
      --output-dir ${DIR} \
      --model-dir output/imagenet_21k/${TRAINER}_${TAG}/${CFG}_unc${UNC}_${SHOTS}shots/nctx${NCTX}_cscFalse_ctpend/seed${SEED} \
      --load-epoch ${EPOCH} \
      --eval-only \
      TRAINER.POMP.N_CTX ${NCTX}
  fi
fi

# CUDA_VISIBLE_DEVICES=0 sh scripts/pomp/eval.sh oxford_pets 1 tutorial_sampled_softmax 128
# CUDA_VISIBLE_DEVICES=1 sh scripts/pomp/eval.sh oxford_flowers 1 tutorial_sampled_softmax 128
# CUDA_VISIBLE_DEVICES=2 sh scripts/pomp/eval.sh food101 1 tutorial_sampled_softmax 128
# CUDA_VISIBLE_DEVICES=3 sh scripts/pomp/eval.sh sun397 1 tutorial_sampled_softmax 128
# CUDA_VISIBLE_DEVICES=4 sh scripts/pomp/eval.sh stanford_cars 1 tutorial_sampled_softmax 128
# CUDA_VISIBLE_DEVICES=4 sh scripts/pomp/eval.sh ucf101 1 tutorial_sampled_softmax 128


# CUDA_VISIBLE_DEVICES=0 sh scripts/pomp/eval.sh oxford_pets 42 refined_sampled_softmax 1000
# CUDA_VISIBLE_DEVICES=1 sh scripts/pomp/eval.sh oxford_flowers 42 refined_sampled_softmax 1000
# CUDA_VISIBLE_DEVICES=2 sh scripts/pomp/eval.sh food101 42 refined_sampled_softmax 1000
# CUDA_VISIBLE_DEVICES=3 sh scripts/pomp/eval.sh sun397 42 refined_sampled_softmax 1000
# CUDA_VISIBLE_DEVICES=4 sh scripts/pomp/eval.sh stanford_cars 42 refined_sampled_softmax 1000
# CUDA_VISIBLE_DEVICES=5 sh scripts/pomp/eval.sh ucf101 42 refined_sampled_softmax 1000
# CUDA_VISIBLE_DEVICES=6 sh scripts/pomp/eval.sh eurosat 42 refined_sampled_softmax 1000
# CUDA_VISIBLE_DEVICES=7 sh scripts/pomp/eval.sh fgvc_aircraft 42 refined_sampled_softmax 1000
# CUDA_VISIBLE_DEVICES=0 sh scripts/pomp/eval.sh caltech101 42 refined_sampled_softmax 1000
# CUDA_VISIBLE_DEVICES=1 sh scripts/pomp/eval.sh dtd 42 refined_sampled_softmax 1000
# CUDA_VISIBLE_DEVICES=2 sh scripts/pomp/eval.sh imagenet_a 42 refined_sampled_softmax 1000
# CUDA_VISIBLE_DEVICES=3 sh scripts/pomp/eval.sh imagenet_r 42 refined_sampled_softmax 1000
# CUDA_VISIBLE_DEVICES=4 sh scripts/pomp/eval.sh imagenet_sketch 42 refined_sampled_softmax 1000
# CUDA_VISIBLE_DEVICES=5 sh scripts/pomp/eval.sh imagenetv2 42 refined_sampled_softmax 1000

# CUDA_VISIBLE_DEVICES=0 sh scripts/pomp/eval.sh imagenet_21k 42 tutorial_sampled_softmax 1000