# Sparsified Control 

This folder contains the code to perform model compression as well as planning with the trained dynamics model. 

### Files:

The associated scripts are as follows:

configs/PWA.yaml -> contains the experiment configuration for piece-wise affine function fitting 

data/pwa_data.p -> contains the training dataset for PWA experiment 

dataset.py -> dataset definition  

optimize.py -> code for optimizing and compression

train.py -> entry script for training

model.py -> model definition

planner.py -> planner

### To generate training data:
1. python PWA/generate_data.py (can modify the number of episodes to generate inside the script)
2. the data pickle file will be created under the data folder 

### To train model:
1. modify configs/PWA.yaml accordingly. The relevant configs will be under "train".
2. python train.py
3. The trained model will be in experiments/{experiment name defined in yaml}. The tensorboard files will also be in there.

### To visualize model
1. find the model iteration you want to evaluate.
2. set the corresponding model in yaml file under ['evaluate']['model_name']
3. python PWA/evaluate.py
4. the visualized results will be located in experiments/{experiment name defined in yaml}/{model name}/...