function [f_vec1,g_vec1,time_vec1,sample_vec,x,acc_vec] = CG_SBO2(fun_f, fun_g, TSA,param,x0, A1, A2, b1, b2)

% param definition
epsilon_f= param.epsilonf;
epsilon_g= param.epsilong;
lambda = param.lam;
maxiter = param.maxiter;

n = length(x0);

a = zeros(n, 1);
g = zeros(n, 1);
h = 0;
K = param.K;
x_prev = x0;

x = x0;
fun_g_x0 = param.fun_g_x0;
tic;
% algorithm
iter = 0;
f_vec1 = fun_f(x0);
g_vec1 = fun_g(x0);
time_vec1 = [];
acc_vec = [];
% sample_vec1u = [];
% sample_vec1l = [];
sample_vec = 1e5;

n1 = height(A1);
n2 = height(A2);
s1 = ceil(sqrt(n1));
s2 = ceil(sqrt(n2));

gamma0 = param.gamma;
while iter <= maxiter
    iter = iter+1;
%     gamma = gamma0/(iter+2+10);
    gamma = gamma0;
    % Sample functions
    if mod(iter-1,s1) ~= 0
        uppidx = randsample(n1, s1);
        grad_fi= @(x) (n1/s1)*A1(uppidx,:)'*(A1(uppidx,:)*x-b1(uppidx,:));
        a = a + grad_fi(x) - grad_fi(x_prev);
    else
        a = A1'*(A1*x-b1);
%         uppidx = 1:n1;
%         grad_fi= @(x) A1(uppidx,:)'*(A1(uppidx,:)*x-b1(uppidx,:));
%         a = grad_fi(x);
    end
    if mod(iter-1,s2) ~= 0
        lowidx = randsample(n2, s2);
        fun_gi= @(x) (n2/s2)*sum_square(A2(lowidx,:)*x-b2(lowidx,:))/2;
        grad_gi= @(x) (n2/s2)*A2(lowidx,:)'*(A2(lowidx,:)*x-b2(lowidx,:));
        g = g + grad_gi(x) - grad_gi(x_prev);
        h = h + fun_gi(x) - fun_gi(x_prev);
    else
        h = sum_square(A2*x-b2)/2;
        g = A2'*(A2*x-b2);
%         lowidx = 1:n2;
%         fun_gi= @(x) sum_square(A2(lowidx,:)*x-b2(lowidx,:))/2;
%         grad_gi= @(x) A2(lowidx,:)'*(A2(lowidx,:)*x-b2(lowidx,:));
%         g = grad_gi(x);
%         h = fun_gi(x);
    end
%     uppidx = randsample(n1, s1);
%     lowidx = randsample(n2, s2);
    %fun_fi= @(x) (A1(uppidx,:)*x-b1(uppidx,:))^2/2;
%     fun_gi= @(x) sum_square(A2(lowidx,:)*x-b2(lowidx,:))/2;
%     grad_fi= @(x) A1(uppidx,:)'*(A1(uppidx,:)*x-b1(uppidx,:));
%     grad_gi= @(x) A2(lowidx,:)'*(A2(lowidx,:)*x-b2(lowidx,:));
    % Build estimators
%     a = (1-alpha)*a + grad_fi(x) - (1-alpha)*grad_fi(x_prev);
%     g = (1-alpha)*g + grad_gi(x) - (1-alpha)*grad_gi(x_prev);
%     h = (1-alpha)*h + fun_gi(x) - (1-alpha)*fun_gi(x_prev);
    % Find direction
    b=[g'*x+fun_g_x0-h+K/(iter+1)^0.5; lambda];
    A = [g' -g'; ones(1,2*n)];
    lb=[sparse(2*n,1)];
    f=[(a/norm(a))' -(a/norm(a))'];
    options = optimoptions('linprog','Algorithm','dual-simplex','Display','off');
    %options = optimoptions('linprog','Algorithm','dual-simplex','Display','iter');
    vec = linprog(f,A,b,[],[],lb,[],options);
%     disp(size(vec));
    d=vec(1:n)-vec(n+1:end);
%     if grad_f(x)'*(x-d)<=epsilon_f && (fun_g(x)-fun_g_x0)<=epsilon_g/2
%         break;
%     end
    x_prev = x;
    x = (1-gamma)*x + gamma*d;
    cpu_t1 = toc;
    f_vec1 = [f_vec1;fun_f(x)];
    g_vec1 = [g_vec1;fun_g(x)];
    time_vec1 = [time_vec1;cpu_t1];
%     sample_vec1u = [sample_vec1u;iter*s1];
%     sample_vec1l = [sample_vec1l;iter*s2];
    sample_vec = [sample_vec;1e5+iter*38];
    % test set accuracy
    [acc_vec] = [acc_vec;TSA(x)];
end

end