# Copyright (c) 2022 Copyright holder of the paper Structural Kernel Search via Bayesian Optimization and Symbolical Optimal Transport submitted to NeurIPS 2022 for review.
# All rights reserved.
import gpflow
from typing import Tuple
import numpy as np

gpflow.config.set_default_float(np.float64)
f64 = gpflow.utilities.to_default_float
from tensorflow_probability import distributions as tfd
from bosot.kernels.base_elementary_kernel import BaseElementaryKernel


class LinearKernel(BaseElementaryKernel):
    def __init__(
        self,
        input_dimension: int,
        base_variance: float,
        base_offset: float,
        add_prior: bool,
        variance_prior_parameters: Tuple[float, float],
        offset_prior_parameters: Tuple[float, float],
        active_on_single_dimension: bool,
        active_dimension: int,
        name: str,
        **kwargs
    ):
        super().__init__(input_dimension, active_on_single_dimension, active_dimension, name)
        self.kernel = gpflow.kernels.Polynomial(degree=1, variance=f64([base_variance]), offset=f64([base_offset]))
        # self.kernel = gpflow.kernels.Linear(variance=f64([base_variance]))
        if add_prior:
            a_variance, b_variance = variance_prior_parameters
            a_offset, b_offset = offset_prior_parameters
            self.kernel.variance.prior = tfd.Gamma(f64([a_variance]), f64([b_variance]))
            self.kernel.offset.prior = tfd.Gamma(f64([a_offset]), f64([b_offset]))
