import matplotlib.pyplot as plt
import numpy as np
rc = {"pdf.fonttype": 42, 'text.usetex': True, 'text.latex.preview': True}

plt.rcParams.update(rc)

test_errors = np.load('metrics/test_errors.npy', allow_pickle=True)

p = 0.5
plt.figure(figsize=(5 *  p, 4 * p))
plt.loglog(test_errors, linewidth=3, color='#99d8c9', label='Test error')
plt.yticks([3, 4, 6, 10], [r'3\%', r'4\%', r'6\%', r'10\%'])
plt.xlabel('Number of gradient descent steps')
plt.ylabel('Test error')

plt.legend()
plt.tight_layout()
plt.savefig('figures/test_errors_realistic.pdf')


cosines = np.load('metrics/cosines.npy', allow_pickle=True)


p = 0.5
plt.figure(figsize=(5 * p, 4 * p))
plt.semilogx(cosines, linewidth=3, color='#99d4c9', label='Cosine similarity')
plt.yticks([0.5, 0.99], [0.5, 0.99])
plt.xlabel('Number of gradient descent steps')
plt.ylabel('Cosine Similarity')

plt.legend()
plt.tight_layout()
plt.savefig('figures/cosines_realistic.pdf')


Q = np.load('metrics/A_realistic.npy')

cmap = 'plasma'


plt.figure(figsize=(4, 4))
plt.matshow(Q, vmin=0, vmax=Q.max(), cmap=cmap)
plt.axis('off')
plt.savefig('figures/A_realistic.pdf')
