/*
 * Decompiled with CFR 0.152.
 */
package agents.spencerSchumann;

import engine.core.MarioForwardModel;
import java.util.ArrayList;

public class Tiles {
    public static final byte EMPTY = 0;
    public static final byte SOLID = 1;
    public static final byte JUMPTHROUGH = 2;
    public static final byte BRICK = 5;
    public static final byte QUESTION = 6;
    public static final byte COIN = 7;
    public static final byte UNKNOWN = -1;
    ArrayList<Column> columns = new ArrayList();

    public static boolean isWall(int n) {
        switch (n) {
            case 1: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    private void setTile(int n, int n2, int n3) {
        if (n < 0) {
            return;
        }
        while (n >= this.columns.size()) {
            this.columns.add(null);
        }
        Column column = this.columns.get(n);
        if (column == null) {
            column = new Column();
            this.columns.set(n, column);
        }
        column.setTile(n2, n3);
    }

    public int getTile(int n, int n2) {
        if (n < 0) {
            return 0;
        }
        if (n >= this.columns.size()) {
            return -1;
        }
        Column column = this.columns.get(n);
        if (column == null) {
            return -1;
        }
        return column.getTile(n2);
    }

    public int[][] getScene(int n, int n2, int n3, int n4) {
        int[][] nArray = new int[n4][n3];
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                nArray[i][j] = this.getTile(j + n, i + n2);
            }
        }
        return nArray;
    }

    public void addObservation(MarioForwardModel marioForwardModel) {
        int[][] nArray = marioForwardModel.getMarioSceneObservation();
        float[] fArray = marioForwardModel.getMarioFloatPos();
        int n = (int)(fArray[0] / 16.0f);
        int n2 = (int)(fArray[1] / 16.0f);
        marioForwardModel.getClass();
        n -= 16 / 2;
        marioForwardModel.getClass();
        n2 -= 16 / 2;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                int n3 = nArray[i][j];
                switch (n3) {
                    case 0: {
                        n3 = 0;
                        break;
                    }
                    case 17: {
                        n3 = 1;
                        break;
                    }
                    case 23: {
                        n3 = 5;
                        break;
                    }
                    case 24: {
                        n3 = 6;
                        break;
                    }
                    case 31: {
                        n3 = 7;
                        break;
                    }
                    case 59: {
                        n3 = 2;
                        break;
                    }
                    default: {
                        n3 = -1;
                    }
                }
                if (n3 == -1) continue;
                this.setTile(i + n, j + n2, n3);
            }
        }
    }

    private class Column {
        public int startRow = 0;
        int[] tiles = null;

        private Column() {
        }

        public void setTile(int n, int n2) {
            if (this.tiles == null) {
                this.tiles = new int[1];
                this.tiles[0] = n2;
                this.startRow = n;
            } else {
                if (this.startRow > n) {
                    int n3 = this.startRow - n;
                    int[] nArray = new int[this.tiles.length + n3];
                    System.arraycopy(this.tiles, 0, nArray, n3, this.tiles.length);
                    for (int i = 0; i < this.startRow; ++i) {
                        nArray[i] = -1;
                    }
                    this.tiles = nArray;
                    this.startRow = n;
                } else if (n >= this.startRow + this.tiles.length) {
                    int n4 = n - this.startRow - this.tiles.length + 1;
                    int[] nArray = new int[this.tiles.length + n4];
                    System.arraycopy(this.tiles, 0, nArray, 0, this.tiles.length);
                    for (int i = this.tiles.length; i < nArray.length; ++i) {
                        nArray[i] = -1;
                    }
                    this.tiles = nArray;
                }
                this.tiles[n - this.startRow] = n2;
            }
        }

        public int getTile(int n) {
            if (n < this.startRow || n >= this.startRow + this.tiles.length) {
                return -1;
            }
            return this.tiles[n - this.startRow];
        }
    }
}

