/*
 * Decompiled with CFR 0.152.
 */
package agents.spencerSchumann;

import agents.spencerSchumann.Edge;
import agents.spencerSchumann.MarioState;
import agents.spencerSchumann.Scene;
import engine.helper.MarioActions;

public class MotionSimulator {
    private Scene scene;
    public MarioState mario;
    public boolean collision;
    private int ticks;
    public boolean leftWorldEdge = true;

    public MotionSimulator(Scene scene, MarioState marioState) {
        this.scene = scene.clone();
        this.mario = marioState.clone();
    }

    public void updateScene(Scene scene) {
        this.scene.update(scene);
    }

    private void handleHorizontalInput(boolean[] blArray) {
        float f;
        float f2 = f = blArray[MarioActions.SPEED.getValue()] ? 1.2f : 0.6f;
        if (blArray[MarioActions.LEFT.getValue()]) {
            this.mario.vx -= f;
        }
        if (blArray[MarioActions.RIGHT.getValue()]) {
            this.mario.vx += f;
        }
    }

    private void handleJumpInput(boolean[] blArray) {
        this.mario.vy *= 0.85f;
        if (!this.mario.onGround) {
            this.mario.vy += 3.0f;
        }
        if (!blArray[MarioActions.JUMP.getValue()]) {
            this.mario.jumpTime = 0;
            if (this.mario.onGround) {
                this.mario.mayJump = true;
            }
        }
        if (blArray[MarioActions.JUMP.getValue()]) {
            if (this.mario.jumpTime > 0) {
                this.mario.vy = -1.9f * (float)this.mario.jumpTime--;
            } else if (this.mario.mayJump) {
                this.mario.jumpTime = 7;
                this.mario.vy = -1.9f * (float)this.mario.jumpTime;
            }
            this.mario.mayJump = false;
        }
    }

    public void update(boolean[] blArray) {
        this.handleHorizontalInput(blArray);
        this.handleJumpInput(blArray);
        this.moveHorizontally();
        this.moveVertically();
        ++this.ticks;
    }

    private float goofyAdd(float f, float f2) {
        while (f2 > 8.0f) {
            f2 -= 8.0f;
            f += 8.0f;
        }
        while (f2 < -8.0f) {
            f2 += 8.0f;
            f -= 8.0f;
        }
        return f + f2;
    }

    private void moveHorizontally() {
        if (Math.abs(this.mario.vx) < 0.5f) {
            this.mario.vx = 0.0f;
        }
        float f = this.goofyAdd(this.mario.x, this.mario.vx);
        for (Edge edge : this.scene.walls) {
            if (!(edge.y1 <= this.mario.y) || !(edge.y2 >= this.mario.y - this.mario.height)) continue;
            if (this.mario.x + 4.0f <= edge.x1 && edge.x1 <= f + 4.0f) {
                this.mario.x = edge.x1 - 5.0f;
                this.mario.vx = 0.0f;
                this.collision = true;
                return;
            }
            if (!(f - 4.0f <= edge.x1) || !(edge.x1 <= this.mario.x - 4.0f)) continue;
            this.mario.x = edge.x1 + 4.0f;
            this.mario.vx = 0.0f;
            this.collision = true;
            return;
        }
        this.mario.x = f;
        this.mario.vx *= 0.89f;
        if (this.leftWorldEdge && this.mario.x < 0.0f) {
            this.mario.x = 0.0f;
            this.mario.vx = 0.0f;
        }
    }

    private void moveVertically() {
        float f = this.goofyAdd(this.mario.y, this.mario.vy);
        if (this.mario.vy >= 0.0f) {
            for (Edge edge : this.scene.floors) {
                if (!(edge.x1 < this.mario.x + 4.0f) || !(edge.x2 > this.mario.x - 4.0f) || !(this.mario.y <= edge.y1) || !(edge.y1 - 1.0f <= f)) continue;
                this.mario.y = edge.y1 - 1.0f;
                this.mario.onGround = true;
                this.mario.jumpTime = 0;
                return;
            }
        } else if (this.mario.vy < 0.0f) {
            for (Edge edge : this.scene.ceilings) {
                if (!(edge.x1 < this.mario.x + 4.0f) || !(edge.x2 > this.mario.x - 4.0f) || !(this.mario.y - this.mario.height >= edge.y1) || !(edge.y1 >= f - this.mario.height)) continue;
                this.mario.y = edge.y1 + this.mario.height;
                this.mario.vy = 0.0f;
                this.mario.jumpTime = 0;
                this.collision = true;
                return;
            }
        }
        this.mario.onGround = false;
        this.mario.mayJump = false;
        this.mario.y = f;
    }

    public Scene getScene() {
        return this.scene;
    }

    public float getX() {
        return this.mario.x;
    }

    public void setX(float f) {
        this.mario.x = f;
    }

    public float getVX() {
        return this.mario.vx;
    }

    public float getY() {
        return this.mario.y;
    }

    public void setY(float f) {
        this.mario.y = f;
    }

    public int getTicks() {
        return this.ticks;
    }
}

