#### This is the demo code of our paper "Degradation-Aware Unfolding Half-Shuffle Transformer for Spectral Compressive Imaging" in submission to NeurIPS 2022.

This repo includes:  

- Specification of dependencies.
- Evaluation code.
- Pre-trained models.
- README file.

This repo can reproduce the main results in Tab. (1) of our main paper.
All the source code and pre-trained models will be released to the public for further research.


#### 1. Create Environment:

------

- Python 3 (Recommend to use [Anaconda](https://www.anaconda.com/download/#linux))

- [PyTorch >= 1.3](https://pytorch.org/)

- NVIDIA GPU + [CUDA](https://developer.nvidia.com/cuda-downloads)

- Python packages:

  ```shell
  pip install -r requirements.txt
  ```


#### 2. Prepare Dataset:

Download the dataset from https://github.com/mengziyi64/TSA-Net, put the dataset into the corresponding folder 'code/datasets/', and recollect them in the following form:

	|--datasets   
	    |--TSA_simu_data  
	        |--mask.mat   
	        |--mask_3d_shift.mat 
	        |--Truth
	            |--scene01.mat
	            |--scene02.mat
	            ： 
	            |--scene10.mat


#### 3. Testing

3. 1 Test our pre-trained DAUHST models on the HSI dataset. The results will be saved in 'code/evaluation/testing_result/' in the MatFile format.

```shell
cd code/evaluation/
python test.py
```

3. 2 Calculate quality assessment. We use the same quality assessment code as DGSMP. So please use Matlab, get in 'code/evaluation/Quality_Metrics/', and then run 'Cal_quality_assessment.m'.

- We set DAUHST-9stg as default. If you want to test DAUHST-2stg, DAUHST-3stg and DAUHST-5stg,  please change "DAUHST_9stg" in Line 19 of  "code/evaluation/test.py"  into "DAUHST_2stg" ,"DAUHST_3stg" or "DAUHST_5stg" and then repeat  3. 1 and 3. 2.


#### 4. This repo is mainly based on TSA-Net and DGSMP.  In our experiments, we use the following repos:

(1)  TSA-Net: https://github.com/mengziyi64/TSA-Net

(2)  DGSMP: https://github.com/TaoHuang95/DGSMP

(3)  λ-net:  https://github.com/xinxinmiao/lambda-net

(4) DIP-HSI: https://github.com/mengziyi64/CASSI-Self-Supervised

(5) DNU: https://github.com/wang-lizhi/DeepNonlocalUnrolling

(6) GAP-Net: https://github.com/mengziyi64/GAP-net

(7) ADMM-Net: https://github.com/mengziyi64/ADMM-net

(8) HDNet: https://github.com/Huxiaowan/HDNet

(9) BIRNAT: https://github.com/BoChenGroup/BIRNAT

(10) DeSCI: https://github.com/liuyang12/DeSCI

(11) MST: https://github.com/caiyuanhao1998/MST

(12) TwIST: https://github.com/vbisin/Image-Restoration-Algorithm-TwIST

We thank these repos and have cited these works in our manuscript.

