# this function computes all estimates for task II (conditional expectation change)
all_stats = function(x, y, n0, n1, hx_KCE = 0.1, h_RKCE = 0.1, h_DY = 0.1, h_DXY = 0.1, h_fixed = 0.1){
  
  # x is n * p matrix
  # y is n * 1 matrix
  
  K = exp( - as.matrix(dist(x)^2) / hx_KCE)
  n = length(y)
  K_row_cusum = t(apply(K, 1, cumsum)) # rowwise cumulative sum
  Ky = K %*% diag(c(y)) # scale each column of K by y[i]
  Ky_row_cusum = t(apply(Ky, 1, cumsum))
  
  # ------------------- KCE ------------------
  KCE_delta = rep(0, n)
  
  # calculate scan statistic
  for (i in n0:n1){
    
    # calculate left-sided and right-sided estimate
    tmp_left = Ky_row_cusum[, i] / K_row_cusum[, i]
    tmp_right = (Ky_row_cusum[, n] - Ky_row_cusum[, i]) / (K_row_cusum[, n] - K_row_cusum[, i])
    
    # calculate difference at all xi's
    KCE_delta[i] = mean((tmp_left - tmp_right)^2, na.rm = T) 
    
  }
  
  # rescaling
  myseq = 1 : n 
  KCE_seq = KCE_delta * ((myseq - 1) * (n - myseq)) / n ^ 2
  
  # -------------- RKCE --------------
  fitted = Ky_row_cusum[, n] / K_row_cusum[, n]
  delta_10 = y - fitted # get residuals
  K = exp( - as.matrix(dist(delta_10)^2) / h_RKCE)
  
  tmp = weighted_graph(K = K, n0 = n0, n1 = n1)
  RKCE_val = tmp$Z1
  RKCE_loc = as.numeric(tmp$location1)
  
  # -------------- D_Y ----------------
  K = exp( - as.matrix(dist(y)^2) / h_DY)
  tmp = weighted_graph(K = K, n0 = n0, n1 = n1)
  DY_val = tmp$Z1
  DY_loc = as.numeric(tmp$location1)
  
  # -------------- D_XY ----------------
  x = as.matrix(x)
  K = exp( - as.matrix(dist(cbind(y, x))^2) / h_DXY)
  tmp = weighted_graph(K = K, n0 = n0, n1 = n1)
  DXY_val = tmp$Z1
  DXY_loc = as.numeric(tmp$location1)
  
  # ---------------------- fixed design method (Clive (1996)) -------------------------
  nh = floor(n * h_fixed)
  wseq = (0 : nh) / nh
  w = kernel_k_clive(wseq)
  W = diag(w)
  X1 = matrix(wseq, ncol = 1)
  X0 = matrix(1, ncol = 1, nrow = length(wseq))
  X = cbind(X0, X1)
  delta_clive = rep(NA, n)
  
  for (i in max(n0, ceiling(nh)+2):min(n1, floor(n - nh)-1)){
    Y_minus = y[seq(from = i - 1, to = i - nh - 1, by = -1)]
    f_minus = solve(t(X) %*% W %*% X) %*% t(X) %*% W %*% Y_minus
    
    Y_plus = y[seq(from = i, to = i + nh, by = 1)]
    f_plus = solve(t(X) %*% W %*% X) %*% t(X) %*% W %*% Y_plus
    
    delta_clive[i] = (f_plus - f_minus)[1] ^ 2
  }
  
  # return results for all methods
  return(
    list(
      KCE_val = max(KCE_seq, na.rm = T),
      KCE_loc = which.max(KCE_seq),
      RKCE_val = RKCE_val, 
      RKCE_loc = RKCE_loc, 
      DXY_val = DXY_val,
      DXY_loc = DXY_loc,
      DY_val = DY_val,
      DY_loc = DY_loc,
      fixed_val = max(delta_clive, na.rm = TRUE),
      fixed_loc = which.max(delta_clive)
    )
  )
  
}

