(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    516337,       9217]
NotebookOptionsPosition[    510544,       9119]
NotebookOutlinePosition[    511159,       9140]
CellTagsIndexPosition[    511116,       9137]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
We follow the derivation in Kolter (2011) with the aim of constructing a \
fixed-point counterexample with n=3 states and k=2 feature space, where w* is \
near [1, -1]
We achieve this by splitting the left state into two equal states.\
\>", "Text",
 CellChangeTimes->{{3.848632720901607*^9, 3.848632738020585*^9}, {
  3.8486340159286547`*^9, 3.848634057462323*^9}, {3.8489104946422167`*^9, 
  3.8489105216064568`*^9}},ExpressionUUID->"051258ff-3da9-473b-961b-\
d8991c9fcfd8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"P", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "0.4", ",", " ", "0.4", ",", " ", "0.2", ",", " ", "0.", ",", "0."}], 
       "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
       "0.4", ",", " ", "0.4", ",", " ", "0.2", ",", " ", "0.", ",", "0."}], 
       "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"0.0", ",", " ", 
        RowBox[{"1", "-", "z"}], ",", "0.", ",", " ", "z", " ", ",", "0.0"}], 
       "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
       "0.", ",", " ", "0.", ",", " ", "0.2", ",", " ", "0.4", " ", ",", 
        "0.4"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
       "0.", ",", " ", "0.", ",", " ", "0.2", ",", " ", "0.4", " ", ",", 
        "0.4"}], "}"}]}], "}"}], " ", "/.", 
    RowBox[{"{", 
     RowBox[{"z", "->", "0.5"}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"V", "=", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", "1.", ",", "1.05", ",", "1.", ",", " ", "1."}], 
      "}"}], "}"}], "\[Transpose]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gamma", "=", "0.99"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R", " ", "=", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"IdentityMatrix", "[", "5", "]"}], " ", "-", " ", 
      RowBox[{"gamma", "*", "P"}]}], ")"}], ".", "V"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pi", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], ".", 
    RowBox[{"MatrixPower", "[", 
     RowBox[{"P", ",", "1024"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"pi", "//", "TraditionalForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"epsilon", "=", "0.0001"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Phi", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", 
         RowBox[{"0", "/", "100"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", 
         RowBox[{
          RowBox[{"-", "1"}], "/", "100"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"1.05", "/", "2"}], "+", "epsilon"}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"1.05", "/", "2"}], "+", "epsilon"}], ")"}]}], "/", 
          "100"}]}], "}"}]}], "}"}]}], ";"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Phi", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "epsilon"}], ")"}], "/", "3"}], ",", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "epsilon"}], ")"}], "/", "3"}], ",", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "epsilon"}], ")"}], "/", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "0", ",", "1."}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "3"}], ",", " ", 
       RowBox[{"1", "/", "3"}], ",", " ", 
       RowBox[{"1", "/", "3"}]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Phi", "=", 
   RowBox[{"Phi", ".", 
    RowBox[{"DiagonalMatrix", "[", 
     RowBox[{"{", 
      RowBox[{"1.", ",", ".01", ",", ".1"}], "}"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p", "=."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"q", "=."}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Dm", " ", "=", " ", 
     RowBox[{"DiagonalMatrix", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", "/", "3"}], ",", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "p"}], ")"}], "/", "2"}], ",", 
        RowBox[{"p", "/", "3"}], ",", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "p"}], ")"}], "/", "2"}], ",", " ", 
        RowBox[{"p", "/", "3"}]}], "}"}], "]"}]}], ";"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Dm", " ", "=", " ", 
    RowBox[{"DiagonalMatrix", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"p", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "q"}], ")"}], "/", "3"}]}], ",", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "p"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"1", "-", "q"}], ")"}]}], ",", 
       RowBox[{"p", "*", 
        RowBox[{"2", "/", "3"}]}], ",", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "p"}], ")"}], "*", "q"}], ",", " ", 
       RowBox[{"p", "*", 
        RowBox[{"q", "/", "3"}]}]}], "}"}], "]"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Dm", " ", "=", " ", 
  RowBox[{"DiagonalMatrix", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"p", "*", 
      RowBox[{"q", "/", "2"}]}], ",", 
     RowBox[{"p", "*", 
      RowBox[{"q", "/", "2"}]}], ",", 
     RowBox[{"1", "-", "p"}], ",", " ", 
     RowBox[{"p", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "q"}], ")"}], "/", "2"}]}], ",", " ", 
     RowBox[{"p", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "q"}], ")"}], "/", "2"}]}]}], "}"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Norm", "[", "V", "]"}]}], "Input",
 CellChangeTimes->{{3.848910053020782*^9, 3.848910152351247*^9}, {
   3.848910308449559*^9, 3.84891030984326*^9}, 3.851936641725163*^9, {
   3.852099656777422*^9, 3.852099660756007*^9}, {3.8520998283982353`*^9, 
   3.8520998330051622`*^9}, {3.852100643443104*^9, 3.852100647045465*^9}, {
   3.857312621661829*^9, 3.857312691960071*^9}, {3.857316711815258*^9, 
   3.85731676509906*^9}, {3.85765391359242*^9, 3.857653919307899*^9}, 
   3.857653970095665*^9, {3.858190355111109*^9, 3.858190364445321*^9}, {
   3.858190515783284*^9, 3.858190528972464*^9}, {3.858876324873047*^9, 
   3.858876333921012*^9}, {3.858876385002718*^9, 3.8588764260865726`*^9}, {
   3.85887647029799*^9, 3.858876506244452*^9}, {3.85887669984844*^9, 
   3.8588767055162354`*^9}, {3.858881430642562*^9, 3.858881510308144*^9}, {
   3.858883366534091*^9, 3.858883382611308*^9}, {3.858885434042835*^9, 
   3.858885456073851*^9}, {3.858888431841683*^9, 3.858888432347713*^9}, 
   3.859047404927806*^9, {3.859048643808484*^9, 3.8590486522963123`*^9}, {
   3.8590491395002947`*^9, 3.859049147978513*^9}, {3.859049237576869*^9, 
   3.859049247399126*^9}, {3.859062089465765*^9, 3.859062113603038*^9}, {
   3.859062200258841*^9, 3.8590622040622187`*^9}, {3.859062358836833*^9, 
   3.8590625641802483`*^9}, {3.859063013418304*^9, 3.8590630206323137`*^9}, 
   3.859063583893763*^9, {3.859063668220086*^9, 3.8590637252259607`*^9}, {
   3.859146134565392*^9, 3.8591462302519417`*^9}, {3.859146292370948*^9, 
   3.859146422039569*^9}, {3.859146453515401*^9, 3.859146638356056*^9}, {
   3.8591468008988733`*^9, 3.859146962891985*^9}, {3.8591470388176527`*^9, 
   3.859147041015374*^9}, {3.859149868237216*^9, 3.859149887371408*^9}, {
   3.8591499376717157`*^9, 3.85914994677925*^9}, {3.859150007250124*^9, 
   3.859150043412981*^9}, {3.859150333192638*^9, 3.859150500928686*^9}, {
   3.859150538818654*^9, 3.859150600811595*^9}, {3.859150773876356*^9, 
   3.85915082002969*^9}, {3.859299417258461*^9, 3.859299420129928*^9}, {
   3.859299460132152*^9, 3.859299493417594*^9}, {3.859299745651204*^9, 
   3.859299762029562*^9}, {3.8592998135462*^9, 3.859299816487876*^9}, {
   3.859299879114441*^9, 3.859299882574469*^9}, {3.859302484337563*^9, 
   3.8593024845354137`*^9}, {3.859302524181265*^9, 3.859302526748519*^9}, {
   3.859302603862207*^9, 3.859302604167056*^9}, {3.859302657321434*^9, 
   3.859302668026701*^9}, {3.859302743472533*^9, 3.8593027549241753`*^9}, {
   3.8593027973036203`*^9, 3.859302797859726*^9}, 3.8593029219887753`*^9, {
   3.859303663370689*^9, 3.8593036745566177`*^9}},
 CellLabel->
  "In[513]:=",ExpressionUUID->"9200f06e-2e4b-41fc-9cec-a5e44c74ced5"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
   "0.16666666666667812`", ",", "0.2500000000000171`", ",", 
    "0.16666666666667818`", ",", "0.2500000000000172`", ",", 
    "0.16666666666667812`"}], "}"}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.859149889301654*^9, 3.859149947397287*^9, {3.859150018217754*^9, 
   3.859150043857176*^9}, {3.859150366530738*^9, 3.859150401561755*^9}, 
   3.859150459899066*^9, 3.859150501443945*^9, 3.859150545923251*^9, 
   3.8591506013542128`*^9, {3.859150776479782*^9, 3.859150820717265*^9}, 
   3.859299301106595*^9, {3.8592994648651237`*^9, 3.859299515542083*^9}, 
   3.859299764458802*^9, 3.859299816927804*^9, 3.859299883723217*^9, 
   3.859302489859592*^9, 3.859302527216609*^9, 3.8593026051027517`*^9, {
   3.859302657977878*^9, 3.8593026683152514`*^9}, {3.8593027468683987`*^9, 
   3.859302757218521*^9}, 3.859302798229822*^9, 3.859302922366246*^9, {
   3.859303666211153*^9, 3.8593036752566338`*^9}},
 CellLabel->
  "Out[518]//TraditionalForm=",ExpressionUUID->"2c3fab80-585a-4a43-8aa7-\
9871f424325e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"p", " ", "q"}], "2"], ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"p", " ", "q"}], "2"], ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"1", "-", "p"}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{
      FractionBox["1", "2"], " ", "p", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "q"}], ")"}]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{
      FractionBox["1", "2"], " ", "p", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "q"}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.859149889301654*^9, 3.859149947397287*^9, {3.859150018217754*^9, 
   3.859150043857176*^9}, {3.859150366530738*^9, 3.859150401561755*^9}, 
   3.859150459899066*^9, 3.859150501443945*^9, 3.859150545923251*^9, 
   3.8591506013542128`*^9, {3.859150776479782*^9, 3.859150820717265*^9}, 
   3.859299301106595*^9, {3.8592994648651237`*^9, 3.859299515542083*^9}, 
   3.859299764458802*^9, 3.859299816927804*^9, 3.859299883723217*^9, 
   3.859302489859592*^9, 3.859302527216609*^9, 3.8593026051027517`*^9, {
   3.859302657977878*^9, 3.8593026683152514`*^9}, {3.8593027468683987`*^9, 
   3.859302757218521*^9}, 3.859302798229822*^9, 3.859302922366246*^9, {
   3.859303666211153*^9, 3.859303675273871*^9}},
 CellLabel->
  "Out[524]=",ExpressionUUID->"bf5381eb-2c7f-4059-b76c-12da0e22c55c"],

Cell[BoxData["2.258871399615303`"], "Output",
 CellChangeTimes->{
  3.859149889301654*^9, 3.859149947397287*^9, {3.859150018217754*^9, 
   3.859150043857176*^9}, {3.859150366530738*^9, 3.859150401561755*^9}, 
   3.859150459899066*^9, 3.859150501443945*^9, 3.859150545923251*^9, 
   3.8591506013542128`*^9, {3.859150776479782*^9, 3.859150820717265*^9}, 
   3.859299301106595*^9, {3.8592994648651237`*^9, 3.859299515542083*^9}, 
   3.859299764458802*^9, 3.859299816927804*^9, 3.859299883723217*^9, 
   3.859302489859592*^9, 3.859302527216609*^9, 3.8593026051027517`*^9, {
   3.859302657977878*^9, 3.8593026683152514`*^9}, {3.8593027468683987`*^9, 
   3.859302757218521*^9}, 3.859302798229822*^9, 3.859302922366246*^9, {
   3.859303666211153*^9, 3.859303675291044*^9}},
 CellLabel->
  "Out[525]=",ExpressionUUID->"aaebee4f-6317-47f6-98cb-291f13bf2c60"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Dm", " ", "//", "Total"}], " ", "//", "Total"}], " ", "//", 
  "Simplify"}]], "Input",
 CellChangeTimes->{{3.859149191983626*^9, 3.85914922435529*^9}, {
  3.859149895707061*^9, 3.859149910109583*^9}, {3.859150022633635*^9, 
  3.859150059087223*^9}, {3.859150730520369*^9, 3.859150740551572*^9}, {
  3.85915082659723*^9, 3.8591508271009207`*^9}},
 CellLabel->
  "In[416]:=",ExpressionUUID->"c937557e-f8b8-40f3-884b-a5fcfe331f43"],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{
  3.858876507134753*^9, {3.85888840543437*^9, 3.858888440534205*^9}, 
   3.859047406743555*^9, 3.859048652849247*^9, 3.859049148735968*^9, 
   3.859049248116078*^9, 3.85906211444274*^9, 3.8590622044856853`*^9, 
   3.859062380151688*^9, {3.8590624456389*^9, 3.859062458873726*^9}, {
   3.859062541486124*^9, 3.8590625648014812`*^9}, 3.859063021694263*^9, 
   3.859063585185767*^9, 3.85906372574368*^9, 3.8591461291647797`*^9, 
   3.85914621133526*^9, {3.859146339487504*^9, 3.859146423470648*^9}, {
   3.859146460197674*^9, 3.859146472223748*^9}, {3.8591465059722157`*^9, 
   3.859146579932311*^9}, {3.859146619777937*^9, 3.85914663878272*^9}, {
   3.859146844146096*^9, 3.8591468555081244`*^9}, 3.859146965791225*^9, 
   3.859147041750671*^9, {3.85914921118747*^9, 3.859149224986719*^9}, {
   3.859149892060565*^9, 3.859149910463511*^9}, 3.859149952748466*^9, {
   3.859150019426694*^9, 3.859150059719651*^9}, {3.859150370120756*^9, 
   3.859150402466724*^9}, 3.859150460945736*^9, 3.85915050239968*^9, 
   3.8591505473709517`*^9, 3.859150602490629*^9, {3.859150733056058*^9, 
   3.859150827668908*^9}, 3.85929946703472*^9, 3.859299515714713*^9, 
   3.859299767450616*^9, 3.859299818766021*^9, 3.859299886695942*^9, 
   3.859302528688389*^9, 3.859302607615635*^9, 3.8593026715102577`*^9, 
   3.859302758563552*^9, 3.8593027996309767`*^9, 3.859302923514495*^9},
 CellLabel->
  "Out[416]=",ExpressionUUID->"749c11b0-a8ef-47b3-8b17-c1d9b95fb574"]
}, Open  ]],

Cell[TextData[StyleBox["Compute the correct value of w:", "Text"]], "Text",
 CellChangeTimes->{{3.848912947646468*^9, 3.848912977322949*^9}, {
   3.857312685079691*^9, 3.857312689669485*^9}, 3.858008087557022*^9, {
   3.8588764305400467`*^9, 
   3.858876440555578*^9}},ExpressionUUID->"812d4f2f-d057-4141-99e9-\
0041d5ad4212"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"what", " ", "=", " ", 
   RowBox[{"LeastSquares", "[", 
    RowBox[{
     RowBox[{"Refine", "[", "Phi", "]"}], ",", "V"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Norm", "[", 
  RowBox[{
   RowBox[{"Phi", ".", "what"}], "-", "V"}], "]"}]}], "Input",
 CellChangeTimes->{{3.848912930225717*^9, 3.848912932374175*^9}, {
   3.848975619105205*^9, 3.84897563277147*^9}, 3.8489771939460287`*^9, {
   3.84898420159488*^9, 3.8489842062656384`*^9}, {3.8590491635168533`*^9, 
   3.859049212426612*^9}, 3.8590553530009317`*^9, {3.859062122072809*^9, 
   3.859062125237114*^9}, {3.859147086955426*^9, 3.8591471003511267`*^9}, {
   3.8593026290482388`*^9, 3.859302634499507*^9}},
 CellLabel->
  "In[417]:=",ExpressionUUID->"faa6cd96-61f9-4282-9bec-90ba810909ff"],

Cell[BoxData["0.04463102417470828`"], "Output",
 CellChangeTimes->{
  3.859049212946423*^9, 3.8590492510829*^9, 3.859062125621891*^9, 
   3.85906220874627*^9, 3.859062614594304*^9, 3.8590630254394083`*^9, 
   3.859063589720912*^9, 3.859063729460816*^9, 3.859146779510818*^9, {
   3.859146847201599*^9, 3.859146858850822*^9}, 3.859146973108673*^9, {
   3.859147092239908*^9, 3.8591471007320957`*^9}, 3.859150063968799*^9, 
   3.8591508302791443`*^9, 3.859299303464518*^9, 3.859299468555089*^9, 
   3.859299520477912*^9, 3.859299768792584*^9, 3.859299819981632*^9, 
   3.859299887833221*^9, 3.859302529908565*^9, {3.8593026088363943`*^9, 
   3.859302635284334*^9}, 3.859302672721348*^9, 3.859302759510386*^9, 
   3.859302800596272*^9, 3.859302925374805*^9},
 CellLabel->
  "Out[418]=",ExpressionUUID->"0bf5fd59-bd95-4ad9-8db1-a6ddf83d1a05"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Computing the fixed point w_star:", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.848570432944818*^9, 3.8485704485407467`*^9}, {
  3.848570915714424*^9, 
  3.848570984363884*^9}},ExpressionUUID->"0a5d41cb-08ef-4253-a74f-\
02384f62cb6a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sA", " ", "=", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"Phi", "\[Transpose]"}], ".", "Dm", ".", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"IdentityMatrix", "[", "5", "]"}], " ", "-", " ", 
        RowBox[{"gamma", "*", "P"}]}], ")"}], ".", "Phi"}], " ", "+", " ", 
     RowBox[{"eta", "*", 
      RowBox[{"IdentityMatrix", "[", "3", "]"}]}]}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sb", " ", "=", " ", 
   RowBox[{
    RowBox[{"Phi", "\[Transpose]"}], ".", "Dm", ".", "R"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"wstar", "=", 
   RowBox[{
    RowBox[{"Inverse", "[", "sA", "]"}], ".", "sb"}]}], ";"}]}], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.848570984364477*^9, 3.848571676353101*^9, {3.848913024643092*^9, 
   3.84891305207668*^9}, {3.848913722679961*^9, 3.848913736469101*^9}, {
   3.857312703508958*^9, 3.8573127254150143`*^9}, {3.858881576657351*^9, 
   3.85888157809092*^9}, 3.858883395373931*^9, 3.858885471709312*^9, {
   3.859062619219288*^9, 3.859062624336109*^9}, 3.8590637363758297`*^9},
 CellLabel->
  "In[419]:=",ExpressionUUID->"dac544c6-b255-4844-84bf-e0609e814e56"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{
      RowBox[{"Phi", ".", "wstar"}], " ", "-", " ", "V"}], "]"}], " ", "/.", 
    " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"epsilon", "->", "0.0001"}], ",", 
      RowBox[{"eta", "->", "0.00001"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot3D", "[", 
  RowBox[{"tmp", ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "0", ",", "1.1"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.851991153216415*^9, 3.851991186354488*^9}, {
   3.858190544665009*^9, 3.858190584057885*^9}, {3.859055921411811*^9, 
   3.859055926789782*^9}, {3.8590559717750053`*^9, 3.859055972759503*^9}, {
   3.8590560485311813`*^9, 3.8590560502588778`*^9}, {3.8590615960310373`*^9, 
   3.859061654179517*^9}, {3.859062634927911*^9, 3.859062724209175*^9}, {
   3.85906293367338*^9, 3.859062958929349*^9}, {3.859063053119652*^9, 
   3.859063108279401*^9}, {3.859063152872786*^9, 3.8590631541807737`*^9}, {
   3.859063917700698*^9, 3.859063918535165*^9}, {3.8591473446983547`*^9, 
   3.859147344752347*^9}, 3.859303092490806*^9},
 CellLabel->
  "In[451]:=",ExpressionUUID->"5c741a9b-2f35-4603-8157-51a0429cf235"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJyUnXk0V9/3/1/meY4QoTQYipJGdVEpNEiDJrNUQtEkDdI8C40yS2mmQSXv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    "], {{
      {RGBColor[0.1, 0.1, 0.1], Opacity[1], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJxFnHn8DtX7/+/7nvfcM3PP/Zb2vSQVIUq02EK2UNFqaV9QWpRSKkmhlFCi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            "]], 
           Polygon3DBox[CompressedData["
1:eJwtnAXUVVUThm9w+2J3gq0gIoiKCWJgx293t2J3omK32N3drWBggGJ3d3e3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            "]], Polygon3DBox[CompressedData["
1:eJwt13m8V9MaBvAtzun8zvmlaEBKw6k0URqURk2USjoVJRUpigZRFG65EqUi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            "]], 
           Polygon3DBox[{{2873, 717, 1338, 2305, 2268, 3186}, {2412, 2411, 
            3183, 2245, 2246, 3184}}]},
          Annotation[#, "Charting`Private`Tag$1964968#1"]& ]],
        Lighting->{{"Ambient", 
           Hue[0., 0., 1.]}, {"Directional", 
           GrayLevel[0.6], 
           ImageScaled[{1, 1, 3}]}}]}, {}, 
      {GrayLevel[1], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJw1mHuwV1UVx8/v/Pa958f53SuCqHApEQQRy15KheT0sixGyYnHRcyUy0sg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           "]], 
          Polygon3DBox[CompressedData["
1:eJwtmHmU1mUVx3/v731mfu+874wSq4MLgimCh1MeyU72Tyq55pLDjlgzg9BB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           "]], Polygon3DBox[CompressedData["
1:eJwl0ktIlHEUxuFjM07jzEgQdDFbZDdpwEUgQq5rU1IRpmBhNeWiTUUXV7lo
UataZxJdFkVJNNouaVGbIII2UaKlZRhJbbIgutDl+foWL5z3N+85/zNnpqly
dNeRBRHRTLU0nY/oqIloB89kI37xF+lQJmKCP06z/B2qYtN8DU3y5fqI+YUR
p/h2Gi9GfKOl6pKZ/WbW8d2liBG5UerG+woROfyYzxeb04K3YQ3qAWxIfyNN
8U/xZdht/ha91/cE+6jnNBXMa+UP4i32G8A+00tsHa1X58zZYcZXfozvMKeN
inrv84N1EZfd4rV6inrs+0bPNpmt2fSN5K05bJS/R8/M6+Q3mJlX78fK9Nwe
E9harJ//Y6cR88ewLnMq5qyizd44UEhv+v+2WBdWwTrlHvhx8vobCumNkltt
5A/TJ9mdOXtjV/i/ZszxL2RXYyew31jVu616r2HXsR6a4b/Ibcdq1U1mreRf
2fsdf4PPeL9cSPdO9j+pb438OLZJZlj9Hd+Hv5Wf1XtJPZ9P/w+ThfR/tQW7
SkPJ7vxuueX6HmNV+sBPy/eqL1CvXH0+vd9Dv8dgNp2bzG+WW6Q+T3vlSnKN
xXSXZKcZn+9xv2G9P/WelTuXfF+ZitvclbvJZ+hHLn072eERLbHTCn3/AJZs
afI=
           "]], 
          Polygon3DBox[{{2759, 2024, 1915, 1076, 1251, 3051}, {3072, 1110, 
           2001, 2000, 156, 3026}}]}],
        Lighting->{{"Ambient", 
           GrayLevel[0.8]}}]}, {}, {}}, {
      {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0ktLlVEUh/HlJTNLbRgoJyLSkaIDMdAc1eg4cqLYLIjQQToqrbwVqekg
MzxeIBzpF0gHDrXmQd7ybgYSUdoXEPy9CGef5/kv3nftvdc5tx51ND3NiohP
1oOciMT/Z0eUkNSViOvyW/VyfpOP8mpeycf4PXx/NWKCN/JxPsMf8o98lj/x
fLt8pm8f7+Y7/B0f5nv8A5/kNd45kOd5LT/ii/wxr9bra3KeAs86X6e8Ktdh
Ru7AZ3kRa2pLfErtubwud+EGduMmvsAf+BK38BX2WNu8F3ewD3exH/dwAPfx
NR5gc77eznfIRy67t/1W5J/yIE7Ly+71XV6VP/Mv/FtyP76QzB3nMIOZZKY4
hMPYlZwFe6y2ZAbYii2YxjTWYwNWYBWm8L75lNl71D7FciXekUfw9FJEkVoF
v612IhfKm/I/fo1v8L/cyOMPahe/Ufs4RteOX3hkuXYcopHEPvrErq9c3EY/
Q9z1UKm9tI15L79RvJF18X87B7tFU+I=
        "]], Line3DBox[CompressedData["
1:eJwl01eQT1cAwOGzLHbZRfRutCCI3hm9l+hRQvTO6u1Bl+g9JGb0Fl28Er08
6R6UGf2NGb2zfGc8fPu7/z3nnnP+e++WGJjWZWxCCCHBj2OZQkhKDOFLthDu
aBaOU5LObGQTXzOGkG5OYnIIJXw+xv9k4gTNmElzSvELs8jM7Hi/e+fop6QQ
WuhmAqXpRGO68NZ4E+1GV17bd5t2Zx6fjSdrGbKygD9oSbm4ZkoIPTTJOf/U
bCykPK3Yzhtr9tX3+rsmm7tI+/MTORnAS3t9MGex6+fO31QrsIKVtGEXGeM+
1qisA1lFFYZRlRGkGN+tw9nDv4zmr/idrZ0vruPs1TRR82uqe/7TIxzmKAW4
yhNnq6sd2BfvoQ5j+Jt/eGHOZK3HNPYzNT4z6x/UA0znmXlF47Py+/rxHdBi
2pCONKI4PzjPDG3ANW5wnSJsoDC5zJmi6f5uk7QQ6/lgj4I6Mb5rxpLsMd71
LSaQx321dRzrSIvP2ryx8Z3RvfEZWKO91mIUjxnJGvK5f622oy01yctqhlKd
/OZc0Ro8inuynNzxHXCeyzokvhf2+WjPQa53MpifucTD+Jys80D7sYwM7KA1
leJ3Np5Dl/IbFbnIfe7xyvPOrvN5Z69UXUKf+Nm+vXQrvXlqvKz2ZC6/xvfF
nAtxHb2t5znEKU5ylwReGi/qLDddb+EcZzjLaX5M/P7//w3SYnzA
        "]], 
       Line3DBox[CompressedData["
1:eJwl02VbFUEYBuBFQcHu7u7u7k7sVuwO7O7u7u5WbH+PhQIGFop6z+WH+zx7
dmbeeefsnspJ8xPnxURRFOPjflwU3eMud7jNLW5yg+tc4yrlEqLoirzMJS5y
gfOco6zxs/IMefJF0Wl5ipOc4DjHOEpqfBQdkYc5xEEOsJ99lFZrr9zDbnax
kx1sp5TxbXIrv/JG0Ra5mU1sZAPryWHeOrmWNaxmFStZwXK+6mWZXMoSFpPM
Iopbv1AuYD7zmMscZjOLNOtnyhlM55N+psmpTKGoGpNlEpOYyATSrRsvxzGW
MYxmFCMZQZY5w+UwhjKExLCnPQaH3uUgWcgeA+UA+vPd/X6yL33oTS8KmtdT
9qA73ehKFzrTiQLmdJQdaE872tKGGGOt5Qf1W8lM2TL8zp53C9mcZjSlCY2J
rGkkG9KA+tSjLnVCDWesLWtRkxpUpxpVw55qV5GVw3ulViVZkQqUpxx/1Cgr
y4R3J7wflKREeIYUC8+BImSbW1hm6L1Q+E3CmclPPvKGfchtrwQZH67JRRyx
5AzfjecI/YUz8jdWH2Tzmzjjv+Rn+2TJn/zgO9/4SiZfwhw+8ZEM0sN9fSY7
e5rrD7wnlXe85Q2vQ031X8kUXurjBc95xlOe8Dj0p94jmcJDHsT9////AwtQ
e1c=
        "]], 
       Line3DBox[{1476, 1207, 1205, 1206, 1204, 3083, 1245, 3068, 1244, 1036, 
        1476}], Line3DBox[{1480, 1042, 1209, 1208, 1480}], 
       Line3DBox[{1489, 1149, 1180, 1147, 1179, 1148, 1237, 1056, 1238, 1239, 
        1489}], Line3DBox[{3054, 1473, 3084, 1474, 1475, 1224, 1469, 1470, 
        1471, 1472, 3054}], 
       Line3DBox[{1495, 1041, 3085, 1228, 1226, 1225, 3086, 1495}], 
       Line3DBox[{1484, 1483, 1482, 1481, 1086, 1490, 1488, 1487, 1486, 1485, 
        1484}], Line3DBox[{1478, 1477, 1210, 1479, 1478}], 
       Line3DBox[{3065, 1492, 1493, 1494, 3066, 1227, 1491, 3065}]}, 
      {GrayLevel[0], 
       Line3DBox[{2334, 2878, 2879, 2621, 2877, 3087, 3380, 2694, 2620, 3188, 
        2498, 2335, 3189, 2499, 2336, 3190, 2500, 2337, 3191, 2501, 2338, 
        3192, 2502, 2339, 3193, 3088, 3269, 2340, 3194, 2503, 2341, 3195, 
        2504, 2342, 2622, 2695, 3348, 2505, 2623, 3136, 3196, 2696, 2506, 
        2625, 2949, 3389, 3179, 2866, 2507, 2626, 3137, 3197, 2708, 2880, 
        2508, 2627, 3333, 2881, 2882, 2697, 2509, 2628}], 
       Line3DBox[{2343, 905, 906, 756, 3381, 2698, 2630, 3198, 2510, 2344, 
        3199, 2511, 2345, 3200, 2512, 2346, 3201, 2513, 2347, 3202, 2514, 
        2348, 3203, 3089, 3270, 2349, 3090, 3271, 2350, 2631, 3204, 2515, 
        2632, 2624, 3205, 2516, 2633, 3145, 3206, 2517, 2699, 3146, 3207, 
        2518, 2700, 3349, 2634, 2519, 2351, 3334, 2629, 2520, 2352}], 
       Line3DBox[{2353, 2957, 2987, 2580, 2958, 2883, 2884, 3382, 2701, 2635, 
        2924, 3091, 3335, 2354, 3208, 2521, 2355, 3209, 2522, 2356, 3210, 
        2523, 2357, 3211, 2524, 2358, 3212, 3092, 3272, 2359, 3093, 3273, 
        2360, 3094, 3274, 2361, 3213, 2525, 2362, 3214, 2526, 2363, 3215, 
        2527, 2364, 3216, 2528, 2365, 3217, 2529, 2366}], 
       Line3DBox[{912, 981, 233, 1938, 419, 305, 3336, 2367, 3095, 3275, 2368,
         3218, 2530, 2369, 3219, 2531, 2370, 3220, 2532, 2371, 3221, 3096, 
        3276, 2372, 3097, 3277, 2373, 3098, 3278, 2374, 3099, 3279, 2375, 
        3222, 2533, 2376, 3223, 2534, 2377, 3224, 2535, 2378, 3225, 2536, 
        2379}], Line3DBox[{2392, 2541, 3231, 2391, 2540, 3230, 2390, 2539, 
        3229, 2389, 3286, 3106, 2388, 3285, 3105, 2387, 3284, 3104, 2386, 
        3283, 3103, 2385, 3282, 3102, 3228, 2384, 2538, 3227, 2383, 2537, 
        3226, 2382, 3281, 3101, 2381, 3280, 3100, 2380, 3337, 2637, 2925, 
        2636, 2926, 2927, 2084, 2582, 2961, 2581, 2988, 2960, 2959}], 
       Line3DBox[{2405, 2544, 3235, 2404, 2543, 3234, 2403, 3296, 3113, 2402, 
        3295, 3112, 2401, 3294, 3111, 2400, 3293, 3110, 2399, 3292, 3109, 
        2398, 3291, 3108, 3233, 2397, 2542, 3232, 2396, 3290, 3107, 2395, 
        2837, 3289, 3168, 2394, 3148, 3288, 2639, 2393, 3147, 3287, 2928, 845,
         846, 2186, 654, 924, 923, 2962}], 
       Line3DBox[{2407, 2996, 2997, 2709, 2713, 3352, 2545, 2921, 2886, 2887, 
        2642, 2885, 3338, 2546, 2702, 2641, 2967, 3393, 2547, 2703, 3152, 
        3236, 2968, 2548, 2704, 3154, 3237, 2998, 2549, 2412, 3184, 3238, 
        3000, 2550, 2414, 3240, 3241, 2551, 2416, 3242, 2552, 2418, 3243, 
        2553, 2420, 3244, 2554, 2422, 3245, 2555, 2424, 3246, 2556, 2426, 
        3247, 2557, 2428, 3249, 2559, 2430}], 
       Line3DBox[{2429, 2558, 3248, 2427, 3308, 3120, 2425, 3307, 3119, 2423, 
        3306, 3118, 2421, 3305, 3117, 2419, 3304, 3116, 2417, 3303, 3115, 
        2415, 3302, 3114, 3239, 2413, 2999, 3301, 3183, 2411, 2644, 3300, 
        3153, 2410, 2643, 3299, 3151, 2409, 3150, 3298, 2640, 2408, 3149, 
        3297, 2929, 2931, 2930, 2406, 3169, 3373, 2838, 2638, 2965, 2964, 
        2963}], Line3DBox[CompressedData["
1:eJwVzssyAnAYhvGvKAprTG1ssuYinGrVjE7L9tjUOsdyBRYZ3EJUKG7GUNfh
1+KZ9/kO/8NO86J8noiIEjqZiKO1iAcc4zQb0UeL761H5DYiftUDvKKKTbMt
BK/gDTMMUUPemUe5bSch/zDCHOPFvnvrcte8jSQvyBOUUMTQTkP/mS/JJ3mm
N8ILX9a79PdDb03UU+ybHaiv9L/U3/hJR1yrx2YpZ274O0/zW/7BV/gd/+Sr
vMsnPMN7fMqz/J7/AzQPJqQ=
        "]], 
       Line3DBox[{2441, 2867, 2583, 2895, 2716, 2893, 2717, 3187}], 
       Line3DBox[{2448, 2575, 3265, 2447, 2574, 3264, 2446, 2573, 3263, 2445, 
        2572, 3262, 2444, 2571, 3261, 2443, 3309, 3124, 2442, 3394, 3123, 
        2980, 2976, 2977, 3395, 2979, 2978, 2656, 2655, 2898, 3377, 2856, 
        2858, 2857, 2897, 2584, 3358, 3160, 2653, 2725, 2796, 2724, 2654, 
        3260, 3139, 2795, 2744, 2652, 2723, 2794, 2722, 2710, 3259, 3138, 
        2792, 2743, 2651, 2721, 2791, 2720, 3357, 3058}], 
       Line3DBox[{2449, 2868, 2950, 3064}], 
       Line3DBox[{2454, 2579, 3268, 2453, 2578, 3010, 3009, 3401, 2452, 2577, 
        3006, 3005, 3400, 2451, 2576, 3267, 2450, 3340, 3125, 2672, 2671, 
        2934, 2935, 3339, 3177, 2669, 2668, 2904, 2860, 3174, 3329, 2861, 
        2922, 2591, 2748, 2665, 3366, 2735, 2808, 2734, 2809, 2590, 2805, 
        3365, 3161, 2664, 2733, 2804, 2732, 2806, 2589, 2801, 3364, 3033, 
        3055}], Line3DBox[{2461, 2953, 2952, 3390, 2460, 2982, 3011, 2981, 
        3396, 3185, 2459, 3008, 2681, 3007, 2680, 3342, 2458, 2678, 3310, 
        3156, 2457, 3354, 2606, 2673, 2605, 2909, 2845, 2938, 2756, 2821, 
        3361, 2604, 2670, 2603, 2819, 2755, 2844, 3166, 3368, 2818, 2667, 
        2705, 2666, 3073}], 
       Line3DBox[{2470, 2618, 2954, 2617, 2955, 3391, 2469, 2689, 2989, 2688, 
        3345, 3182, 2468, 2765, 2836, 2616, 2682, 3375, 3144, 2914, 2849, 
        2941, 2764, 2826, 2615, 2679, 3379, 3143, 2874, 2467, 2873, 3186, 
        3312, 3052}], 
       Line3DBox[{2483, 2875, 2943, 2876, 2690, 2853, 2916, 2852, 3376, 2482, 
        2782, 2942, 2783, 3053}], 
       Line3DBox[{2497, 2785, 2946, 2786, 2692, 2784, 2832, 2038, 2496, 2830, 
        2831, 2707, 2920, 3351, 3176, 2495, 2985, 2993, 2986, 2865, 3378, 
        3173, 2494, 2994, 2995, 2956, 3392, 3180, 2493, 3327, 3135, 2492, 
        3326, 3134, 2491, 3325, 3133, 2490, 3324, 3323, 3132, 2489, 3322, 
        3131, 2488, 3321, 3130, 2487, 3320, 3129, 2486, 3319, 3128, 2485, 
        3157, 3318, 2864, 2948, 2947, 2484, 3167, 3372, 2835, 2712, 2834, 
        2833, 2693}], Line3DBox[{2869, 2900, 3054}], Line3DBox[{3086, 2871}], 
       Line3DBox[{2917, 2971, 2972, 2711, 2829, 2828, 3388, 2471, 2944, 2945, 
        2863, 2984, 3397, 2983, 2472, 2991, 2992, 2990, 3313, 3178, 2473, 
        3126, 3314, 2474, 3127, 3315, 2475, 3172, 3316, 2851, 2476, 3386, 
        2918, 2919, 2872, 2691, 3346, 2477, 2619, 2685, 2767, 2766, 3347, 
        2478, 2912, 2970, 2913, 2686, 3164, 3374, 2848, 2768, 3016, 2769, 
        3043, 2770, 3030, 3317, 2772, 3050, 2771, 3057}], 
       Line3DBox[{3060, 3022, 3074}], 
       Line3DBox[{3061, 2781, 2827, 3371, 3165, 2481, 3063}], 
       Line3DBox[{3067, 2911, 3036, 3404, 3015, 2758, 2610, 3028, 2609, 3332, 
        3175, 2465, 2757, 2608, 2677, 3341, 3142, 2464, 2812, 2676, 2706, 
        3384, 3155, 2908, 2463, 3171, 3311, 2870, 2846, 2462, 2910, 3385, 
        2684, 2862, 2683, 2939, 2940, 3350, 2842, 2607, 2907, 3085}], 
       Line3DBox[{3082, 2596, 3040, 3403, 3141, 2810, 3034, 3013, 2750, 3360, 
        2595, 3025, 2594, 2749, 3012, 2905, 3383, 2675, 2859, 2674, 2936, 
        2937, 3170, 3387, 2923, 2593, 3049, 2592, 3084}]}, 
      {GrayLevel[0], 
       Line3DBox[{1498, 1669, 3189, 1499, 1680, 3199, 1522, 1691, 3208, 1537, 
        3275, 1706, 1552, 3280, 1721, 1567, 3288, 1873, 2187, 1736, 1582, 
        3298, 1875, 1944, 1749, 3393, 1597, 2215, 1814, 2216, 1963, 3356, 
        1964, 2095, 1985, 1817, 2044, 1966, 3357, 2279, 2309}], 
       Line3DBox[{1500, 1670, 3190, 1501, 1681, 3200, 1523, 1692, 3209, 1538, 
        1707, 3218, 1553, 3281, 1722, 1568, 3289, 2087, 2188, 2088, 1583, 
        3299, 1876, 1945, 1877, 3236, 2217, 2218, 1815, 2219, 1816, 2158, 
        3250, 1984, 1881, 1986, 1818, 2045, 1819, 3259, 1987, 1955, 2272, 
        2310}], Line3DBox[{1502, 1671, 3191, 1503, 1682, 3201, 1524, 1693, 
        3210, 1539, 1708, 3219, 1554, 1723, 3226, 1569, 3290, 1737, 1584, 
        3300, 1878, 1946, 1879, 3237, 2244, 1882, 2126, 1883, 3251, 2159, 
        1884, 1988, 2043, 1820, 2047, 1821, 3260, 1989, 1887, 1996, 2267, 
        2311}], Line3DBox[{1504, 1672, 3192, 1505, 1683, 3202, 1525, 1694, 
        3211, 1540, 1709, 3220, 1555, 1724, 3227, 1570, 1738, 3232, 1585, 
        3301, 2245, 2246, 3238, 2247, 2248, 2249, 2231, 2230, 3252, 2232, 
        2233, 2234, 1886, 3358, 1991, 2048, 1990, 2049, 1998, 2101, 1999, 
        1892, 3364, 2301}], 
       Line3DBox[{1506, 1673, 3193, 1508, 1684, 3203, 1526, 1695, 3212, 1541, 
        1710, 3221, 1556, 1725, 3228, 1571, 1739, 3233, 1586, 1750, 3239, 
        3240, 1598, 2250, 3399, 2252, 2253, 1888, 2127, 2161, 3377, 2160, 
        2162, 2002, 2102, 2003, 1894, 3365, 2007, 2006, 2056, 2302}], 
       Line3DBox[{1510, 1675, 3194, 1511, 3271, 1686, 1528, 3273, 1697, 1543, 
        3277, 1712, 1558, 3283, 1727, 1573, 3292, 1741, 1588, 3303, 1752, 
        3242, 1600, 2256, 1761, 1609, 2235, 3394, 1770, 1618, 1826, 2128, 
        3329, 2129, 1778, 1626, 2057, 2106, 2058, 3368, 1905, 1973, 2292}], 
       Line3DBox[{1512, 1676, 3195, 1513, 1861, 1862, 1687, 3204, 1529, 3274, 
        1698, 1544, 3278, 1713, 1559, 3284, 1728, 1574, 3293, 1742, 1589, 
        3304, 1753, 3243, 1601, 1762, 3253, 1610, 3309, 1771, 1619, 1897, 
        2192, 3339, 2193, 2194, 2195, 2021, 1832, 3361, 2064, 1974, 2065, 
        1975, 2107, 2304}], 
       Line3DBox[{1514, 1849, 1850, 1677, 3348, 1515, 1852, 1863, 1688, 3205, 
        1530, 1699, 3213, 1545, 3279, 1714, 1560, 3285, 1729, 1575, 3294, 
        1743, 1590, 3305, 1754, 3244, 1602, 1763, 3254, 1611, 1772, 3261, 
        1620, 1898, 3340, 1779, 1627, 1833, 3354, 1958, 2108, 2166, 2109, 
        2197, 2139, 3312, 2268, 2305}], 
       Line3DBox[{1516, 1809, 1851, 1810, 3196, 1932, 1854, 1864, 1855, 3206, 
        1531, 1700, 3214, 1546, 1715, 3222, 1561, 3286, 1730, 1576, 3295, 
        1744, 1591, 3306, 1755, 3245, 1603, 1764, 3255, 1612, 1773, 3262, 
        1621, 1780, 3267, 1628, 3310, 1906, 1959, 1907, 1908, 2140, 3379, 
        1838, 2131, 1839, 2171, 2318}], 
       Line3DBox[{1517, 2136, 1811, 1853, 1812, 2205, 3389, 2137, 1865, 1935, 
        1866, 3207, 1532, 1701, 3215, 1547, 1716, 3223, 1562, 1731, 3229, 
        1577, 3296, 1745, 1592, 3307, 1756, 3246, 1604, 1765, 3256, 1613, 
        1774, 3263, 1622, 2257, 3400, 2258, 2259, 1909, 3342, 2222, 1910, 
        2223, 1911, 2115, 3375, 1840, 2170, 1841, 2028, 1918, 2319}], 
       Line3DBox[{1518, 1980, 1981, 1856, 1813, 3197, 1954, 1867, 1936, 3349, 
        1868, 1533, 1702, 3216, 1548, 1717, 3224, 1563, 1732, 3230, 1578, 
        1746, 3234, 1593, 3308, 1757, 3247, 1605, 1766, 3257, 1614, 1775, 
        3264, 1623, 2260, 3401, 2261, 2262, 2263, 2264, 3396, 2239, 2238, 
        2240, 2241, 2242, 3345, 1950, 2072, 2071, 2074, 3371, 2034, 2119, 
        2035, 2320}], 
       Line3DBox[{1519, 1982, 1983, 1857, 2150, 3333, 2149, 1933, 1858, 3334, 
        1859, 1534, 1703, 3217, 1549, 1718, 3225, 1564, 1733, 3231, 1579, 
        1747, 3235, 1594, 1758, 3248, 3249, 1606, 1767, 3258, 1615, 1776, 
        3265, 1624, 1781, 3268, 1629, 2206, 3390, 2207, 2208, 2209, 3391, 
        2210, 2142, 2173, 2172, 2174, 2120, 3376, 2201, 2121, 1928, 2278, 
        2077, 2277, 2078, 2038, 2039, 1960, 2041, 2040, 1930}], 
       Line3DBox[{1654, 1798, 2183, 2122, 1953, 2080, 2202, 2079, 3372, 1643, 
        1790, 2229, 1979, 1951, 2076, 2200, 3388, 2075, 1635, 1786, 2228, 
        1976, 1949, 2104, 3350, 2198, 2103, 1630, 1782, 2227, 1971, 1947, 
        3387, 2099, 2196, 2098, 2303}], 
       Line3DBox[{1655, 1799, 1929, 3318, 1644, 886, 2204, 976, 3397, 1636, 
        883, 2130, 3385, 806, 1631, 882, 1956, 3383, 797, 881, 1453}], 
       Line3DBox[{1656, 1800, 3319, 1645, 1791, 2203, 3313, 1637, 1787, 2111, 
        2110, 3311, 1632, 1783, 1899, 3360, 1827, 2332}], 
       Line3DBox[{1657, 1801, 3320, 1646, 1792, 3314, 1638, 1901, 2112, 1900, 
        3384, 2163, 1948, 2009, 1829, 2059, 1828, 3403, 2331}], 
       Line3DBox[{1658, 1802, 3321, 1647, 1793, 3315, 1639, 1835, 1912, 1834, 
        3341, 1903, 2011, 2282}], 
       Line3DBox[{1659, 1803, 3322, 1648, 2117, 2116, 3316, 1640, 1836, 1913, 
        3332, 2165, 2164, 2329}], 
       Line3DBox[{1661, 1805, 3324, 1650, 1794, 1921, 3346, 1919, 1641, 1788, 
        2306}], Line3DBox[{1662, 1806, 3325, 1651, 1795, 1922, 2030, 3347, 
        2029, 1642, 1789, 2293}], 
       Line3DBox[{1663, 1807, 3326, 1652, 1796, 1923, 1842, 2031, 3374, 2114, 
        2325}], Line3DBox[{1664, 1808, 3327, 1653, 1797, 1924, 1843, 2069, 
        3317, 2285}], 
       Line3DBox[{1665, 2212, 2211, 3392, 2213, 1845, 1925, 1844, 2323}], 
       Line3DBox[{1666, 2124, 2243, 2123, 3378, 2134, 2143, 1846, 1926, 
        2286}], Line3DBox[{1848, 1847, 1668, 3188, 1497, 1860, 1679, 3198, 
        1521, 1869, 3335, 1690, 1536, 1870, 3336, 1705, 1551, 1871, 3337, 
        1720, 1566, 3287, 1872, 1941, 1735, 1581, 3297, 1874, 1943, 762, 3338,
         1596, 764, 772, 660, 2840, 661, 480, 565, 1268}], 
       Line3DBox[{2135, 2180, 2181, 2125, 2179, 2178, 3351, 1952, 2036, 2177, 
        2037, 2298}], 
       Line3DBox[{2214, 2144, 2145, 1931, 2146, 3380, 1667, 1496, 2147, 2148, 
        1934, 2151, 3381, 1678, 1520, 2152, 2153, 1937, 2154, 3382, 1689, 
        1535, 2081, 2184, 2082, 1938, 2155, 2224, 1704, 1550, 2083, 2185, 
        2084, 1939, 2156, 2225, 1719, 1565, 2085, 2186, 2086, 1940, 2157, 
        2226, 1734, 1580, 3373, 2089, 2189, 2090, 1942, 1961, 2182, 1748, 
        3352, 1595, 2091, 2190, 2092, 1880, 1962, 2042, 3355, 1759, 1607, 
        2093, 2096, 2094, 1885, 1965, 2291}], 
       Line3DBox[{2314, 2018, 1625, 1777, 2055, 3366, 1970, 1896, 2005, 2004, 
        1617, 1769, 3395, 2237, 2236, 2255, 2254, 1608, 1760, 3398, 2251, 
        1599, 3241, 1751, 3302, 1587, 1740, 3291, 1572, 1726, 3282, 1557, 
        1711, 3276, 1542, 1696, 3272, 1527, 1685, 3270, 1509, 1674, 3269, 
        1507}], Line3DBox[{2328, 3404, 2275, 1914, 2168, 2167, 2138, 2175, 
        3386, 2176, 2118, 1920, 1649, 3323, 1804, 1660}]}, {}, {}}},
    VertexNormals->CompressedData["
1:eJzM+mdQVM8TNgyDgAgqIgIqICgqAoIYCCJII4qJnMwSlCiIBEEJKkhQguQo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     "]], {}},
  Axes->True,
  AxesEdge->{{-1, -1}, {1, -1}, {-1, -1}},
  AxesLabel->{None, None, None},
  AxesOrigin->{Automatic, Automatic, Automatic},
  AxesStyle->GrayLevel[0],
  BaseStyle->{
    Specularity[1.], 
    RGBColor[0.1, 0.1, 0.1]},
  BoxRatios->{1, 1, 0.4},
  BoxStyle->GrayLevel[0, 0.5],
  Boxed->{Back, Bottom, Left},
  DisplayFunction->Identity,
  FaceGrids->None,
  FaceGridsStyle->Automatic,
  ImageSize->{706.387751858264, 690.5263157894738},
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Lighting->{{"Ambient", 
     Hue[0., 0., 1.]}, {"Directional", 
     GrayLevel[0.6], 
     ImageScaled[{1, 1, 3}]}},
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0], 
      Opacity[0.2]], 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "RotationControl" -> 
    "Globe"},
  PlotRange->{{0, 1}, {0, 1.1}, {0.6427136687594578, 5.137907673023157}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic},
  TicksStyle->GrayLevel[0],
  ViewCenter->{{0.5, 0.5, 0.5}, {0.4346347192582184, 0.6295421018337128}},
  ViewPoint->{0.9218222939601228, 0.2785475878102621, 3.243864192546134},
  ViewVertical->{-0.917669794118729, -0.27729282447706965`, 
   0.2845888937671652}]], "Output",
 CellChangeTimes->{{3.851991175596321*^9, 3.851991188156067*^9}, 
   3.852099769026505*^9, 3.852099840152269*^9, 3.852100226701511*^9, 
   3.8521006529204493`*^9, 3.852102744002846*^9, 3.856790500789186*^9, 
   3.857306002990883*^9, 3.857311947626852*^9, 3.857312736106235*^9, 
   3.85731678740065*^9, 3.857472550671721*^9, {3.857472669108161*^9, 
   3.857472692148705*^9}, 3.857480400691743*^9, 3.857501084918508*^9, 
   3.85751684082974*^9, 3.857576042248208*^9, 3.8576555356399508`*^9, 
   3.858008094574027*^9, 3.858190373694312*^9, {3.85819053694692*^9, 
   3.858190561208508*^9}, 3.8581905935094357`*^9, 3.858876353012439*^9, 
   3.85887641584039*^9, 3.858888412524292*^9, 3.858888447610903*^9, 
   3.8590474227129908`*^9, 3.859048668743128*^9, 3.859055932660043*^9, 
   3.859055981347761*^9, 3.859056066521394*^9, {3.8590616015634947`*^9, 
   3.859061670247501*^9}, {3.859062639367021*^9, 3.859062726351935*^9}, {
   3.859062935406145*^9, 3.8590629610373163`*^9}, {3.8590630306016207`*^9, 
   3.859063110087426*^9}, 3.859063209105105*^9, 3.859063594284299*^9, 
   3.859063739203479*^9, 3.859063919321176*^9, 3.8591468638044157`*^9, 
   3.8591469757697287`*^9, 3.8591473452516003`*^9, 3.859150067947382*^9, 
   3.859150832550988*^9, 3.859299305542027*^9, 3.859299470963406*^9, 
   3.8592995234605303`*^9, 3.8592997719401207`*^9, 3.859299823649127*^9, 
   3.859299889982214*^9, 3.859302531927579*^9, 3.859302611165657*^9, 
   3.8593026756296463`*^9, 3.8593027617801313`*^9, 3.859302802811504*^9, 
   3.8593029283883667`*^9, 3.859303095524315*^9},
 CellLabel->
  "Out[452]=",ExpressionUUID->"0268fbee-bb68-439a-a81e-c4a2e8446d9a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{
      RowBox[{"Phi", ".", "wstar"}], " ", "-", " ", "V"}], "]"}], " ", "/.", 
    " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"epsilon", "->", "0.0"}], ",", 
      RowBox[{"eta", "->", 
       RowBox[{"10", "^", "etax"}]}], ",", 
      RowBox[{"p", "->", "0.4"}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot3D", "[", 
  RowBox[{"tmp", ",", 
   RowBox[{"{", 
    RowBox[{"etax", ",", 
     RowBox[{"-", "7"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "0", ",", "1.1"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.859303102362812*^9, 3.859303133370399*^9}, {
  3.859303200563332*^9, 3.859303200917244*^9}},
 CellLabel->
  "In[459]:=",ExpressionUUID->"891cc3a8-96a2-4bdd-8f47-d24ac8335532"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJysvXlYzc8b/39O+77v2YUQ2aJFzkGW7GvZCpUIFSpCsiRbCpWlskQkO0lk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    "], {{
      {RGBColor[0.1, 0.1, 0.1], Opacity[1], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJw1m3f8l1P/x6/PusbnS1aLdkSybqsyGyRFaVh30Saj0DAjScaNjKLiDoVK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            "]], 
           Polygon3DBox[CompressedData["
1:eJw1mwn4VtMWxs83nOnLdBWVQgNKmTPfKGNEpBSSZmVKA9eUIRJ3kAgVl+ZM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            "]], Polygon3DBox[CompressedData["
1:eJwt13m811Mex/Fv3f2HMrIkkzRkRokxHkoJSbdVQ+tQSt0WJSlEDBG3RbZK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            "]], 
           Polygon3DBox[{{2703, 1901, 1896, 1088, 1087, 2280}, {1590, 1112, 
            1111, 771, 834, 1589}, {2585, 897, 520, 1735, 1908, 2523}}]},
          Annotation[#, "Charting`Private`Tag$2026703#1"]& ]],
        Lighting->{{"Ambient", 
           Hue[0., 0., 1.]}, {"Directional", 
           GrayLevel[0.6], 
           ImageScaled[{1, 1, 3}]}}]}, 
      {GrayLevel[1], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNV1tsFkUU3n9nu9tdUMBERMBKgbYCxf7cKcUS4yU+KA+IAY2ICmI0AkJS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           "]], Polygon3DBox[CompressedData["
1:eJwtlllsVVUUhs+95/Tce24ZoiggYLXYUgvVFkqZhRjQ+KA+IAY14ISSkMgg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           "]], Polygon3DBox[CompressedData["

1:eJwlkDtLA1EQhSfZdRM3fyAgxKyJCCqYRRKwsVNsbAJCCrFQULRQDCQ+8F1o
JDYKIriIwcbO0iK9WopaKJJORUUXCyMpxOC33OKDe86cmTv3WqMz6Wm/iESg
AZpMkVJAZBl20I+NIu9BkS7Od5qIgz8eEskaIns+kagu0gxT+EVyn2Q+oMTQ
E3oHwSWXIpOECnqV7A+ZKuTI9aMrXP7q7UG2m1wBLw8tnC1d3TXLnZswQV8G
inhb6GFmaswJkTN1tbPGOy7IPJBxoBUvDd+cO8i0wz36GHbpvSJ7qancBr1l
5tagh1oO7wtvkn3i9MVgAe3gF6jH8Q2yWTyXP7C5YwXt8qYyOmqqd3jvaTNU
7xj+APVzQ/2P908p6s/s8AQ1/iKJ7oQgvQEPcqah/tr78wic4q3h7dM/zy5+
PB+8oMPcc0Q2FlB7evtaZG+ZfwPXeEPUquzSy7lO7Q+26QuTzTM7g07AIt4c
3i/nN+aPsF8evU6/jU7AATNs9CHzlqjX8frQZ+T+AacvTF4=
           "]]}],
        Lighting->{{"Ambient", 
           GrayLevel[0.8]}}]}, 
      {GrayLevel[1], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxFl2uwVmUVx/e737P3u/e7OcI5gIXVh8yxyLh5mSYQEhBEzhG5n4s3wkAE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           "]], Polygon3DBox[CompressedData["
1:eJwtl1mMVUUQhs+5Z+6555w7I8ywKC4PEgRRGTaNkcWo7ItsCs6AuIBIYIw+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           "]], Polygon3DBox[CompressedData["
1:eJwl0klIlVEYxvHjdO9Vm1QabBdBmxZuWhUVBZkmFE3YbSISKbyRhJaaQ1Yo
eo20VaAQBFZEBLXIbVEbySwIaRcETRBBUYuiDPp9nMXDd57n/N/3TN+q4617
TheGEGqohGZLQ/gseFYUwiZ6y+czIQyabE7HuYR5QlPGa+RZ+WN+I+6eHi3q
cvRe9oHajDvoTUEI1Xx3WQhbUyEcpC7ZBnVDsh/8T/ooa5A1leuj9y/rPFV/
FfM78TSjzyf5C98TuHXqtmCK6bWskwLum7xBvyL+HfUXh3AhkazRGhk9L/PT
8Ar8Tr32yc7z//TPyzLlkU1qjum3nDox9bJu2WF+GXWUxbMkZ8ryldQu67Vu
vV519jZM7Xwd7iiuFrOUzuGa6ZX73Exz1t+PKbd+Vu0E36/2Lt+Im8RU0HX5
atyUntO4XebX65fid+PGMPPO14VbghuRt+AGZQM0zO/FjePSNIRbmYl3MMFn
aFhWLftLtfZ8Sf+FNMuf8j1iX2tpytxoKr7FNuO8ugL5nXRcJ1nvvvEAXdP/
LFVhv1ONPd3ALNYzp25c3QR9lR3A3bKPypJ4xkeyMVlrOv4fh/Bf0vG+knt7
iWvQsxfTja1VU2i+QjaHeZ6J95bc3wLZDN+D3Z6cJRXfNHnbftnN5B2TdfTI
ykaNe5zjJGYFneHbcItwLZSX1ZTG/yT5X/qwvcWRu4h7IH+Yiv/bDv2CrLIo
vm8dfl7Wh72iZoRyskl8FnfbfqtK4hv8wf0Hp0hz+w==
           "]], 
          Polygon3DBox[{{2312, 1596, 1803, 910, 898, 2534}, {2576, 762, 743, 
           1893, 1892, 2702}}]}],
        Lighting->{{"Ambient", 
           GrayLevel[0.8]}}]}, {}, {}}, {
      {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt1GmMjlcUwPFrMNYxqH0fe2RQYq91ZuxbKWMf7diXsa+hlUlraCW0xBiJ
nTFlKtoiluGDiO8ivtjaSnyQ2MUait8Vyfznf+6555773Ps+75uSvXD0glIh
hMH+TU4IIca9yoSwqnQIW7AabVELh8qF8EDNGnE7tEeziiE8kjtorq5xIQ7H
WlQyV487oD7WogGeVAihM3dBQ/xqbbdYj+d6decPar7iLCThpfwMfsOvzfUU
p2AsStlnJzfFhfhMOBZ7y2dyDvbbYxz3wY+oGp/F/Hv9WogT8D1aYqt8nvqf
xHuxHq2wLu5v7x38BQqQi7rqW8daa/J4I9LxA/bIpXFp9EVANWy3psDcHvE2
5Mccass3513YjXee7zy/5WRzyeKjOII/Yp0exdwLv6Gmmtdqi+K9ogkao4Z8
D26EM3jlHOf4LLriJE7hb5zAMz3+5MdckTfb5501ncQdUYKLOIjqeh/gOvgy
ngG/xDvHPkyPZ1bzMPbUp6praOFFKxE3Fvf2vv2vdx/ui35IUp/G6XhhLoP7
YwAGYpv5n60fJB6MIWgtN5SHYThG4Km1I/lrjEIbNaP5sLXfcAXjMTwWm+Qy
eRzGY4PxBE5VM5EnYTKmIN9cFk/Ft0hU8x1nYxqmYwZmYhaOqm+nZrZ4DuZi
HuYjBwvw0rMu5EVYjCVYigTrlvFyrMDK+P3EaqyJZ3C/191jUWII19zrItxH
v7Ih3JBfLE4T3xSn8y3O4Nvcn//hAfwvD+T/OFOvpdbl+MzuGE/iXOPs8iFc
NR7Dl+J6PsnduJBTOZ9TeAPX4VVchZMwR/zCXUzkezyUb3BPvsJt+TI34rvq
m9kzK777xqN4mfFpZ65ifCq+J3yCK/NfXImPsysLx+LdcDFrFX7nImgfCuNn
xoe4bHy++Bsm9hf2l/n0NQ17493HMyis9/n38SOL05J6
        "]], 
       Line3DBox[CompressedData["
1:eJwl0s9L03Ecx/HP1pw2IobgpVuURmS/8KwRVIvcadBBR5ATZKwoMDSSmst+
uK1WhwKhzpkeJDpUdx11FvXmX7BTKbEIIh9fPDx5vt+vz/vz/Xy/H75HC3dz
d2IhhDf43hnCGV7nQd7mLLc4z23+g5I63RXCAz7CVT7GC5w4aI8HLqp/cEp/
nb/oM2aa3CObkBXjIWzoR7msH+oIYVN/gbe4KHuYCOG1Mx9xGbOo4KXsMc/h
fCqEJ9zFT3nF2jN+jnlUUUMdL6K9aGD6gPdM+l7nRJfQwoy8Rz6FceSQxX3c
wzlnJLmAMQyjH2fl17iGq7iNSZzCDby13vBet9QlZFDECG4ij9NmrvAcXmHZ
fIVPYh7dCGYu85K1S5zARXzUx6JzojPN/Henddk/3nHf7+Xvon3R86wP8Rqa
+GsmLVtVt9WH+YO9J2S/9Yf03/AVfbJd2Wd1r/oT/9QP8HH9r/j+f7QH5HVI
2w==
        "]], 
       Line3DBox[{1344, 214, 1614, 361, 215, 1618, 364, 620, 216, 1166, 884, 
        909, 848, 890, 849, 942, 847, 960, 914, 1946, 959, 2610, 958, 2574, 
        776, 846, 1964, 845, 852, 851, 788, 1963, 775, 1344}], 
       Line3DBox[CompressedData["
1:eJwl0tlOU1EUBuBNW62tE1BmqsiMIAgqDuBT+Ag8gL4GiZcqhBASwruoKE4I
SgUUFGcQ0AoCdeA78eLLv8/aa61z0rR+4Ma160UhhFF6YyFkPeS4Gw8hng7h
nrzPJA94yBSPeExazxP5lGdM85wh9dFkCDPOs7zgJXPkeMU8CyzymoyZN3KJ
Zf6mQngr37HCez6Q1PdRfuIzI97zRX5llTUq9HyT62ywyXd+kLc3L3+yxTZj
dlSZ+eW8wy57FLjj7rf8E30T/xhWCwk77CqSMeIkqLHngDxIkkOkGDdT6y7t
fJgjHOVYNKd+XBZTQim39GdkWdTrvlxWUEkV1ZxUr5G1ZKnzfCKqR2dOUU9D
dHbXKJtopoUJ72iVbZyOevW0yw7O0ElXNK9+VnbTwzkGzZ6XBb/BBdnLRS5x
291leYU++rnKzfj//9k+32xNyg==
        "]], 
       Line3DBox[{1177, 873, 1938, 871, 856, 863, 858, 2611, 908, 773, 870, 
        2554, 860, 1937, 810, 1177}], Line3DBox[{1181, 841, 880, 879, 1181}], 
       Line3DBox[{1171, 1170, 1169, 1168, 1966, 1167, 878, 1176, 1967, 1175, 
        2612, 1174, 1173, 1172, 2565, 1171}], 
       Line3DBox[{1179, 1178, 881, 1180, 1179}]}, 
      {GrayLevel[0], Line3DBox[{2577, 1968}], 
       Line3DBox[{1979, 2518, 2464, 2578}], 
       Line3DBox[{1989, 2168, 2729, 1988, 2167, 2728, 1987, 2166, 2727, 1986, 
        2165, 2726, 1985, 2164, 2725, 1984, 2163, 2724, 1983, 2791, 2615, 
        1982, 2790, 2614, 2723, 1981, 2162, 2499, 2498, 2910, 1980, 2161, 
        2279, 2722, 2667, 2385, 498, 2278, 2721, 534, 2409, 2160, 2861, 2277, 
        2230, 2571}], 
       Line3DBox[{2000, 2176, 2736, 1999, 2175, 2735, 1998, 2174, 2734, 1997, 
        2173, 2733, 1996, 2172, 2732, 1995, 2794, 2618, 1994, 2793, 2617, 
        1993, 2792, 2616, 2731, 1992, 2171, 2488, 2444, 2895, 2445, 2447, 
        2446, 2330, 2232, 2851, 1991, 2170, 2284, 2730, 2668, 2344, 2282, 
        2169, 2862, 2283, 2544}], 
       Line3DBox[{2010, 2180, 2741, 2009, 2179, 2740, 2008, 2178, 2739, 2007, 
        2177, 2738, 2006, 2798, 2622, 2005, 2797, 2621, 2004, 2796, 2620, 
        2003, 2795, 2619, 2737, 2002, 625, 1814, 626, 242, 1748, 535, 241, 
        1574, 306, 824}], 
       Line3DBox[{2024, 2183, 2745, 2023, 2182, 2744, 2022, 2181, 2743, 2021, 
        2804, 2627, 2020, 2803, 2626, 2019, 2802, 2625, 2018, 2801, 2624, 
        2017, 2800, 2623, 2742, 2016, 2239, 2238, 2853, 2015, 2237, 2331, 
        2236, 2852, 2456, 2014, 2235, 2287, 2863, 2669, 2013, 2559}], 
       Line3DBox[{2037, 2185, 2748, 2036, 2184, 2747, 2035, 2813, 2633, 2034, 
        2812, 2632, 2033, 2811, 2631, 2032, 2810, 2630, 2031, 2809, 2629, 
        2030, 2808, 2628, 2746, 2029, 2243, 2242, 2854, 2028, 2241, 2333, 
        2885, 537, 2027, 2240, 2289, 2864, 2670, 2552}], 
       Line3DBox[{2061, 2199, 2761, 2059, 2821, 2640, 2057, 2820, 2639, 2055, 
        2819, 2638, 2053, 2818, 2637, 2051, 2817, 2636, 2049, 2816, 2635, 
        2047, 2815, 2634, 2752, 2045, 2245, 2291, 2413, 2865, 2692, 2044, 
        2244, 2335, 2691, 2872, 2412, 2043, 2410, 2411, 2334, 2921, 2539, 
        2561}], Line3DBox[{2072, 2212, 2770, 2071, 2211, 2769, 2070, 2210, 
        2768, 2069, 2209, 2767, 2068, 2208, 2766, 2067, 2207, 2765, 2066, 
        2206, 2912, 2505, 2504, 2065, 2877, 2642, 2373, 2372, 2881, 2394, 
        2205, 2395, 2294, 2415, 2886, 2693, 2392, 2204, 2450, 2393, 2764, 
        2673, 2414, 2203, 2588}], 
       Line3DBox[{2081, 2218, 2778, 2080, 2217, 2777, 2079, 2216, 2776, 2078, 
        2215, 2775, 2077, 2214, 2774, 2076, 1438, 2075, 2899, 2646, 2460, 
        2461, 2855, 2645, 2296, 2247, 2882, 2398, 2400, 2399, 2295, 2246, 
        1762, 2417, 2213, 2418, 2773, 2706}], 
       Line3DBox[{2092, 2222, 2782, 2091, 2221, 2781, 2090, 2220, 2780, 2089, 
        2219, 2779, 2088, 1450, 2087, 2827, 2652, 2086, 2826, 2651, 2085, 
        2856, 2650, 2304, 2249, 2888, 2695, 2402, 2404, 2403, 2302, 2248, 
        2887, 2694, 2401, 2538, 2553}], 
       Line3DBox[{2104, 2225, 2785, 2103, 2224, 2784, 2102, 2223, 2783, 2101, 
        1460, 2100, 2828, 2653, 2099, 2911, 2501, 2500, 2098, 2879, 2377, 
        2376, 2097, 2902, 2258, 2305, 2257, 2857, 2686, 2375, 2352, 2256, 
        2303, 2255, 2916, 2612}], 
       Line3DBox[{2117, 2227, 2787, 2116, 2226, 2786, 2115, 2832, 2656, 2114, 
        2831, 2655, 2113, 2830, 2654, 2112, 2896, 2455, 2502, 2454, 2503, 
        2111, 2897, 2479, 2319, 2378, 2318, 2430, 2110, 2868, 2428, 2266, 
        2469, 2265, 2355, 2880, 2379, 2354, 2264, 2364, 2263, 2606}], 
       Line3DBox[{2132, 2228, 2788, 2131, 2840, 2660, 2130, 2839, 2659, 2129, 
        2838, 2658, 2128, 2837, 2657, 2127, 2698, 2836, 2489, 2491, 2490, 
        2126, 2898, 2480, 2481, 2339, 2368, 2367, 2125, 2870, 2431, 2432, 
        2320, 2359, 2358, 2876, 2124, 2356, 2357, 2550}], 
       Line3DBox[{2146, 2326, 1620, 2145, 2849, 2665, 2144, 2848, 2664, 2143, 
        2847, 2663, 2142, 2846, 2662, 2141, 2700, 2845, 2492, 2494, 2493, 
        2140, 2701, 2903, 2470, 2340, 2370, 2369, 2139, 2871, 2361, 2362, 
        2323, 2360, 2867, 2687, 2138, 2366, 2562}], 
       Line3DBox[{2276, 2159, 2275, 2860, 1978, 2158, 2720, 1977, 2157, 2719, 
        1976, 2156, 2718, 1975, 2155, 2717, 1974, 2154, 2716, 1973, 2153, 
        2715, 1972, 2789, 2613, 2714, 1971, 2152, 2713, 1970, 2151, 2274, 
        2712, 2666, 2383, 2150, 2384, 2273, 2711, 2408, 2407, 2406, 2149, 
        2859, 2272, 2229, 1969, 2148, 2917, 2595}], 
       Line3DBox[{2545, 2465, 2699, 2901, 2506, 2575}], 
       Line3DBox[{2549, 2542, 2906, 2011, 2543, 2551}], 
       Line3DBox[{946, 705, 1868, 704, 2573}], 
       Line3DBox[{2556, 2703, 2280, 2557}], Line3DBox[{2566, 2565}], 
       Line3DBox[{2569, 2448, 2771, 2516, 2709}], 
       Line3DBox[{2574, 2497, 2610}], 
       Line3DBox[{2580, 2520, 2025, 2805, 2707}], 
       Line3DBox[{2581, 2537, 2438, 2511, 2510, 2038, 2600}], 
       Line3DBox[{2583, 2521, 2458, 2201, 2913, 2602}], 
       Line3DBox[{2585, 2523, 2920, 2535, 2517, 2604}], 
       Line3DBox[{2589, 1922, 2336, 2389, 2189, 2388, 2671, 2750, 2337, 2391, 
        2190, 2390, 2672, 2751, 2293, 2191, 2046, 2753, 2754, 2192, 2048, 
        2755, 2193, 2050, 2756, 2194, 2052, 2757, 2195, 2054, 2758, 2196, 
        2056, 2759, 2197, 2058, 2760, 2198, 2060, 2762, 2200, 2062}]}, 
      {GrayLevel[0], Line3DBox[{1183, 1561, 1353, 2917, 1184, 1955}], 
       Line3DBox[{1185, 1495, 1740, 1354, 2859, 1186, 1745, 1501, 1743, 1365, 
        2861, 1211, 1658, 1507, 1570, 1375, 2862, 1221, 1661, 1907, 1936}], 
       Line3DBox[{1187, 1821, 1496, 1741, 1497, 2711, 1742, 1562, 1746, 1502, 
        1744, 1503, 2721, 1747, 1567, 1508, 1571, 1509, 2730, 1659, 1572, 
        1513, 1574, 1514, 1576, 2863, 1518, 1578, 1519, 1579, 2864, 1526, 
        1911, 1527, 1637, 1920, 2921, 1533, 1924, 1534, 1922, 1639, 1915, 
        1953}], Line3DBox[{1188, 1498, 1719, 1499, 2712, 1563, 1504, 1720, 
        1505, 2722, 1568, 1510, 2851, 1511, 1634, 1822, 1515, 1748, 1516, 
        1635, 1823, 1520, 2852, 1749, 1521, 1636, 1750, 2885, 1528, 1725, 
        1529, 1638, 2872, 1751, 1535, 1727, 1536, 2750, 1640, 1826, 1539, 
        1754, 1540, 2764, 1730, 1543, 1916, 1544, 2773, 1926}], 
       Line3DBox[{1189, 1355, 2713, 1190, 1884, 2910, 1885, 1886, 1887, 1888, 
        1812, 2895, 1811, 1873, 1874, 1875, 1814, 1813, 1233, 1522, 2853, 
        1724, 1523, 1245, 1530, 2854, 1726, 1531, 1581, 2865, 1752, 1753, 
        1728, 1537, 2751, 1582, 1755, 1756, 1729, 1758, 1757, 2886, 1585, 
        1830, 1831, 1760, 1762, 1761, 1586, 1766, 1767, 1734, 2887, 1769, 
        1768, 1592, 1668, 1669, 2916, 1914, 1967}], Line3DBox[CompressedData["

1:eJwVzjtLgnEYxuEnyKD6FI3OTYJESUFGLgnN0dhQS2uzHRY7Z3QQJN5KQqRo
kIYkDOc+gEstnaa+QJfDxf17/8/yji2vLawORESBZDBiPhVxOhJxoxd1TT/p
JV3Xr3pFN/WbXtePuqc3dEt/6pJ+1m3+fF8PRbwwNRpxa+u880GHnPdhO84X
33SZ9f5rf8iwyR1bpN0m7A4XbDNJmUa/3XftNPtcsscMB2Td7+0heY6pcsRc
/1/cT+wDFYqcc8UZCf+NxC+m
        "]], 
       Line3DBox[{1195, 1358, 2715, 1196, 2791, 1368, 1214, 2793, 1378, 1224, 
        2796, 1388, 1236, 2801, 1398, 1248, 2809, 1407, 1259, 2816, 1417, 
        2755, 1269, 1890, 1427, 2912, 1280, 1832, 2899, 1437, 1290, 2826, 
        1448, 1301, 1710, 2879, 1457, 1311, 1863, 2897, 1864, 1816, 1817, 
        1468, 1323, 1865, 2898, 1866, 1819, 1820, 1479, 1335, 2903, 1856, 
        1857, 1855, 1489, 1346}], 
       Line3DBox[{1197, 1359, 2716, 1198, 1369, 2724, 1215, 2794, 1379, 1225, 
        2797, 1389, 1237, 2802, 1399, 1249, 2810, 1408, 1260, 2817, 1418, 
        2756, 1270, 1428, 2765, 1281, 1438, 1291, 2827, 1449, 1302, 1889, 
        2911, 1458, 1312, 1815, 2896, 1469, 1324, 2836, 1818, 1480, 1336, 
        2845, 1854, 1490, 1347}], 
       Line3DBox[{1199, 1360, 2717, 1200, 1370, 2725, 1216, 1380, 2732, 1226, 
        2798, 1390, 1238, 2803, 1400, 1250, 2811, 1409, 1261, 2818, 1419, 
        2757, 1271, 1429, 2766, 1282, 1439, 2774, 1292, 1450, 1303, 2828, 
        1459, 1313, 2830, 1470, 1325, 2837, 1481, 1337, 2846, 1491, 1348}], 
       Line3DBox[{1201, 1361, 2718, 1202, 1371, 2726, 1217, 1381, 2733, 1227, 
        1391, 2738, 1239, 2804, 1401, 1251, 2812, 1410, 1262, 2819, 1420, 
        2758, 1272, 1430, 2767, 1283, 1440, 2775, 1293, 1451, 2779, 1304, 
        1460, 1314, 2831, 1471, 1326, 2838, 1482, 1338, 2847, 1492, 1349}], 
       Line3DBox[{1203, 1362, 2719, 1204, 1372, 2727, 1218, 1382, 2734, 1228, 
        1392, 2739, 1240, 1402, 2743, 1252, 2813, 1411, 1263, 2820, 1421, 
        2759, 1273, 1431, 2768, 1284, 1441, 2776, 1294, 1452, 2780, 1305, 
        1461, 2783, 1315, 2832, 1472, 1327, 2839, 1483, 1339, 2848, 1493, 
        1350}], Line3DBox[{1205, 1363, 2720, 1206, 1373, 2728, 1219, 1383, 
        2735, 1229, 1393, 2740, 1241, 1403, 2744, 1253, 1412, 2747, 1264, 
        2821, 1422, 2760, 1274, 1432, 2769, 1285, 1442, 2777, 1295, 1453, 
        2781, 1306, 1462, 2784, 1316, 1473, 2786, 1328, 2840, 1484, 1340, 
        2849, 1494, 1351}], 
       Line3DBox[{1207, 1564, 2860, 1565, 1208, 1374, 2729, 1220, 1384, 2736, 
        1230, 1394, 2741, 1242, 1404, 2745, 1254, 1413, 2748, 1265, 1423, 
        2761, 2762, 1275, 1433, 2770, 1286, 1443, 2778, 1296, 1454, 2782, 
        1307, 1463, 2785, 1317, 1474, 2787, 1329, 1485, 2788, 1341, 1620, 
        1621, 1622}], Line3DBox[{1963, 1344}], 
       Line3DBox[{1345, 1488, 1655, 1633, 1691, 2871, 1690, 1334, 1478, 1801, 
        1631, 1800, 2870, 1799, 1322, 1467, 1798, 1627, 1796, 2868, 1795, 
        1310, 1456, 1853, 1852, 2902, 1552, 1300, 1447, 2856, 1547, 1289, 
        1436, 2855, 1833, 1835, 1834, 1279, 1426, 2877, 1705, 1268, 2754, 
        1416, 2815, 1258, 1406, 2808, 1247, 1397, 2800, 1235, 1387, 2795, 
        1223, 1377, 2792, 1213, 1367, 2790, 1194, 1357, 2789, 1192}], 
       Line3DBox[{1560, 1906, 1956}], 
       Line3DBox[{1614, 1613, 1913, 1612, 1964}], 
       Line3DBox[{1618, 1894, 1616, 1895, 1615, 1883, 1946}], 
       Line3DBox[{1927, 1590, 1589, 1950}], 
       Line3DBox[{1929, 2805, 1243, 1395, 1869, 2906, 1923, 1231, 1385, 1868, 
        1867, 1896, 1901, 1934}], Line3DBox[{1931, 1900, 2771, 1904, 1944}], 
       Line3DBox[{1942, 1735, 1908, 2920, 1951}], 
       Line3DBox[{1948, 1849, 1850, 2901, 1891, 1878, 1824, 1825, 1425, 2913, 
        1277, 1958}], Line3DBox[{1966, 1599, 1676, 1677, 1962}]}, {}, {}}},
    VertexNormals->CompressedData["
1:eJzsvXk0l1/79y0yVYaKUkiD0qAiKVEdCQkhU1IpY0WJCkVFKhFJIjMhs8zz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     "]], {}},
  Axes->True,
  AxesEdge->{{-1, -1}, {1, -1}, {-1, -1}},
  AxesLabel->{None, None, None},
  AxesOrigin->{Automatic, Automatic, Automatic},
  AxesStyle->GrayLevel[0],
  BaseStyle->{
    Specularity[1.], 
    RGBColor[0.1, 0.1, 0.1]},
  BoxRatios->{1, 1, 0.4},
  BoxStyle->GrayLevel[0, 0.5],
  Boxed->{Back, Bottom, Left},
  DisplayFunction->Identity,
  FaceGrids->None,
  FaceGridsStyle->Automatic,
  ImageSize->{303.6483432658202, 165.2617713666014},
  ImageSizeRaw->Automatic,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Lighting->{{"Ambient", 
     Hue[0., 0., 1.]}, {"Directional", 
     GrayLevel[0.6], 
     ImageScaled[{1, 1, 3}]}},
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0], 
      Opacity[0.2]], 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "RotationControl" -> 
    "Globe"},
  PlotRange->{{-7, 1}, {0, 1.1}, {1.2731377085055304`, 2.848884229395725}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic},
  TicksStyle->GrayLevel[0],
  ViewPoint->{3.295363316960594, 0.0543802627657527, 0.7665659764508438},
  ViewVertical->{-0.22651015179499867`, -0.0037378827124548092`, 
   0.9740016321170282}]], "Output",
 CellChangeTimes->{3.859303137145255*^9, 3.859303201322892*^9},
 CellLabel->
  "Out[460]=",ExpressionUUID->"e9039af5-35c2-4098-9f8f-f56ea5caa5eb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Norm", "[", 
      RowBox[{
       RowBox[{"Phi", ".", "wstar"}], " ", "-", " ", "V"}], "]"}], " ", "/.", 
     " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"eta", "->", "0."}], ",", 
       RowBox[{"p", "->", "0.4"}]}], "}"}]}], " ", "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"tmp", "==", 
    RowBox[{"Norm", "[", "V", "]"}]}], ",", "q"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"tmp", ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.857312764600555*^9, 3.857312798025824*^9}, {
   3.857312904046273*^9, 3.857312909765922*^9}, {3.857314189320052*^9, 
   3.85731421902691*^9}, {3.85819065878332*^9, 3.858190661081297*^9}, 
   3.858876572167068*^9, {3.858881605844059*^9, 3.85888162442651*^9}, 
   3.85888345832736*^9, {3.8590474762785587`*^9, 3.859047495503031*^9}, {
   3.85904753561593*^9, 3.859047537698944*^9}, {3.859047855453006*^9, 
   3.859047870363021*^9}, {3.859048696417774*^9, 3.8590487137321997`*^9}, {
   3.859055453104514*^9, 3.859055495591331*^9}, {3.859055904499709*^9, 
   3.859055914017281*^9}, {3.8590559643775063`*^9, 3.859055966513176*^9}, {
   3.859056076283925*^9, 3.859056110789381*^9}, {3.8590562418324137`*^9, 
   3.859056266065133*^9}, {3.859062141416057*^9, 3.859062187229607*^9}, {
   3.859062217390265*^9, 3.8590622445373774`*^9}, {3.859062707788527*^9, 
   3.859062774109733*^9}, {3.859062966941868*^9, 3.859062993795004*^9}, {
   3.8590631209041986`*^9, 3.859063124575926*^9}, {3.859147010719585*^9, 
   3.859147050356143*^9}, {3.859147218425756*^9, 3.8591472190720253`*^9}, {
   3.859147373760991*^9, 3.859147373909642*^9}, 3.859147675930709*^9, {
   3.859151095027693*^9, 3.859151096029614*^9}, {3.859151836585585*^9, 
   3.859151837298563*^9}, {3.859299376600576*^9, 3.859299401412448*^9}, {
   3.859299543426854*^9, 3.859299563239133*^9}, {3.859299649013667*^9, 
   3.859299649736368*^9}, {3.859299706933628*^9, 3.859299719983459*^9}, 
   3.859303225752571*^9},
 CellLabel->
  "In[461]:=",ExpressionUUID->"bcd75a85-a5a4-42fd-9cb7-137e413fd55f"],

Cell[BoxData[
 TemplateBox[{
  "Solve", "ratnz", 
   "\"Solve was unable to solve the system with inexact coefficients. The \
answer was obtained by solving a corresponding exact system and numericizing \
the result.\"", 2, 462, 17, 21870419949072214632, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.8592994195130033`*^9, 3.859299475931917*^9, {3.8592995439630823`*^9, 
   3.859299564594285*^9}, 3.859299651015707*^9, {3.8592997084059362`*^9, 
   3.859299721575346*^9}, 3.859299775739303*^9, 3.859299826835305*^9, 
   3.859299893424601*^9, 3.8593025361249237`*^9, 3.859302678847888*^9, 
   3.859302767130571*^9, 3.859302806385407*^9, 3.859302932733715*^9, 
   3.8593032270901127`*^9},
 CellLabel->
  "During evaluation of \
In[461]:=",ExpressionUUID->"3675d037-f4ab-480b-8215-2e7116f3620b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"q", "\[Rule]", 
     RowBox[{"-", "1085.0348326021167`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", "\[Rule]", 
     RowBox[{"-", "5.277563107458919`*^-17"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", "\[Rule]", "4.0200927477892`*^-15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", "\[Rule]", "1.2071003374691434`"}], "}"}]}], "}"}]], "Output",\

 CellChangeTimes->{
  3.8590561207915573`*^9, 3.8590562513987207`*^9, {3.8590562853953447`*^9, 
   3.8590562895427933`*^9}, {3.8590621370878277`*^9, 3.859062244936511*^9}, {
   3.859062712026423*^9, 3.859062775805958*^9}, {3.859062968762806*^9, 
   3.859063003764666*^9}, 3.859063037925103*^9, 3.859063126209156*^9, 
   3.85906359950768*^9, 3.8590637568125057`*^9, 3.859063852134437*^9, {
   3.859146993637477*^9, 3.8591470508041983`*^9}, 3.859147219693242*^9, 
   3.859147374339026*^9, 3.859147677366959*^9, 3.85915007642023*^9, 
   3.8591508548645372`*^9, 3.85915109639118*^9, 3.859151837721479*^9, 
   3.859299308954796*^9, 3.859299377246327*^9, 3.85929941957027*^9, 
   3.859299475987103*^9, {3.859299544240425*^9, 3.859299564652402*^9}, 
   3.859299651289535*^9, {3.859299708678604*^9, 3.859299721636903*^9}, 
   3.859299775797634*^9, 3.859299827111514*^9, 3.859299893481822*^9, 
   3.85930253639972*^9, 3.8593026793290854`*^9, 3.859302767612673*^9, 
   3.859302806446602*^9, 3.859302932794887*^9, 3.859303227375152*^9},
 CellLabel->
  "Out[462]=",ExpressionUUID->"7c5759f7-f382-4144-80a7-480692507c9f"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwVj3k01I0bxRGJShrrWMcwzFgy9jXPU4iK15J2JAl5S4h2iURZSpJEKrQQ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       "]], 
      LineBox[CompressedData["
1:eJwBYQOe/CFib1JlAgAAADUAAAACAAAA9uRvkORf7j8lMTGPEK0+QDJ1ebcU
au4/lRAVVmSnPUCKIDu1x2zuPyt8gLXkZD1A48v8snpv7j/QOG6ZeCM9QJQi
gK7gdO4/5vhjocCjPED3z4alrH/uP2Rw/+4ksDtAUHtIo1+C7j+MY6cak3U7
QKgmCqEShe4/B8FEO+U7O0BafY2ceIruPyaJouUgyzpAvCqUk0SV7j96utL4
bvM5QICFoYHcqu4/6MrNAp5nOEANdwdKYa3uP1/ffetDPDhAmmhtEuav7j+o
QxljdhE4QLNLOaPvtO4/GkW4dna9N0DmEdHEAr/uP7V8Cw2dGzdAS54ACCnT
7j/GwL3Fg+41QNiPZtCt1e4/Pe9ZSNbKNUBkgcyYMtjuP+7dh9+RpzVAfmSY
KTzd7j+jXOwiPWI1QLAqMEtP5+4/QKXWGjTcNEAWt1+OdfvuP+JoIkJD4TNA
o6jFVvr97j+xiXwCZMMzQDCaKx9/AO8/bu2pXdWlM0BJffeviAXvP+24v9uk
azNAfEOP0ZsP7z9QNJIp1foyQOLPvhTCI+8/EshGgIAmMkCt6B2bDkzvP6Rm
zeI+rDBAiJ2FYN5O7z+aowHu5pMwQGRS7SWuUe8/Y7gNuM17MEAcvLywTVfv
P3tFqcpTTDBAio9bxoxi7z9HPYJ6UeAvQGg2mfEKee8/vFuqO3WELkBE6wC3
2nvvP/RYVeLOWi5AH6BofKp+7z8+te3zizEuQNYJOAdKhO8/lIPE2SrgLUBF
3dYciY/vP8IhFaHWQS1AIoQUSAem7z+b3HAN0RUsQP44fA3XqO8/2PR+E8nx
K0DZ7ePSpqvvP+4TzzERzitAkFezXUax7z/lOxaYjYcrQP8qUnOFvO8/nix+
Khv+KkDc0Y+eA9PvPzCDQAW4+ClAuIb3Y9PV7z+a972rPtkpQJQ7Xymj2O8/
Ei/5yga6KUBLpS60Qt7vP+mvikxYfClAunjNyYHp7z9Lucf86gMpQJYtNY9R
7O8/NNA/8mfmKEBx4pxUIe/vPxTXPGMgyShAKExs38D07z+mg0rxQI8oQAQB
1KSQ9+8/Vpf+sadyKEDgtTtqYPrvPxVKYzVHVihAvGqjLzD97z/LwO7THjoo
QJcfC/X//+8/Oeyn6C0eKEAaBKK5
       "]]},
     Annotation[#, "Charting`Private`Tag$2027126#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 4.564701628671672},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {4.564701628671663, 30.6760339255426}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.8590561207915573`*^9, 3.8590562513987207`*^9, {3.8590562853953447`*^9, 
   3.8590562895427933`*^9}, {3.8590621370878277`*^9, 3.859062244936511*^9}, {
   3.859062712026423*^9, 3.859062775805958*^9}, {3.859062968762806*^9, 
   3.859063003764666*^9}, 3.859063037925103*^9, 3.859063126209156*^9, 
   3.85906359950768*^9, 3.8590637568125057`*^9, 3.859063852134437*^9, {
   3.859146993637477*^9, 3.8591470508041983`*^9}, 3.859147219693242*^9, 
   3.859147374339026*^9, 3.859147677366959*^9, 3.85915007642023*^9, 
   3.8591508548645372`*^9, 3.85915109639118*^9, 3.859151837721479*^9, 
   3.859299308954796*^9, 3.859299377246327*^9, 3.85929941957027*^9, 
   3.859299475987103*^9, {3.859299544240425*^9, 3.859299564652402*^9}, 
   3.859299651289535*^9, {3.859299708678604*^9, 3.859299721636903*^9}, 
   3.859299775797634*^9, 3.859299827111514*^9, 3.859299893481822*^9, 
   3.85930253639972*^9, 3.8593026793290854`*^9, 3.859302767612673*^9, 
   3.859302806446602*^9, 3.859302932794887*^9, 3.859303227444853*^9},
 CellLabel->
  "Out[463]=",ExpressionUUID->"888391cd-7947-4c04-9ca7-6037dc5691c0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Finding different incompatible examples", "Section",
 CellChangeTimes->{{3.8588766015102797`*^9, 3.858876656039743*^9}, {
  3.8590615585572023`*^9, 
  3.859061564197502*^9}},ExpressionUUID->"cdaed246-7d2d-4bd4-ab55-\
763c594c4588"],

Cell["Guess and Check:", "Text",
 CellChangeTimes->{{3.859048050389254*^9, 3.8590480567715387`*^9}, {
  3.859048120093409*^9, 3.8590481293137083`*^9}, {3.859302944088767*^9, 
  3.8593029502251587`*^9}},ExpressionUUID->"102b5072-7854-4375-ac95-\
da85f8f850ba"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"tmp", "=", 
     RowBox[{
      RowBox[{"Norm", "[", 
       RowBox[{
        RowBox[{"Phi", ".", "wstar"}], "-", "V"}], "]"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"epsilon", "->", "0.0001"}], ",", " ", 
        RowBox[{"p", "->", "0.77"}], ",", " ", 
        RowBox[{"q", "->", "0.81"}], ",", 
        RowBox[{"z", "->", ".2"}]}], "}"}]}]}], ";"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"tmp", "=", 
     RowBox[{
      RowBox[{"Norm", "[", 
       RowBox[{
        RowBox[{"Phi", ".", "wstar"}], "-", "V"}], "]"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"epsilon", "->", "0.0001"}], ",", " ", 
        RowBox[{"p", "->", "0.77"}], ",", " ", 
        RowBox[{"q", "->", "0.85"}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Det", "[", "sA", "]"}], "==", "0"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"p", "->", "0.77"}], ",", 
       RowBox[{"q", "->", "0.85"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Minimize", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tmp", ",", 
       RowBox[{"eta", ">", "0"}]}], "}"}], ",", "eta"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{"tmp", "<", "1"}], "&&", 
     RowBox[{"eta", ">", "0"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"plot1", "=", 
    RowBox[{"LogPlot", "[", 
     RowBox[{
      RowBox[{"tmp", "/.", 
       RowBox[{"{", 
        RowBox[{"eta", "->", 
         RowBox[{"10", "^", "etax"}]}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"etax", ",", " ", 
        RowBox[{"-", "9"}], ",", " ", "4"}], "}"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.8591472889722433`*^9, 3.85914730784096*^9}, {
   3.859147380405471*^9, 3.859147411997304*^9}, {3.859147502336302*^9, 
   3.859147547592536*^9}, {3.8591501824195757`*^9, 3.8591501847619047`*^9}, {
   3.85915093572861*^9, 3.859150937922926*^9}, {3.859151008560668*^9, 
   3.859151008832382*^9}, {3.859151372474163*^9, 3.859151425421136*^9}, {
   3.859151464244089*^9, 3.8591514652157497`*^9}, {3.859151617633904*^9, 
   3.859151635520959*^9}, {3.859151729174575*^9, 3.859151783692884*^9}, 
   3.859151814838126*^9, {3.859151854898387*^9, 3.859151885839718*^9}, {
   3.859299321149007*^9, 3.859299324817564*^9}, {3.859299574249734*^9, 
   3.859299627149169*^9}, 3.8593023665861177`*^9, 3.8593027894280443`*^9, {
   3.8593029530480757`*^9, 3.859302985589437*^9}, {3.8593030539823837`*^9, 
   3.8593030650900517`*^9}, {3.8593034258785152`*^9, 3.859303465194016*^9}, 
   3.859303619269696*^9, {3.859304695394019*^9, 3.8593047437806892`*^9}},
 CellLabel->
  "In[581]:=",ExpressionUUID->"8f40f9fd-67f1-4f8c-9b38-eed28c34c35d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"eta", "\[Rule]", 
     RowBox[{"-", "0.20420177327092964`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"eta", "\[Rule]", 
     RowBox[{"-", "0.00009784654684628233`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"eta", "\[Rule]", 
     RowBox[{"-", "1.4042001706683033`*^-6"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.859147308807873*^9, {3.85914738472653*^9, 3.859147412815557*^9}, {
   3.859147503404664*^9, 3.8591475487037077`*^9}, 3.859150185846476*^9, 
   3.859150244753652*^9, 3.859150886485585*^9, 3.859150938957099*^9, 
   3.859151009814671*^9, {3.859151373305189*^9, 3.859151426284684*^9}, 
   3.859151467769183*^9, {3.859151621343783*^9, 3.8591516365275717`*^9}, {
   3.859151730283422*^9, 3.859151784712633*^9}, 3.859151815610463*^9, {
   3.859151858893196*^9, 3.8591518867635508`*^9}, {3.859299311163911*^9, 
   3.859299336418507*^9}, 3.859299479409315*^9, {3.8592995761034727`*^9, 
   3.859299585043943*^9}, 3.859299629817025*^9, 3.859299780975836*^9, 
   3.85929983731146*^9, 3.859299895280464*^9, 3.859302372827755*^9, 
   3.859302542997607*^9, 3.8593026830910063`*^9, 3.859302770977264*^9, 
   3.859302809590507*^9, {3.859302935152063*^9, 3.859302960966761*^9}, 
   3.859302992853497*^9, 3.8593030667185183`*^9, {3.8593034361557627`*^9, 
   3.8593034673170633`*^9}, 3.8593036214080477`*^9, {3.859304729659971*^9, 
   3.8593047444110537`*^9}},
 CellLabel->
  "Out[582]=",ExpressionUUID->"bd07bc3b-06d8-4223-b57d-358729d6098d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.2377210629878934`", ",", 
   RowBox[{"{", 
    RowBox[{"eta", "\[Rule]", "2.3574241643244255`*^-6"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.859147308807873*^9, {3.85914738472653*^9, 3.859147412815557*^9}, {
   3.859147503404664*^9, 3.8591475487037077`*^9}, 3.859150185846476*^9, 
   3.859150244753652*^9, 3.859150886485585*^9, 3.859150938957099*^9, 
   3.859151009814671*^9, {3.859151373305189*^9, 3.859151426284684*^9}, 
   3.859151467769183*^9, {3.859151621343783*^9, 3.8591516365275717`*^9}, {
   3.859151730283422*^9, 3.859151784712633*^9}, 3.859151815610463*^9, {
   3.859151858893196*^9, 3.8591518867635508`*^9}, {3.859299311163911*^9, 
   3.859299336418507*^9}, 3.859299479409315*^9, {3.8592995761034727`*^9, 
   3.859299585043943*^9}, 3.859299629817025*^9, 3.859299780975836*^9, 
   3.85929983731146*^9, 3.859299895280464*^9, 3.859302372827755*^9, 
   3.859302542997607*^9, 3.8593026830910063`*^9, 3.859302770977264*^9, 
   3.859302809590507*^9, {3.859302935152063*^9, 3.859302960966761*^9}, 
   3.859302992853497*^9, 3.8593030667185183`*^9, {3.8593034361557627`*^9, 
   3.8593034673170633`*^9}, 3.8593036214080477`*^9, {3.859304729659971*^9, 
   3.859304745578197*^9}},
 CellLabel->
  "Out[583]=",ExpressionUUID->"caab9a6f-af7d-458c-92ae-7545b6feba72"],

Cell[BoxData[
 TemplateBox[{
  "Reduce", "ratnz", 
   "\"Reduce was unable to solve the system with inexact coefficients. The \
answer was obtained by solving a corresponding exact system and numericizing \
the result.\"", 2, 584, 37, 21870419949072214632, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.859303437123329*^9, 3.859303468156961*^9}, 
   3.8593036222273006`*^9, {3.859304730446499*^9, 3.859304746358246*^9}},
 CellLabel->
  "During evaluation of \
In[581]:=",ExpressionUUID->"b741b896-f45a-4728-846f-c59d46016863"],

Cell[BoxData[
 RowBox[{"1.1047195318552464`*^-6", "<", "eta", "<", 
  "6.0616540851787215`*^-6"}]], "Output",
 CellChangeTimes->{
  3.859147308807873*^9, {3.85914738472653*^9, 3.859147412815557*^9}, {
   3.859147503404664*^9, 3.8591475487037077`*^9}, 3.859150185846476*^9, 
   3.859150244753652*^9, 3.859150886485585*^9, 3.859150938957099*^9, 
   3.859151009814671*^9, {3.859151373305189*^9, 3.859151426284684*^9}, 
   3.859151467769183*^9, {3.859151621343783*^9, 3.8591516365275717`*^9}, {
   3.859151730283422*^9, 3.859151784712633*^9}, 3.859151815610463*^9, {
   3.859151858893196*^9, 3.8591518867635508`*^9}, {3.859299311163911*^9, 
   3.859299336418507*^9}, 3.859299479409315*^9, {3.8592995761034727`*^9, 
   3.859299585043943*^9}, 3.859299629817025*^9, 3.859299780975836*^9, 
   3.85929983731146*^9, 3.859299895280464*^9, 3.859302372827755*^9, 
   3.859302542997607*^9, 3.8593026830910063`*^9, 3.859302770977264*^9, 
   3.859302809590507*^9, {3.859302935152063*^9, 3.859302960966761*^9}, 
   3.859302992853497*^9, 3.8593030667185183`*^9, {3.8593034361557627`*^9, 
   3.8593034673170633`*^9}, 3.8593036214080477`*^9, {3.859304729659971*^9, 
   3.859304746417961*^9}},
 CellLabel->
  "Out[584]=",ExpressionUUID->"a96d0eff-42da-4b9f-a8c1-9620b58c25bc"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwV1Hk0lVsbAHCUpNxKA2c+70u5FMpUmjwlpDRxG4iIkrGkAZdQhlSiQmaS
hIgkEUlPJKUyRHGTIeQYDs55pe8W8r33j732+q1n7b3X2s9AOnhYOEpJSEg8
ptd/e64s83/T0ySG7usVSogo2J+yy258isSiOflSP0YpkNAKqRmcIHFGQNHv
Qdp7LUfjPv6PxO6+4Oxm2r8zq/VzR0k8s/BIeSZtC6NTvvs7SWw6LrxvTHuy
JavbrJ3EtfI4ey3tLLf27ZvbSFTKeGai/l88ypSt3kKisi3HeSHtzK+8csl6
Ei/3heu3j1DwK+Dt1P0KEtus2PXutDMWSh5LLyfR142xwpb27szVdXFlJP5u
Dzu6+7/4+9upQcUkqil4n9CivYvjA5b5JD4pO/dxbJiC9NKlF2akkvjXy5cZ
nrS3ffefedCfRJ0EwYtdQgoKd1/yVvYjcVqh9Oxa2qzcqEGhD33/ctkxZdpC
+6yGwDMklsv82PrvEAWR9Q3Jd91IfBPoapZKuzlHWU9sReKHWevXdA5SsHGW
ZnbZARLnTXkZvKKdaa/PDtlHYvu3t9J5tL0ZOyUVzUlsMdD68Ddt1kWv9xtM
SdTISN+9gPZh+zeOl1aTOCDYY7xqgII35U2t5rokymz6MLWQtjajw4ytTSLr
lbPbeD8FM+oprXwNEp8bfnQopZ25gfO7aSmJS7ZA3kbaQkWPWP4iEr9cdv69
WkC/X7e4pniUwApzy+i+Xgo+FfxdfXeYQCnPS5IvaOtGd1TFDBHYozRTIYm2
6EA2nhIQKH0kRHMXbdev68s0Owl06q6ULuihwOa7Q15mHYGfmwzD7LspKPtU
k3vzHYFXHh4R69FmlqrnhNQS2Lfde0yW9if/H5kOrwiUGY9+WvCVzqfMlTRe
BYG9JcPws4sCQ9bD6Ng8Av3XJ+qc7aQgbXJJVGgugV47nO4Y0p7u8L1+5h6B
fh4hifNpl98xirC4S+CuOA1WdgcFehqtF+elEBivxoamdgpUN03/ffEqgWc/
Gi2R/0LBH8d2HvZyI9C86IyMUitdP9f0nnu4EBhkVPVXZwsF60q5PBcnAg8m
L5yZTNtZbqTN+giByoXTVxbRflkYeWCzNYFVQnfZiY8U+E7X75IzIzBYzPDJ
aaJAXu1JnvQ2Ah/X77A4RDvbIk1u2oRA5xLCZz7tT3dP1ooNCSwIlk/z/ECB
1g55k5Z1BOYe42prNFLQH2+xMX05gfIRf3wOrKMgsHJdcpIqfd7maJoKbQWh
0kSMCoHRgpWx795TYARjT8KUCLTuDJutQPvWt2jd4ywCvy0eb0x9S/e39scV
+nMIbM2LXH3xNQUX4x7oJjfx8eDOaYOUFxSs8lWbvaaej1Wu95BN+7PNnbbG
Wj52Wv35Kx4pWKkUFyRTyUfPrPSwa88paL0f0HCqgI9hOwQP3J9RoFa5031b
BB99OY66vU/ofsiogd5LfHzTeCh5B+2AsM2LAkP4OLjINuRRCQUfduiVFfnx
cfMW0+pzxfT/tXBmE658zPM7mTr5iIJ3wqE7P0z46HhfYUV+PgVe9Y7eNwz5
aCf4t2QyjwKisHO7ugEfv3rlB2+jfca7SWyvx8e2iNbq9lwKuFJP4b0yHz83
JHqJsik4oXil7Y4EH2vu5nqUpdP5MVRdZF7GQ8GNuOPPYuh+0T4wtbqYh3qT
vvc+R1OwQfmigFPIw/2rH9aNR1FwbGbv0/57PDTKOfti2Q263l7dOno+gYcO
0b7lbhF0fZgpFj/w4WGtdWFQeCg9H9ebpN08w8NzMRUjISEURKufveJ3kod+
DAORXzAFFX802W515uG3TGGywwUKFjVEynQe4KHKA/8JeX86vneW1bw1PFTs
z44ZO03PX2O9Ld+1eRi1aUlM1SkKBvSOanzW5GFbNu/1dU8KFitWSmaq8BDM
Oh8pedD9+Y9/zkYFHu6QyOxUdqVgie34hPs4F3t9Uy7ctKPA3ak39e0jLkas
sDkoZUrnR1CeavWAi4fyR9+bmlBw3elmqiCHi47srvYrRhQUOZmkzkjnYkNU
YKbkZnp+O2WnrL/OxRPjxqlP1lIQ7uyenOvORf1WScHm5RQk9xslr3Xmoqx9
zKMNqhTkO3OTa45w8aH6ClttFTr/znVJPQe5+CynkDlPiZ5/LquS2Nu4GM8x
Kg1lUpDj8j0hfBkXEzkLslxk6P8eeJfAJLn4409SUk6agjqXuwlZHC6GV9hb
Z0tRQLnsT6haxMVqW/3muikxrHV9Ej8hycWtayLVGsfE8Nr1XJxbBwddLHk+
KR1iELjNvGkWx8Hq/edntOeLwdW3Z99IFAfHJeeE5OeKQXipUuFGJAdNk3+T
PtlioO6ej/8UykEVEzmXsdti+N05mWR/hoMTTe1TYTFiUNg7nu5tzsElk63e
ij5iSHBoPsLaycG5KjpH7c+IgeP5aOkzUw4GdAuU00+KQSnSM1NqEwcfG0q/
lHERg8br4XsRmhwsrBmStbcSg9GGvoI7czm45wXOX6Mvhprt1Z4mMhycn3bO
tEdHDNutMrQHpDh4TKj9KWSlGPZ4ORRp/mKjww35y1kqYrAp6Cgp7Wcjo+SZ
q/NiMZxe2lJRX81GyYASwGERpMu9fjcRyMY28dOwiVgRLFCzyRjwY6Oa/NjP
8zdEEGAs8mvxZuPOoey+n+EisA5grHjkwcb7RYrPq8+LYLHI+bKrHRvlri0w
q3QRQWiTrMk/Bmw8bXhuXHetCL6PpnBr1rHxS9bVQ73aInCQ0x4vWs3GDcYT
h0PVRWBgfDDjuiYbNRP6nyTxRfCjOEfKlMfG7WnjSxSkReCcaPa8eIqFOdfN
Hm5NHIVPxZ2xGT9ZeAWN/MvCR8Go6fSJqHEWWrd368j5jwIhl8w9McxCPhmk
b2Y3Cv/4C/2WtbOwWqnAdqXSKGy3j9CPKWfhSomGTrPbI6ChWv/Q04+Fxd9q
H0cEDQOjWe6WjDcLPbbUclOPD4PU+e1XU06xMDdDcYGf5TC0tlQfe+PCwl+a
wsR4jWEICitnk5YsjDm5W3fvRyG09t0LbdBl4XGdp3aWLCFURglOHVvFwvk6
iiFjkkLIM1h2eHIFC6MuzS20GBiCoNi0darKLFw+DC0HS4ZAwyRuNFCehU90
ZTIu7KHjd0OsVo4wUTZS+Xaq1yAcN680qR5gYtfkbJ7WwUGwnJrWsf7GRPOZ
Ddf8Nw6Cxj6/eWFfmHjoQ1L45hmD0DrzVFVHLRON3o9IOYQPgMZRO43ILCbO
OppVYBvRD61K6ySHDzNxV+1QabRFH+R/UZeus2Hi4s8/y89q9kFILF/2gSUT
Yxvids2Y0wer5kjLe+6hzwsSy7n4DS6J64lxYKLDi62+a1S/wRp03DTFY6Jj
I+OnlqAH5HwtjTpYTPRr+nel/bMe6NYxM32uwMQSX0pKI7oHIrNW7bkwj4nr
mwONYjf2QF/khJ30bwbOsltXdT2iG2IP3Qj8o52BIwmescrMr+CuGBI80srA
6Iyz/TH9XWDY6BVW38zAirrGgWslXTBiZHPtxjsGznVKvMrd2wXG6n/eWlLO
QN3gUomueZ3w/Vd5BTeJgSdsxFZbctvgr/j+KQ0rBi5IM7E3nd0MiV1fK5X3
MdC5K9i5L7QJulTbwpjmDByLW6aqJdUEJ0rfy0tvY+ADTZws/dEIoYOr2tM2
MPCXXP5k0e4G+D90R8gz
       "]], LineBox[CompressedData["
1:eJwV13k0Vd8XAHAeHp75kfiSQpqLyqzsmyQyD6EUEimRMSpjUkJUiqhfoTIk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       "]]},
     Annotation[#, "Charting`Private`Tag$2516548#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0.2548649280144698},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{
     Charting`ScaledTicks[
     "Log", {Log, Exp}, "Nice", WorkingPrecision -> MachinePrecision, 
      RotateLabel -> 0], 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{{-9, 4}, {0.2548649280144698, 1.1835946324912083`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{Automatic, 
     Charting`ScaledTicks[
     "Log", {Log, Exp}, "Nice", WorkingPrecision -> MachinePrecision, 
      RotateLabel -> 0]}, {Automatic, {{0.4054651081081644, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"1.5\"", ShowStringCharacters -> False], 1.5, AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {
      0.6931471805599453, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"2.0\"", ShowStringCharacters -> False], 2., AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {
      0.9162907318741551, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"2.5\"", ShowStringCharacters -> False], 2.5, AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {
      1.0986122886681098`, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"3.0\"", ShowStringCharacters -> False], 3., AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {0., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.09531017980432493, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.1823215567939546, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.26236426446749106`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.3364722366212129, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.47000362924573563`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.5306282510621704, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.5877866649021191, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.6418538861723947, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.7419373447293773, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.7884573603642703, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.8329091229351039, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.8754687373538999, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.9555114450274363, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.9932517730102834, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.0296194171811581`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.0647107369924282`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.1314021114911006`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.1631508098056809`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.1939224684724346`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.2237754316221157`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.252762968495368, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}],
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.859147308807873*^9, {3.85914738472653*^9, 3.859147412815557*^9}, {
   3.859147503404664*^9, 3.8591475487037077`*^9}, 3.859150185846476*^9, 
   3.859150244753652*^9, 3.859150886485585*^9, 3.859150938957099*^9, 
   3.859151009814671*^9, {3.859151373305189*^9, 3.859151426284684*^9}, 
   3.859151467769183*^9, {3.859151621343783*^9, 3.8591516365275717`*^9}, {
   3.859151730283422*^9, 3.859151784712633*^9}, 3.859151815610463*^9, {
   3.859151858893196*^9, 3.8591518867635508`*^9}, {3.859299311163911*^9, 
   3.859299336418507*^9}, 3.859299479409315*^9, {3.8592995761034727`*^9, 
   3.859299585043943*^9}, 3.859299629817025*^9, 3.859299780975836*^9, 
   3.85929983731146*^9, 3.859299895280464*^9, 3.859302372827755*^9, 
   3.859302542997607*^9, 3.8593026830910063`*^9, 3.859302770977264*^9, 
   3.859302809590507*^9, {3.859302935152063*^9, 3.859302960966761*^9}, 
   3.859302992853497*^9, 3.8593030667185183`*^9, {3.8593034361557627`*^9, 
   3.8593034673170633`*^9}, 3.8593036214080477`*^9, {3.859304729659971*^9, 
   3.859304746859763*^9}},
 CellLabel->
  "Out[585]=",ExpressionUUID->"e2a6d51d-a698-4ff3-bf04-ce95da0d2b21"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{
      RowBox[{"Phi", ".", "wstar"}], "-", "V"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"epsilon", "->", "0.0001"}], ",", " ", 
      RowBox[{"p", "->", "0.4"}], ",", " ", 
      RowBox[{"q", "->", "0.9"}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Det", "[", "sA", "]"}], "==", "0"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"p", "->", "0.4"}], ",", 
     RowBox[{"q", "->", "0.9"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"tmp", ",", 
     RowBox[{"eta", ">", "0"}]}], "}"}], ",", "eta"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"tmp", "<", "1"}], "&&", 
   RowBox[{"eta", ">", "0"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"plot2", "=", 
  RowBox[{"LogPlot", "[", 
   RowBox[{
    RowBox[{"tmp", "/.", 
     RowBox[{"{", 
      RowBox[{"eta", "->", 
       RowBox[{"10", "^", "etax"}]}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"etax", ",", " ", 
      RowBox[{"-", "9"}], ",", " ", "4"}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{
  3.8591471807910757`*^9, {3.859147251865629*^9, 3.8591472739801197`*^9}, {
   3.8591477194585943`*^9, 3.859147868136196*^9}, {3.8591501484045057`*^9, 
   3.859150151192528*^9}, 3.859150280724474*^9, {3.859150903413378*^9, 
   3.859150917836667*^9}, {3.859150997441326*^9, 3.859151001615592*^9}, {
   3.859151109164513*^9, 3.85915111102879*^9}, {3.859151564418458*^9, 
   3.8591515932989073`*^9}, {3.859299327593082*^9, 3.859299331383515*^9}, {
   3.859299635175828*^9, 3.859299635559538*^9}, {3.859299671880075*^9, 
   3.859299691298479*^9}, 3.859302368585883*^9, {3.8593032397803307`*^9, 
   3.859303240768408*^9}, {3.859303475520176*^9, 3.859303475687724*^9}, {
   3.8593036291416073`*^9, 3.859303631700037*^9}, {3.8593047487707872`*^9, 
   3.859304752668633*^9}},
 CellLabel->
  "In[586]:=",ExpressionUUID->"f57be62e-c545-44e2-bdd0-66cf7c8ca389"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"eta", "\[Rule]", 
     RowBox[{"-", "0.16424438138225747`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"eta", "\[Rule]", "6.171623883203858`*^-8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"eta", "\[Rule]", "0.00007626619915200687`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8591471829913883`*^9, {3.8591472613590603`*^9, 3.8591472750399733`*^9}, {
   3.859147721834292*^9, 3.8591478689051857`*^9}, 3.859150152413829*^9, 
   3.859150241528013*^9, {3.859150883874247*^9, 3.859150918888023*^9}, {
   3.8591509985599127`*^9, 3.859151002711279*^9}, 3.859151111833023*^9, {
   3.859151580534554*^9, 3.8591515940515137`*^9}, {3.859299314364765*^9, 
   3.859299338328168*^9}, 3.8592994836809473`*^9, 3.859299588459731*^9, 
   3.859299636576111*^9, {3.8592996747439117`*^9, 3.8592996918497763`*^9}, 
   3.859299786688396*^9, 3.85929984433379*^9, 3.859299899267267*^9, 
   3.8592999319000196`*^9, 3.859302376315982*^9, 3.85930254973429*^9, 
   3.85930268968602*^9, 3.859302775465211*^9, 3.8593028164415083`*^9, 
   3.859302938174296*^9, 3.8593032423638563`*^9, 3.859303477143611*^9, 
   3.859303633110941*^9, 3.8593047531849403`*^9},
 CellLabel->
  "Out[587]=",ExpressionUUID->"55fa078c-1fe4-4377-879c-c413568d5c46"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.2424029546619335`", ",", 
   RowBox[{"{", 
    RowBox[{"eta", "\[Rule]", "0.0001270254190630219`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8591471829913883`*^9, {3.8591472613590603`*^9, 3.8591472750399733`*^9}, {
   3.859147721834292*^9, 3.8591478689051857`*^9}, 3.859150152413829*^9, 
   3.859150241528013*^9, {3.859150883874247*^9, 3.859150918888023*^9}, {
   3.8591509985599127`*^9, 3.859151002711279*^9}, 3.859151111833023*^9, {
   3.859151580534554*^9, 3.8591515940515137`*^9}, {3.859299314364765*^9, 
   3.859299338328168*^9}, 3.8592994836809473`*^9, 3.859299588459731*^9, 
   3.859299636576111*^9, {3.8592996747439117`*^9, 3.8592996918497763`*^9}, 
   3.859299786688396*^9, 3.85929984433379*^9, 3.859299899267267*^9, 
   3.8592999319000196`*^9, 3.859302376315982*^9, 3.85930254973429*^9, 
   3.85930268968602*^9, 3.859302775465211*^9, 3.8593028164415083`*^9, 
   3.859302938174296*^9, 3.8593032423638563`*^9, 3.859303477143611*^9, 
   3.859303633110941*^9, 3.859304754271188*^9},
 CellLabel->
  "Out[588]=",ExpressionUUID->"cb0f3776-712f-4784-9a3a-9f7ba846203a"],

Cell[BoxData[
 TemplateBox[{
  "Reduce", "ratnz", 
   "\"Reduce was unable to solve the system with inexact coefficients. The \
answer was obtained by solving a corresponding exact system and numericizing \
the result.\"", 2, 589, 38, 21870419949072214632, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.859303478135529*^9, 3.8593036340577393`*^9, 
  3.859304755192747*^9},
 CellLabel->
  "During evaluation of \
In[586]:=",ExpressionUUID->"3e2112cc-f073-4861-b373-73dccf075e79"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{
  3.8591471829913883`*^9, {3.8591472613590603`*^9, 3.8591472750399733`*^9}, {
   3.859147721834292*^9, 3.8591478689051857`*^9}, 3.859150152413829*^9, 
   3.859150241528013*^9, {3.859150883874247*^9, 3.859150918888023*^9}, {
   3.8591509985599127`*^9, 3.859151002711279*^9}, 3.859151111833023*^9, {
   3.859151580534554*^9, 3.8591515940515137`*^9}, {3.859299314364765*^9, 
   3.859299338328168*^9}, 3.8592994836809473`*^9, 3.859299588459731*^9, 
   3.859299636576111*^9, {3.8592996747439117`*^9, 3.8592996918497763`*^9}, 
   3.859299786688396*^9, 3.85929984433379*^9, 3.859299899267267*^9, 
   3.8592999319000196`*^9, 3.859302376315982*^9, 3.85930254973429*^9, 
   3.85930268968602*^9, 3.859302775465211*^9, 3.8593028164415083`*^9, 
   3.859302938174296*^9, 3.8593032423638563`*^9, 3.859303477143611*^9, 
   3.859303633110941*^9, 3.85930475524998*^9},
 CellLabel->
  "Out[589]=",ExpressionUUID->"2dc184eb-a840-4f38-991a-f5fb6e80bbd4"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwV13k8VF8UAHD7boyZsY+1TYVSJPpxr6IQspVUUiS7FKWsJaVCRXYpKUuo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       "]]},
     Annotation[#, "Charting`Private`Tag$2554893#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0.},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{
     Charting`ScaledTicks[
     "Log", {Log, Exp}, "Nice", WorkingPrecision -> MachinePrecision, 
      RotateLabel -> 0], 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{{-9, 4}, {0., 10.860904088906677`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{Automatic, 
     Charting`ScaledTicks[
     "Log", {Log, Exp}, "Nice", WorkingPrecision -> MachinePrecision, 
      RotateLabel -> 0]}, {Automatic, {{0., 
       FormBox["1", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
       FormBox["10", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
       FormBox["100", TraditionalForm], {0.01, 0.}}, {6.907755278982137, 
       FormBox["1000", TraditionalForm], {0.01, 0.}}, {9.210340371976184, 
       FormBox[
        TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm], {0.01, 0.}}, {-4.605170185988091, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.912023005428146, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.506557897319982, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.2188758248682006`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.995732273553991, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.8134107167600364`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.659260036932778, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.5257286443082556`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.4079456086518722`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.3025850929940455`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-1.6094379124341003`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-1.2039728043259361`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.916290731874155, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.6931471805599453, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.5108256237659907, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.35667494393873245`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.2231435513142097, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.10536051565782628`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.6931471805599453, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.0986122886681098`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.3862943611198906`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.6094379124341003`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.791759469228055, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.9459101490553132`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.0794415416798357`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.1972245773362196`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.995732273553991, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.4011973816621555`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.6888794541139363`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.912023005428146, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.0943445622221, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.248495242049359, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.382026634673881, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.499809670330265, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      5.298317366548036, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      5.703782474656201, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      5.991464547107982, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.214608098422191, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.396929655216146, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.551080335043404, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.684611727667927, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.802394763324311, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      7.600902459542082, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.006367567650246, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.294049640102028, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.517193191416238, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.699514748210191, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.85366542803745, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.987196820661973, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      9.104979856318357, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      9.903487552536127, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      10.308952660644293`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      10.596634733096073`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      10.819778284410283`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      11.002099841204238`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      11.156250521031495`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      11.289781913656018`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      11.407564949312402`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      11.512925464970229`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      12.206072645530174`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      12.611537753638338`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      12.89921982609012, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      13.122363377404328`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      13.304684934198283`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      13.458835614025542`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      13.592367006650065`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      13.710150042306449`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      13.815510557964274`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}],
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.8591471829913883`*^9, {3.8591472613590603`*^9, 3.8591472750399733`*^9}, {
   3.859147721834292*^9, 3.8591478689051857`*^9}, 3.859150152413829*^9, 
   3.859150241528013*^9, {3.859150883874247*^9, 3.859150918888023*^9}, {
   3.8591509985599127`*^9, 3.859151002711279*^9}, 3.859151111833023*^9, {
   3.859151580534554*^9, 3.8591515940515137`*^9}, {3.859299314364765*^9, 
   3.859299338328168*^9}, 3.8592994836809473`*^9, 3.859299588459731*^9, 
   3.859299636576111*^9, {3.8592996747439117`*^9, 3.8592996918497763`*^9}, 
   3.859299786688396*^9, 3.85929984433379*^9, 3.859299899267267*^9, 
   3.8592999319000196`*^9, 3.859302376315982*^9, 3.85930254973429*^9, 
   3.85930268968602*^9, 3.859302775465211*^9, 3.8593028164415083`*^9, 
   3.859302938174296*^9, 3.8593032423638563`*^9, 3.859303477143611*^9, 
   3.859303633110941*^9, 3.8593047558055573`*^9},
 CellLabel->
  "Out[590]=",ExpressionUUID->"0912f0f4-a7b9-4b18-bafe-e859992d16da"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{
      RowBox[{"Phi", ".", "wstar"}], "-", "V"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"epsilon", "->", "0.0001"}], ",", " ", 
      RowBox[{"p", "->", "0.02"}], ",", " ", 
      RowBox[{"q", "->", "0.2"}], ",", 
      RowBox[{"z", "->", ".2"}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Det", "[", "sA", "]"}], "==", "0"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"p", "->", "0.02"}], ",", 
     RowBox[{"q", "->", "0.2"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"tmp", ",", 
     RowBox[{"eta", ">", "0"}]}], "}"}], ",", "eta"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"tmp", "<", "1"}], "&&", 
   RowBox[{"eta", ">", "0"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"plot3", "=", 
  RowBox[{"LogPlot", "[", 
   RowBox[{
    RowBox[{"tmp", "/.", 
     RowBox[{"{", 
      RowBox[{"eta", "->", 
       RowBox[{"10", "^", "etax"}]}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"etax", ",", " ", 
      RowBox[{"-", "9"}], ",", " ", "4"}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.859147429240883*^9, 3.859147472129551*^9}, {
   3.859147600950156*^9, 3.859147684465543*^9}, 3.8591501345181227`*^9, {
   3.859150195439138*^9, 3.859150227855425*^9}, {3.859150927868464*^9, 
   3.8591509293384*^9}, {3.859151477024729*^9, 3.8591515030039997`*^9}, {
   3.859151545306662*^9, 3.8591515512852993`*^9}, {3.859299332754334*^9, 
   3.859299334096567*^9}, {3.859299639124544*^9, 3.8592996394963837`*^9}, 
   3.859302370675959*^9, {3.859302841640485*^9, 3.859302898710053*^9}, {
   3.859303049008078*^9, 3.859303050375264*^9}, {3.8593034922989492`*^9, 
   3.859303492460157*^9}, 3.859303638250362*^9, {3.859304823929578*^9, 
   3.859304828739933*^9}},
 CellLabel->
  "In[591]:=",ExpressionUUID->"314a3021-0cca-45e0-95ca-25cd662f6096"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"eta", "\[Rule]", 
     RowBox[{"-", "0.10981878986214047`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"eta", "\[Rule]", 
     RowBox[{"-", "0.00002105972236747228`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"eta", "\[Rule]", 
     RowBox[{"-", "1.2557965358743146`*^-8"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.859147437703816*^9, 3.8591474729476633`*^9}, {
   3.859147601917449*^9, 3.85914768551467*^9}, {3.8591501295554447`*^9, 
   3.859150135861162*^9}, {3.859150196513159*^9, 3.859150228837398*^9}, 
   3.859150889990491*^9, 3.859150930753057*^9, {3.859151477934844*^9, 
   3.8591515038018703`*^9}, 3.859151552391745*^9, {3.859299316347858*^9, 
   3.859299340297399*^9}, 3.859299590622735*^9, 3.859299640149394*^9, 
   3.859299790462846*^9, 3.859299850915145*^9, {3.859299904221973*^9, 
   3.8592999277202177`*^9}, 3.8593023812949867`*^9, 3.859302556305561*^9, 
   3.8593026950740347`*^9, 3.8593027796825666`*^9, 3.859302820609811*^9, {
   3.859302853936452*^9, 3.8593029006595993`*^9}, 3.8593031527707853`*^9, 
   3.8593034945953617`*^9, 3.8593036406891108`*^9, 3.859304829118114*^9},
 CellLabel->
  "Out[592]=",ExpressionUUID->"88342054-a3e8-41b7-b8e8-07d73248e159"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.1741515768065556`", ",", 
   RowBox[{"{", 
    RowBox[{"eta", "\[Rule]", "5.254170570507173`*^-8"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.859147437703816*^9, 3.8591474729476633`*^9}, {
   3.859147601917449*^9, 3.85914768551467*^9}, {3.8591501295554447`*^9, 
   3.859150135861162*^9}, {3.859150196513159*^9, 3.859150228837398*^9}, 
   3.859150889990491*^9, 3.859150930753057*^9, {3.859151477934844*^9, 
   3.8591515038018703`*^9}, 3.859151552391745*^9, {3.859299316347858*^9, 
   3.859299340297399*^9}, 3.859299590622735*^9, 3.859299640149394*^9, 
   3.859299790462846*^9, 3.859299850915145*^9, {3.859299904221973*^9, 
   3.8592999277202177`*^9}, 3.8593023812949867`*^9, 3.859302556305561*^9, 
   3.8593026950740347`*^9, 3.8593027796825666`*^9, 3.859302820609811*^9, {
   3.859302853936452*^9, 3.8593029006595993`*^9}, 3.8593031527707853`*^9, 
   3.8593034945953617`*^9, 3.8593036406891108`*^9, 3.8593048307957563`*^9},
 CellLabel->
  "Out[593]=",ExpressionUUID->"69f90684-1993-4d83-b6ac-4f5f30a33d77"],

Cell[BoxData[
 TemplateBox[{
  "Reduce", "ratnz", 
   "\"Reduce was unable to solve the system with inexact coefficients. The \
answer was obtained by solving a corresponding exact system and numericizing \
the result.\"", 2, 594, 39, 21870419949072214632, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.859303495613489*^9, 3.8593036416537*^9, 
  3.8593048317364902`*^9},
 CellLabel->
  "During evaluation of \
In[591]:=",ExpressionUUID->"5234b32d-6338-4473-a43e-dbe61c6c9f47"],

Cell[BoxData[
 RowBox[{"3.020664235239639`*^-8", "<", "eta", "<", 
  "1.2363347862355214`*^-7"}]], "Output",
 CellChangeTimes->{{3.859147437703816*^9, 3.8591474729476633`*^9}, {
   3.859147601917449*^9, 3.85914768551467*^9}, {3.8591501295554447`*^9, 
   3.859150135861162*^9}, {3.859150196513159*^9, 3.859150228837398*^9}, 
   3.859150889990491*^9, 3.859150930753057*^9, {3.859151477934844*^9, 
   3.8591515038018703`*^9}, 3.859151552391745*^9, {3.859299316347858*^9, 
   3.859299340297399*^9}, 3.859299590622735*^9, 3.859299640149394*^9, 
   3.859299790462846*^9, 3.859299850915145*^9, {3.859299904221973*^9, 
   3.8592999277202177`*^9}, 3.8593023812949867`*^9, 3.859302556305561*^9, 
   3.8593026950740347`*^9, 3.8593027796825666`*^9, 3.859302820609811*^9, {
   3.859302853936452*^9, 3.8593029006595993`*^9}, 3.8593031527707853`*^9, 
   3.8593034945953617`*^9, 3.8593036406891108`*^9, 3.859304831792005*^9},
 CellLabel->
  "Out[594]=",ExpressionUUID->"7d58d58b-9ff0-457e-bd61-dae8a2c869c6"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAADeUsCByQH8AWGnMZ6EvxPynCTWxJ
jR/A1zxhP/g28T/UpMc/5IgfwNiokdAtFfE/fodBE3+EH8BCPORpHfPwP9JM
Nbq0ex/AqUoM0Ceu8D961xwIIGofwG9xylPUIPA/zOzro/ZGH8C+gOqIq+/t
P3bPZXeRQh/AKbtcD5mi7T8gst9KLD4fwAduO5vfVO0/dHfT8WE1H8D3vfqc
b7fsPx0Cuz/NIx/AuDVkfV906z9uF4rbowAfwGGUYWlyy+g/EUIoE1G6HsAo
K77qa9riP6YyV/02th7AYtKap0J64j88I4bnHLIewL990dYxGeI/ZgTku+ip
HsBWJQLuSVThP7zGn2SAmR7Ad53KBNp93z9oSxe2r3gewNhxcMTaw9g//jtG
oJV0HsD2sdAAYuLXP8tdF+MBdB7AGm8v11HC1z+2c5+r
       "]], 
      LineBox[CompressedData["
1:eJwV13k0Vd8XAHDP8EzPXKZGChXKlPHLvklFUcgYkQypSAmFDEkJpfIzVBqo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       "]]},
     Annotation[#, "Charting`Private`Tag$2615580#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0.3712353326243246},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{
     Charting`ScaledTicks[
     "Log", {Log, Exp}, "Nice", WorkingPrecision -> MachinePrecision, 
      RotateLabel -> 0], 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{{-9, 4}, {0.3712353326243246, 1.0810318941236168`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{Automatic, 
     Charting`ScaledTicks[
     "Log", {Log, Exp}, "Nice", WorkingPrecision -> MachinePrecision, 
      RotateLabel -> 0]}, {Automatic, {{0.4054651081081644, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"1.5\"", ShowStringCharacters -> False], 1.5, AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {
      0.6931471805599453, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"2.0\"", ShowStringCharacters -> False], 2., AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {
      0.9162907318741551, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"2.5\"", ShowStringCharacters -> False], 2.5, AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {
      1.0986122886681098`, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"3.0\"", ShowStringCharacters -> False], 3., AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {0., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.09531017980432493, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.1823215567939546, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.26236426446749106`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.3364722366212129, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.47000362924573563`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.5306282510621704, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.5877866649021191, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.6418538861723947, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.7419373447293773, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.7884573603642703, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.8329091229351039, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.8754687373538999, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.9555114450274363, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.9932517730102834, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.0296194171811581`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.0647107369924282`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.1314021114911006`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.1631508098056809`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.1939224684724346`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.2237754316221157`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.252762968495368, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}],
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.859147437703816*^9, 3.8591474729476633`*^9}, {
   3.859147601917449*^9, 3.85914768551467*^9}, {3.8591501295554447`*^9, 
   3.859150135861162*^9}, {3.859150196513159*^9, 3.859150228837398*^9}, 
   3.859150889990491*^9, 3.859150930753057*^9, {3.859151477934844*^9, 
   3.8591515038018703`*^9}, 3.859151552391745*^9, {3.859299316347858*^9, 
   3.859299340297399*^9}, 3.859299590622735*^9, 3.859299640149394*^9, 
   3.859299790462846*^9, 3.859299850915145*^9, {3.859299904221973*^9, 
   3.8592999277202177`*^9}, 3.8593023812949867`*^9, 3.859302556305561*^9, 
   3.8593026950740347`*^9, 3.8593027796825666`*^9, 3.859302820609811*^9, {
   3.859302853936452*^9, 3.8593029006595993`*^9}, 3.8593031527707853`*^9, 
   3.8593034945953617`*^9, 3.8593036406891108`*^9, 3.859304832240947*^9},
 CellLabel->
  "Out[595]=",ExpressionUUID->"7d843d58-0331-4f7d-9c6a-74a1f9fc8590"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"plot1", ",", " ", "plot2", ",", "plot3"}], "]"}]], "Input",
 CellChangeTimes->{{3.859299352568272*^9, 3.859299358075045*^9}},
 CellLabel->
  "In[488]:=",ExpressionUUID->"1ed30f10-d73d-4099-8473-5bd33b364b1a"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], 
       CapForm["Butt"], LineBox[CompressedData["
1:eJwV1Hk0lVsbAHCUpNxKA2c+70u5FMpUmjwlpDRxG4iIkrGkAZdQhlSiQmaS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        "]], LineBox[CompressedData["
1:eJwV13k0Vd8XAHAeHp75kfiSQpqLyqzsmyQyD6EUEimRMSpjUkJUiqhfoTIk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        "]]},
      Annotation[#, "Charting`Private`Tag$2190120#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], 
       CapForm["Butt"], LineBox[CompressedData["
1:eJwV13k8VF8UAHD7boyZsY+1TYVSJPpxr6IQspVUUiS7FKWsJaVCRXYpKUuo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        "]]},
      Annotation[#, "Charting`Private`Tag$2228467#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], 
       CapForm["Butt"], LineBox[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAADeUsCByQH8AWGnMZ6EvxPynCTWxJ
jR/A1zxhP/g28T/UpMc/5IgfwNiokdAtFfE/fodBE3+EH8BCPORpHfPwP9JM
Nbq0ex/AqUoM0Ceu8D961xwIIGofwG9xylPUIPA/zOzro/ZGH8C+gOqIq+/t
P3bPZXeRQh/AKbtcD5mi7T8gst9KLD4fwAduO5vfVO0/dHfT8WE1H8D3vfqc
b7fsPx0Cuz/NIx/AuDVkfV906z9uF4rbowAfwGGUYWlyy+g/EUIoE1G6HsAo
K77qa9riP6YyV/02th7AYtKap0J64j88I4bnHLIewL990dYxGeI/ZgTku+ip
HsBWJQLuSVThP7zGn2SAmR7Ad53KBNp93z9oSxe2r3gewNhxcMTaw9g//jtG
oJV0HsD2sdAAYuLXP8tdF+MBdB7AGm8v11HC1z+2c5+r
        "]], 
       LineBox[CompressedData["
1:eJwV13k0Vd8XAHDP8EzPXKZGChXKlPHLvklFUcgYkQypSAmFDEkJpfIzVBqo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        "]]},
      Annotation[#, "Charting`Private`Tag$2289149#1"]& ]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0.2548649280144698},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{
     Charting`ScaledTicks[
     "Log", {Log, Exp}, "Nice", WorkingPrecision -> MachinePrecision, 
      RotateLabel -> 0], 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{{-9, 4}, {0.2548649280144698, 1.1835946324912083`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{Automatic, 
     Charting`ScaledTicks[
     "Log", {Log, Exp}, "Nice", WorkingPrecision -> MachinePrecision, 
      RotateLabel -> 0]}, {Automatic, {{0.4054651081081644, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"1.5\"", ShowStringCharacters -> False], 1.5, AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {
      0.6931471805599453, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"2.0\"", ShowStringCharacters -> False], 2., AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {
      0.9162907318741551, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"2.5\"", ShowStringCharacters -> False], 2.5, AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {
      1.0986122886681098`, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"3.0\"", ShowStringCharacters -> False], 3., AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {0., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.09531017980432493, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.1823215567939546, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.26236426446749106`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.3364722366212129, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.47000362924573563`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.5306282510621704, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.5877866649021191, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.6418538861723947, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.7419373447293773, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.7884573603642703, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.8329091229351039, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.8754687373538999, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.9555114450274363, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.9932517730102834, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.0296194171811581`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.0647107369924282`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.1314021114911006`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.1631508098056809`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.1939224684724346`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.2237754316221157`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.252762968495368, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}],
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{3.8592993587178297`*^9, 3.859299592753327*^9, 
  3.859299803743803*^9, 3.8593025656905813`*^9, 3.8593027156449957`*^9, 
  3.85930278351999*^9, 3.85930315663378*^9, 3.859303407268199*^9, 
  3.859303523850588*^9},
 CellLabel->
  "Out[488]=",ExpressionUUID->"a8a435d7-d9c9-478b-b3fc-27b404c68399"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"savep", "=", "0.02"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"saveq", "=", "0.2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp", " ", "=", 
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{
      RowBox[{"Phi", ".", "wstar"}], "-", "V"}], "]"}], " ", "/.", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"epsilon", "->", "0.0001"}], ",", 
      RowBox[{"p", "->", "savep"}], ",", 
      RowBox[{"q", "->", "saveq"}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tbl", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"tmp", " ", "/.", " ", 
      RowBox[{"{", 
       RowBox[{"eta", "->", 
        RowBox[{"10", "^", 
         RowBox[{"(", 
          RowBox[{"etarun", "/", "40"}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"etarun", ",", 
       RowBox[{
        RowBox[{"-", "9"}], " ", "*", "40"}], ",", 
       RowBox[{"2", "*", "40"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<data_eta_p\>\"", ",", 
     RowBox[{"ToString", "[", 
      RowBox[{"InputForm", "[", "savep", "]"}], "]"}], ",", "\"\<_q\>\"", ",", 
     RowBox[{"ToString", "[", 
      RowBox[{"InputForm", "[", "saveq", "]"}], "]"}], ",", "\"\<.dat\>\""}], 
    "]"}], ",", "tbl"}], "]"}]}], "Input",
 CellChangeTimes->{{3.8591478963915453`*^9, 3.859147900806654*^9}, {
  3.85914809654113*^9, 3.859148161033266*^9}, {3.8591519082582407`*^9, 
  3.859151943029388*^9}, {3.859303769063648*^9, 3.8593038344679823`*^9}},
 CellLabel->
  "In[546]:=",ExpressionUUID->"d09a18d7-9b7f-4f68-b9c5-bc2959304535"],

Cell[BoxData["\<\"data_eta_p0.02_q0.2.dat\"\>"], "Output",
 CellChangeTimes->{{3.8591481325202436`*^9, 3.8591481620017033`*^9}, {
  3.859151916642953*^9, 3.859151943984337*^9}, {3.859303772956738*^9, 
  3.8593038356354856`*^9}},
 CellLabel->
  "Out[550]=",ExpressionUUID->"e4ed69a1-646b-4099-990b-b75b763b52f3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["On-Policy Error", "Subsubsection",
 CellChangeTimes->{{3.859304194568185*^9, 
  3.859304197300437*^9}},ExpressionUUID->"7af9fa1a-63ca-48b4-baab-\
9d3b703a4b7c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sAo", " ", "=", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"Phi", "\[Transpose]"}], ".", 
      RowBox[{"DiagonalMatrix", "[", "pi", "]"}], ".", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"IdentityMatrix", "[", "5", "]"}], " ", "-", " ", 
        RowBox[{"gamma", "*", "P"}]}], ")"}], ".", "Phi"}], " ", "+", " ", 
     RowBox[{"eta", "*", 
      RowBox[{"IdentityMatrix", "[", "3", "]"}]}]}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sbo", " ", "=", " ", 
   RowBox[{
    RowBox[{"Phi", "\[Transpose]"}], ".", 
    RowBox[{"DiagonalMatrix", "[", "pi", "]"}], ".", "R"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"whato", "=", 
   RowBox[{
    RowBox[{"Inverse", "[", "sAo", "]"}], ".", "sbo"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{
      RowBox[{"Phi", ".", "whato"}], "-", "V"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"eta", "->", 
      RowBox[{"10", "^", "etax"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"etax", ",", 
     RowBox[{"-", "9"}], ",", "1"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Norm", "[", 
    RowBox[{
     RowBox[{"Phi", ".", "whato"}], "-", "V"}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{"eta", "->", "0"}], "}"}]}], " ", "//", 
  "TraditionalForm"}]}], "Input",
 CellChangeTimes->{{3.85930420059586*^9, 3.859304225879834*^9}, {
  3.8593042640312634`*^9, 3.859304350035604*^9}},
 CellLabel->
  "In[571]:=",ExpressionUUID->"549cb410-7778-46d0-aea9-d723707958f8"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwV1Xc8Vf8fB/B7ray4tqx7b6Ehq2TzOVlJkRJJlAgZUfiiSBKKKBVZoSTX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       "]]},
     Annotation[#, "Charting`Private`Tag$2434204#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-9, 1}, {0., 2.2586216400450883`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.859304270750745*^9, 3.859304275988585*^9}, {
  3.8593043104887*^9, 3.859304350969974*^9}},
 CellLabel->
  "Out[574]=",ExpressionUUID->"0375836f-b82a-45a2-ac85-c06a26824b98"],

Cell[BoxData[
 FormBox["0.04495921580917043`", TraditionalForm]], "Output",
 CellChangeTimes->{{3.859304270750745*^9, 3.859304275988585*^9}, {
  3.8593043104887*^9, 3.8593043509959373`*^9}},
 CellLabel->
  "Out[575]//TraditionalForm=",ExpressionUUID->"7b02f509-a184-4d2f-aaf8-\
ee250d8ed6d5"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1134.8256880733945`, 909.5779816513761},
WindowMargins->{{Automatic, 0.6605504587159885}, {
  18.32727272727277, Automatic}},
TaggingRules-><|"TryRealOnly" -> False|>,
CellContext->Notebook,
Magnification:>0.95,
FrontEndVersion->"13.0 for Linux x86 (64-bit) (February 4, 2022)",
StyleDefinitions->FrontEnd`FileName[{"Article"}, "JournalArticle.nb", 
  CharacterEncoding -> "UTF-8"],
ExpressionUUID->"23ed9b7e-8a37-48ab-8c44-9de7928e5403"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 485, 9, 40, "Text",ExpressionUUID->"051258ff-3da9-473b-961b-d8991c9fcfd8"],
Cell[CellGroupData[{
Cell[1068, 33, 8267, 210, 305, "Input",ExpressionUUID->"9200f06e-2e4b-41fc-9cec-a5e44c74ced5"],
Cell[9338, 245, 1065, 20, 39, "Output",ExpressionUUID->"2c3fab80-585a-4a43-8aa7-9871f424325e"],
Cell[10406, 267, 1671, 40, 43, "Output",ExpressionUUID->"bf5381eb-2c7f-4059-b76c-12da0e22c55c"],
Cell[12080, 309, 849, 13, 28, "Output",ExpressionUUID->"aaebee4f-6317-47f6-98cb-291f13bf2c60"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12966, 327, 475, 10, 28, "Input",ExpressionUUID->"c937557e-f8b8-40f3-884b-a5fcfe331f43"],
Cell[13444, 339, 1492, 22, 28, "Output",ExpressionUUID->"749c11b0-a8ef-47b3-8b17-c1d9b95fb574"]
}, Open  ]],
Cell[14951, 364, 326, 5, 22, "Text",ExpressionUUID->"812d4f2f-d057-4141-99e9-0041d5ad4212"],
Cell[CellGroupData[{
Cell[15302, 373, 797, 17, 51, "Input",ExpressionUUID->"faa6cd96-61f9-4282-9bec-90ba810909ff"],
Cell[16102, 392, 838, 13, 28, "Output",ExpressionUUID->"0bf5fd59-bd95-4ad9-8db1-a6ddf83d1a05"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16977, 410, 281, 5, 22, "Text",ExpressionUUID->"0a5d41cb-08ef-4253-a74f-02384f62cb6a",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[17261, 417, 1252, 31, 67, "Input",ExpressionUUID->"dac544c6-b255-4844-84bf-e0609e814e56",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[18550, 453, 1277, 29, 49, "Input",ExpressionUUID->"5c741a9b-2f35-4603-8157-51a0429cf235"],
Cell[19830, 484, 186670, 3065, 670, "Output",ExpressionUUID->"0268fbee-bb68-439a-a81e-c4a2e8446d9a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[206537, 3554, 839, 24, 49, "Input",ExpressionUUID->"891cc3a8-96a2-4bdd-8f47-d24ac8335532"],
Cell[207379, 3580, 139081, 2303, 171, "Output",ExpressionUUID->"e9039af5-35c2-4098-9f8f-f56ea5caa5eb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[346497, 5888, 2229, 45, 67, "Input",ExpressionUUID->"bcd75a85-a5a4-42fd-9cb7-137e413fd55f"],
Cell[348729, 5935, 820, 16, 26, "Message",ExpressionUUID->"3675d037-f4ab-480b-8215-2e7116f3620b"],
Cell[349552, 5953, 1544, 30, 31, "Output",ExpressionUUID->"7c5759f7-f382-4144-80a7-480692507c9f"],
Cell[351099, 5985, 7785, 151, 224, "Output",ExpressionUUID->"888391cd-7947-4c04-9ca7-6037dc5691c0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[358921, 6141, 237, 4, 48, "Section",ExpressionUUID->"cdaed246-7d2d-4bd4-ab55-763c594c4588"],
Cell[359161, 6147, 259, 4, 22, "Text",ExpressionUUID->"102b5072-7854-4375-ac95-da85f8f850ba"],
Cell[CellGroupData[{
Cell[359445, 6155, 2834, 71, 122, "Input",ExpressionUUID->"8f40f9fd-67f1-4f8c-9b38-eed28c34c35d"],
Cell[362282, 6228, 1528, 29, 31, "Output",ExpressionUUID->"bd07bc3b-06d8-4223-b57d-358729d6098d"],
Cell[363813, 6259, 1319, 23, 31, "Output",ExpressionUUID->"caab9a6f-af7d-458c-92ae-7545b6feba72"],
Cell[365135, 6284, 553, 11, 26, "Message",ExpressionUUID->"b741b896-f45a-4728-846f-c59d46016863"],
Cell[365691, 6297, 1255, 20, 28, "Output",ExpressionUUID->"a96d0eff-42da-4b9f-a8c1-9620b58c25bc"],
Cell[366949, 6319, 19399, 375, 229, "Output",ExpressionUUID->"e2a6d51d-a698-4ff3-bf04-ce95da0d2b21"]
}, Open  ]],
Cell[CellGroupData[{
Cell[386385, 6699, 2106, 53, 103, "Input",ExpressionUUID->"f57be62e-c545-44e2-bdd0-66cf7c8ca389"],
Cell[388494, 6754, 1297, 25, 31, "Output",ExpressionUUID->"55fa078c-1fe4-4377-879c-c413568d5c46"],
Cell[389794, 6781, 1127, 20, 28, "Output",ExpressionUUID->"cb0f3776-712f-4784-9a3a-9f7ba846203a"],
Cell[390924, 6803, 504, 11, 26, "Message",ExpressionUUID->"3e2112cc-f073-4861-b373-73dccf075e79"],
Cell[391431, 6816, 986, 15, 28, "Output",ExpressionUUID->"2dc184eb-a840-4f38-991a-f5fb6e80bbd4"],
Cell[392420, 6833, 30111, 590, 229, "Output",ExpressionUUID->"0912f0f4-a7b9-4b18-bafe-e859992d16da"]
}, Open  ]],
Cell[CellGroupData[{
Cell[422568, 7428, 2041, 52, 103, "Input",ExpressionUUID->"314a3021-0cca-45e0-95ca-25cd662f6096"],
Cell[424612, 7482, 1264, 24, 31, "Output",ExpressionUUID->"88342054-a3e8-41b7-b8e8-07d73248e159"],
Cell[425879, 7508, 1058, 18, 31, "Output",ExpressionUUID->"69f90684-1993-4d83-b6ac-4f5f30a33d77"],
Cell[426940, 7528, 502, 11, 26, "Message",ExpressionUUID->"5234b32d-6338-4473-a43e-dbe61c6c9f47"],
Cell[427445, 7541, 992, 15, 28, "Output",ExpressionUUID->"7d58d58b-9ff0-457e-bd61-dae8a2c869c6"],
Cell[428440, 7558, 17297, 340, 229, "Output",ExpressionUUID->"7d843d58-0331-4f7d-9c6a-74a1f9fc8590"]
}, Open  ]],
Cell[CellGroupData[{
Cell[445774, 7903, 256, 5, 28, "Input",ExpressionUUID->"1ed30f10-d73d-4099-8473-5bd33b364b1a"],
Cell[446033, 7910, 48305, 855, 229, "Output",ExpressionUUID->"a8a435d7-d9c9-478b-b3fc-27b404c68399"]
}, Open  ]],
Cell[CellGroupData[{
Cell[494375, 8770, 1678, 45, 105, "Input",ExpressionUUID->"d09a18d7-9b7f-4f68-b9c5-bc2959304535"],
Cell[496056, 8817, 311, 5, 28, "Output",ExpressionUUID->"e4ed69a1-646b-4099-990b-b75b763b52f3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[496404, 8827, 166, 3, 25, "Subsubsection",ExpressionUUID->"7af9fa1a-63ca-48b4-baab-9d3b703a4b7c"],
Cell[CellGroupData[{
Cell[496595, 8834, 1631, 49, 108, "Input",ExpressionUUID->"549cb410-7778-46d0-aea9-d723707958f8"],
Cell[498229, 8885, 11980, 221, 229, "Output",ExpressionUUID->"0375836f-b82a-45a2-ac85-c06a26824b98"],
Cell[510212, 9108, 292, 6, 39, "Output",ExpressionUUID->"7b02f509-a184-4d2f-aaf8-ee250d8ed6d5"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

