TAG="NeurIPS"
N="range(3)"

EXPTS="river wod-medium wod-hard"
TIME="700"

# EXPTS="multiroom-n2 multiroom-n4"
# TIME="1600"

# EXPTS="quest-easy quest-medium"
# TIME="1000"

for EXPT in $EXPTS; do
    # Baseline
    OMP_NUM_THREADS=1 python -m langexplore.train -m +experiment=$EXPT group="$TAG-$EXPT-baseline" generator=false language_goals=online_naive n="$N" batch_size=32 lr=0.001

    # Naive message reward baseline
    OMP_NUM_THREADS=1 python -m langexplore.train -m +experiment=$EXPT group="$TAG-$EXPT-naive-reward" generator=false language_goals=online_naive n="$N" batch_size=32 lr=0.001 naive_message_reward=0.1

    # AMIGo (null), L-AMIGo (online_grounding), L-AMIGo (no grounding) (online_naive)
    OMP_NUM_THREADS=1 python -m langexplore.train -m +experiment=$EXPT group="$TAG-$EXPT-\${language_goals}" generator=true language_goals=online_grounding,online_naive,null n="$N" batch_size=32 novelty=true novelty_reward=0.0001 generator_maximum=1 generator_threshold=-0.3 generator_batch_size=150 generator_eps=0.1 intrinsic_reward_coef=1.0 lr=0.001 force_new_goals=true max_online_goals=100

    # L-AMIGo, onehot
    OMP_NUM_THREADS=1 python -m langexplore.train -m +experiment=$EXPT group="$TAG-$EXPT-\${language_goals}-onehot" generator=true language_goals=online_grounding n="$N" batch_size=32 novelty=true novelty_reward=0.0001 generator_maximum=1 generator_threshold=-0.3 generator_batch_size=150 generator_eps=0.1 intrinsic_reward_coef=1.0 lr=0.001 force_new_goals=true max_online_goals=100 onehot_language_goals=true
done
