function [auc,fpr,tpr,p_fpr,p_tpr] = partial_AUC(labels,scores,plot_flag,k1,k2,alpha,beta)

% This function calculates m AUC values for m ranked lists.
% n is the number of ranked items. 
% m is the number of different rankings.
%
% Input:  labels is nXm binary logical.
%         scores is nXm real. For a high AUC the higher scores should have
%         labels==1.
%         plot_flag: binary flag, if TRUE then m ROC curves will be plotted
%         (default FALSE).
%
% Output: auc is mX1 real, the Area Under the ROC curves.
%         fpr is nXm real, the false positive rates.
%         tpr is nXm real, the true positive rates.

if ~exist('plot_flag','var')
    plot_flag = 0;
end
if ~islogical(labels)
    error('labels input should be logical');
end
if ~isequal(size(labels),size(scores))
    error('labels and scores should have the same size');
end
[n,m] = size(labels);
num_pos = sum(labels);
if any(num_pos==0)
    error('no positive labels entered');
end
if any(num_pos==n)
    error('no negative labels entered');
end

[sort_scores,scores_si] = sort(scores,'descend');
%clear scores
scores_si_reindex = scores_si;
l = labels(scores_si_reindex);
%clear scores_si labels 

tp = cumsum(l==1,1);
fp = (1:n)'-tp;

num_neg = n-num_pos;
fpr = bsxfun(@rdivide,fp,num_neg); %False Positive Rate
tpr = bsxfun(@rdivide,tp,num_pos); %True Positive Rate

% choose partial tpr and fpr
idx = find(fp > k1 & fp <= k2);
p_fpr = fpr(idx);
p_tpr = tpr(idx);
p_fp = fp(idx);
p_tp = tp(idx);
n_ptpr = length(p_tpr);

auc = sum(p_tpr.*[(diff(p_fp)==1); zeros(1,m)])./num_neg;
