import numpy as np

import util

_BOUNDS10 = {
    "mlp": {
        "mnist": {
            "ail_all_or_and": {
                "beta1": -0.911,
                "beta2": -2.435,
                "eps": -10.393,
                "wd": -5.813,
                "max_lr": -2.98,
                "cycle_peak": 0.166,
            },
            "ail_all_or_and_xnor": {
                "beta1": -0.804,
                "beta2": -4.151,
                "eps": -8.91,
                "wd": -4.685,
                "max_lr": -2.417,
                "cycle_peak": 0.376,
            },
            "ail_all_or_xnor": {
                "beta1": -1.016,
                "beta2": -4.279,
                "eps": -9.249,
                "wd": -5.544,
                "max_lr": -1.874,
                "cycle_peak": 0.211,
            },
            "ail_or": {
                "beta1": -0.575,
                "beta2": -3.795,
                "eps": -9.623,
                "wd": -5.713,
                "max_lr": -1.9,
                "cycle_peak": 0.364,
            },
            "ail_part_or_and_xnor": {
                "beta1": -0.737,
                "beta2": -4.563,
                "eps": -10.485,
                "wd": -5.245,
                "max_lr": -2.789,
                "cycle_peak": 0.343,
            },
            "ail_part_or_xnor": {
                "beta1": -1.063,
                "beta2": -4.108,
                "eps": -10.195,
                "wd": -5.601,
                "max_lr": -2.866,
                "cycle_peak": 0.273,
            },
            "ail_xnor": {
                "beta1": -0.893,
                "beta2": -4.209,
                "eps": -7.833,
                "wd": -4.931,
                "max_lr": -2.288,
                "cycle_peak": 0.23,
            },
            "bin_all_max_min": {
                "beta1": -1.104,
                "beta2": -4.255,
                "eps": -9.68,
                "wd": -5.684,
                "max_lr": -2.833,
                "cycle_peak": 0.334,
            },
            "max": {
                "beta1": -0.543,
                "beta2": -1.334,
                "eps": -7.684,
                "wd": -4.662,
                "max_lr": -2.636,
                "cycle_peak": 0.171,
            },
            "relu": {
                "beta1": -0.682,
                "beta2": -3.323,
                "eps": -9.239,
                "wd": -6.32,
                "max_lr": -2.23,
                "cycle_peak": 0.4,
            },
        },
        "cifar100": {
            "max": {
                "beta1": -0.669,
                "beta2": -3.694,
                "eps": -10.372,
                "wd": -5.438,
                "max_lr": -2.328,
                "cycle_peak": 0.396,
            },
            "relu": {
                "beta1": -0.639,
                "beta2": -4.195,
                "eps": -7.136,
                "wd": -5.991,
                "max_lr": -2.023,
                "cycle_peak": 0.35,
            },
        },
    },
    "cnn": {
        "cifar10": {
            "ail_all_or_and": {
                "beta1": -0.903,
                "beta2": -2.209,
                "eps": -7.501,
                "wd": -3.606,
                "max_lr": -2.962,
                "cycle_peak": 0.284,
            },
            "ail_all_or_and_xnor": {
                "beta1": -0.856,
                "beta2": -2.105,
                "eps": -8.238,
                "wd": -5.246,
                "max_lr": -2.916,
                "cycle_peak": 0.393,
            },
            "ail_all_or_xnor": {
                "beta1": -0.974,
                "beta2": -2.692,
                "eps": -6.482,
                "wd": -2.857,
                "max_lr": -2.87,
                "cycle_peak": 0.311,
            },
            "ail_or": {
                "beta1": -1.005,
                "beta2": -1.928,
                "eps": -7.536,
                "wd": -3.148,
                "max_lr": -2.779,
                "cycle_peak": 0.368,
            },
            "ail_part_or_and_xnor": {
                "beta1": -0.845,
                "beta2": -4.598,
                "eps": -4.735,
                "wd": -3.622,
                "max_lr": -2.595,
                "cycle_peak": 0.366,
            },
            "ail_part_or_xnor": {
                "beta1": -0.869,
                "beta2": -4.102,
                "eps": -8.633,
                "wd": -3.386,
                "max_lr": -2.646,
                "cycle_peak": 0.337,
            },
            "ail_xnor": {
                "beta1": -0.664,
                "beta2": -3.346,
                "eps": -7.574,
                "wd": -3.207,
                "max_lr": -2.491,
                "cycle_peak": 0.344,
            },
            "bin_all_max_min": {
                "beta1": -0.88,
                "beta2": -1.386,
                "eps": -7.55,
                "wd": -6.329,
                "max_lr": -2.838,
                "cycle_peak": 0.504,
            },
            "max": {
                "beta1": -0.868,
                "beta2": -2.224,
                "eps": -6.472,
                "wd": -3.629,
                "max_lr": -2.609,
                "cycle_peak": 0.294,
            },
            "relu": {
                "beta1": -0.755,
                "beta2": -2.929,
                "eps": -7.027,
                "wd": -3.585,
                "max_lr": -2.355,
                "cycle_peak": 0.303,
            },
        },
        "cifar100": {
            "max": {
                "beta1": -0.519,
                "beta2": -2.915,
                "eps": -7.804,
                "wd": -3.542,
                "max_lr": -2.589,
                "cycle_peak": 0.456,
            },
            "relu": {
                "beta1": -0.54,
                "beta2": -2.997,
                "eps": -6.384,
                "wd": -3.693,
                "max_lr": -2.932,
                "cycle_peak": 0.453,
            },
            "ail_all_or_and": {
                "beta1": -0.701,
                "beta2": -1.925,
                "eps": -6.823,
                "wd": -4.256,
                "max_lr": -3.051,
                "cycle_peak": 0.399,
            },
            "ail_all_or_and_xnor": {
                "beta1": -0.88,
                "beta2": -1.455,
                "eps": -6.57,
                "wd": -3.26,
                "max_lr": -2.997,
                "cycle_peak": 0.387,
            },
            "ail_all_or_xnor": {
                "beta1": -0.909,
                "beta2": -2.251,
                "eps": -8.966,
                "wd": -3.45,
                "max_lr": -2.865,
                "cycle_peak": 0.481,
            },
            "ail_or": {
                "beta1": -0.811,
                "beta2": -3.453,
                "eps": -10.211,
                "wd": -4.161,
                "max_lr": -2.704,
                "cycle_peak": 0.505,
            },
            "ail_part_or_and_xnor": {
                "beta1": -0.64,
                "beta2": -2.535,
                "eps": -7.47,
                "wd": -3.379,
                "max_lr": -2.694,
                "cycle_peak": 0.429,
            },
            "ail_part_or_xnor": {
                "beta1": -0.727,
                "beta2": -3.265,
                "eps": -6.161,
                "wd": -3.485,
                "max_lr": -2.629,
                "cycle_peak": 0.454,
            },
            "ail_xnor": {
                "beta1": -0.787,
                "beta2": -3.254,
                "eps": -7.192,
                "wd": -3.012,
                "max_lr": -2.639,
                "cycle_peak": 0.447,
            },
            "bin_all_max_min": {
                "beta1": -0.631,
                "beta2": -1.804,
                "eps": -8.554,
                "wd": -3.473,
                "max_lr": -2.883,
                "cycle_peak": 0.374,
            },
        },
    },
}

_BOUNDS50 = {
    "mlp": {
        "cifar100": {
            "max": {
                "beta1": -0.792,
                "beta2": -3.824,
                "eps": -5.974,
                "wd": -3.463,
                "max_lr": -2.808,
                "cycle_peak": 0.421,
            },
            "relu": {
                "beta1": -1.001,
                "beta2": -2.626,
                "eps": -8.718,
                "wd": -3.385,
                "max_lr": -3.203,
                "cycle_peak": 0.481,
            },
        }
    },
    "cnn": {
        "cifar100": {
            "max": {
                "beta1": -1.07,
                "beta2": -3.441,
                "eps": -5.845,
                "wd": -3.375,
                "max_lr": -2.637,
                "cycle_peak": 0.449,
            },
            "relu": {
                "beta1": -0.426,
                "beta2": -3.893,
                "eps": -8.535,
                "wd": -3.413,
                "max_lr": -2.736,
                "cycle_peak": 0.401,
            },
        }
    },
    "resnet": {
        "cifar10": {
            "max": {
                "beta1": -0.964,
                "beta2": -5.072,
                "eps": -6.962,
                "wd": -4.382,
                "max_lr": -2.694,
                "cycle_peak": 0.339,
            },
            "relu": {
                "beta1": -0.761,
                "beta2": -2.444,
                "eps": -6.324,
                "wd": -4.559,
                "max_lr": -3.338,
                "cycle_peak": 0.23,
            },
            "swish": {
                "beta1": -0.878,
                "beta2": -4.284,
                "eps": -9.783,
                "wd": -4.446,
                "max_lr": -2.898,
                "cycle_peak": 0.312,
            },
            "bin_all_max_min": {
                "beta1": -0.887,
                "beta2": -5.215,
                "eps": -6.307,
                "wd": -5.623,
                "max_lr": -2.972,
                "cycle_peak": 0.27,
            },
            "ail_or": {
                "beta1": -1.199,
                "beta2": -5.005,
                "eps": -7.926,
                "wd": -4.548,
                "max_lr": -2.752,
                "cycle_peak": 0.334,
            },
            "ail_xnor": {
                "beta1": -2.206,
                "beta2": -1.528,
                "eps": -6.216,
                "wd": -3.185,
                "max_lr": -2.95,
                "cycle_peak": 0.54,
            },
            "ail_all_or_and": {
                "beta1": -1.26,
                "beta2": -4.87,
                "eps": -8.916,
                "wd": -4.67,
                "max_lr": -2.933,
                "cycle_peak": 0.386,
            },
            "ail_all_or_xnor": {
                "beta1": -1.188,
                "beta2": -4.501,
                "eps": -6.091,
                "wd": -4.153,
                "max_lr": -2.833,
                "cycle_peak": 0.319,
            },
            "ail_all_or_and_xnor": {
                "beta1": -1.659,
                "beta2": -4.266,
                "eps": -8.564,
                "wd": -4.911,
                "max_lr": -2.994,
                "cycle_peak": 0.342,
            },
            "ail_part_or_xnor": {
                "beta1": -1.052,
                "beta2": -4.75,
                "eps": -7.848,
                "wd": -4.148,
                "max_lr": -2.822,
                "cycle_peak": 0.314,
            },
            "ail_part_or_and_xnor": {
                "beta1": -0.924,
                "beta2": -4.513,
                "eps": -8.425,
                "wd": -3.994,
                "max_lr": -3.129,
                "cycle_peak": 0.185,
            },
        },
        "cifar100": {
            "max": {
                "beta1": -0.964,
                "beta2": -5.072,
                "eps": -6.962,
                "wd": -4.382,
                "max_lr": -2.694,
                "cycle_peak": 0.339,
            },
            "relu": {
                "beta1": -0.761,
                "beta2": -2.444,
                "eps": -6.324,
                "wd": -4.559,
                "max_lr": -3.338,
                "cycle_peak": 0.23,
            },
            "swish": {
                "beta1": -0.878,
                "beta2": -4.284,
                "eps": -9.783,
                "wd": -4.446,
                "max_lr": -2.898,
                "cycle_peak": 0.312,
            },
            "bin_all_max_min": {
                "beta1": -0.887,
                "beta2": -5.215,
                "eps": -6.307,
                "wd": -5.623,
                "max_lr": -2.972,
                "cycle_peak": 0.27,
            },
            "ail_or": {
                "beta1": -1.199,
                "beta2": -5.005,
                "eps": -7.926,
                "wd": -4.548,
                "max_lr": -2.752,
                "cycle_peak": 0.334,
            },
            "ail_xnor": {
                "beta1": -2.206,
                "beta2": -1.528,
                "eps": -6.216,
                "wd": -3.185,
                "max_lr": -2.95,
                "cycle_peak": 0.54,
            },
            "ail_all_or_and": {
                "beta1": -1.26,
                "beta2": -4.87,
                "eps": -8.916,
                "wd": -4.67,
                "max_lr": -2.933,
                "cycle_peak": 0.386,
            },
            "ail_all_or_xnor": {
                "beta1": -1.188,
                "beta2": -4.501,
                "eps": -6.091,
                "wd": -4.153,
                "max_lr": -2.833,
                "cycle_peak": 0.319,
            },
            "ail_all_or_and_xnor": {
                "beta1": -1.659,
                "beta2": -4.266,
                "eps": -8.564,
                "wd": -4.911,
                "max_lr": -2.994,
                "cycle_peak": 0.342,
            },
            "ail_part_or_xnor": {
                "beta1": -1.052,
                "beta2": -4.75,
                "eps": -7.848,
                "wd": -4.148,
                "max_lr": -2.822,
                "cycle_peak": 0.314,
            },
            "ail_part_or_and_xnor": {
                "beta1": -0.924,
                "beta2": -4.513,
                "eps": -8.425,
                "wd": -3.994,
                "max_lr": -3.129,
                "cycle_peak": 0.185,
            },
        },
    },
}

_BOUNDS100 = {
    "mlp": {
        "mnist": {
            "max": {
                "beta1": -0.543,
                "beta2": -1.334,
                "eps": -7.684,
                "wd": -4.662,
                "max_lr": -2.636,
                "cycle_peak": 0.171,
            },
            "relu": {
                "beta1": -0.682,
                "beta2": -3.323,
                "eps": -9.239,
                "wd": -6.32,
                "max_lr": -2.23,
                "cycle_peak": 0.4,
            },
            "bin_all_max_min": {
                "beta1": -1.104,
                "beta2": -4.255,
                "eps": -9.68,
                "wd": -5.684,
                "max_lr": -2.833,
                "cycle_peak": 0.334,
            },
            "ail_or": {
                "beta1": -0.575,
                "beta2": -3.795,
                "eps": -9.623,
                "wd": -5.713,
                "max_lr": -1.9,
                "cycle_peak": 0.364,
            },
            "ail_xnor": {
                "beta1": -0.893,
                "beta2": -4.209,
                "eps": -7.833,
                "wd": -4.931,
                "max_lr": -2.288,
                "cycle_peak": 0.23,
            },
            "ail_all_or_and": {
                "beta1": -0.911,
                "beta2": -2.435,
                "eps": -10.393,
                "wd": -5.813,
                "max_lr": -2.98,
                "cycle_peak": 0.166,
            },
            "ail_all_or_xnor": {
                "beta1": -1.016,
                "beta2": -4.279,
                "eps": -9.249,
                "wd": -5.544,
                "max_lr": -1.874,
                "cycle_peak": 0.211,
            },
            "ail_all_or_and_xnor": {
                "beta1": -0.804,
                "beta2": -4.151,
                "eps": -8.91,
                "wd": -4.685,
                "max_lr": -2.417,
                "cycle_peak": 0.376,
            },
            "ail_part_or_xnor": {
                "beta1": -1.063,
                "beta2": -4.108,
                "eps": -10.195,
                "wd": -5.601,
                "max_lr": -2.866,
                "cycle_peak": 0.273,
            },
            "ail_part_or_and_xnor": {
                "beta1": -0.737,
                "beta2": -4.563,
                "eps": -10.485,
                "wd": -5.245,
                "max_lr": -2.789,
                "cycle_peak": 0.343,
            },
        },
        "cifar100": {
            "max": {
                "beta1": -0.632,
                "beta2": -3.758,
                "eps": -5.835,
                "wd": -2.616,
                "max_lr": -3.227,
                "cycle_peak": 0.376,
            },
            "relu": {
                "beta1": -0.831,
                "beta2": -5.063,
                "eps": -6.446,
                "wd": -2.688,
                "max_lr": -3.19,
                "cycle_peak": 0.401,
            },
        },
    },
    "cnn": {
        "cifar10": {
            "ail_all_or_and": {
                "beta1": -0.903,
                "beta2": -2.209,
                "eps": -7.501,
                "wd": -3.606,
                "max_lr": -2.962,
                "cycle_peak": 0.284,
            },
            "ail_all_or_and_xnor": {
                "beta1": -0.856,
                "beta2": -2.105,
                "eps": -8.238,
                "wd": -5.246,
                "max_lr": -2.916,
                "cycle_peak": 0.393,
            },
            "ail_all_or_xnor": {
                "beta1": -0.974,
                "beta2": -2.692,
                "eps": -6.482,
                "wd": -2.857,
                "max_lr": -2.87,
                "cycle_peak": 0.311,
            },
            "ail_or": {
                "beta1": -1.005,
                "beta2": -1.928,
                "eps": -7.536,
                "wd": -3.148,
                "max_lr": -2.779,
                "cycle_peak": 0.368,
            },
            "ail_part_or_and_xnor": {
                "beta1": -0.845,
                "beta2": -4.598,
                "eps": -4.735,
                "wd": -3.622,
                "max_lr": -2.595,
                "cycle_peak": 0.366,
            },
            "ail_part_or_xnor": {
                "beta1": -0.869,
                "beta2": -4.102,
                "eps": -8.633,
                "wd": -3.386,
                "max_lr": -2.646,
                "cycle_peak": 0.337,
            },
            "ail_xnor": {
                "beta1": -0.664,
                "beta2": -3.346,
                "eps": -7.574,
                "wd": -3.207,
                "max_lr": -2.491,
                "cycle_peak": 0.344,
            },
            "bin_all_max_min": {
                "beta1": -0.88,
                "beta2": -1.386,
                "eps": -7.55,
                "wd": -6.329,
                "max_lr": -2.838,
                "cycle_peak": 0.504,
            },
            "max": {
                "beta1": -0.868,
                "beta2": -2.224,
                "eps": -6.472,
                "wd": -3.629,
                "max_lr": -2.609,
                "cycle_peak": 0.294,
            },
            "relu": {
                "beta1": -0.755,
                "beta2": -2.929,
                "eps": -7.027,
                "wd": -3.585,
                "max_lr": -2.355,
                "cycle_peak": 0.303,
            },
        },
        "cifar100": {
            "max": {
                "beta1": -0.519,
                "beta2": -2.915,
                "eps": -7.804,
                "wd": -3.542,
                "max_lr": -2.589,
                "cycle_peak": 0.456,
            },
            "relu": {
                "beta1": -0.54,
                "beta2": -2.997,
                "eps": -6.384,
                "wd": -3.693,
                "max_lr": -2.932,
                "cycle_peak": 0.453,
            },
            "ail_all_or_and": {
                "beta1": -0.701,
                "beta2": -1.925,
                "eps": -6.823,
                "wd": -4.256,
                "max_lr": -3.051,
                "cycle_peak": 0.399,
            },
            "ail_all_or_and_xnor": {
                "beta1": -0.88,
                "beta2": -1.455,
                "eps": -6.57,
                "wd": -3.26,
                "max_lr": -2.997,
                "cycle_peak": 0.387,
            },
            "ail_all_or_xnor": {
                "beta1": -0.909,
                "beta2": -2.251,
                "eps": -8.966,
                "wd": -3.45,
                "max_lr": -2.865,
                "cycle_peak": 0.481,
            },
            "ail_or": {
                "beta1": -0.811,
                "beta2": -3.453,
                "eps": -10.211,
                "wd": -4.161,
                "max_lr": -2.704,
                "cycle_peak": 0.505,
            },
            "ail_part_or_and_xnor": {
                "beta1": -0.64,
                "beta2": -2.535,
                "eps": -7.47,
                "wd": -3.379,
                "max_lr": -2.694,
                "cycle_peak": 0.429,
            },
            "ail_part_or_xnor": {
                "beta1": -0.727,
                "beta2": -3.265,
                "eps": -6.161,
                "wd": -3.485,
                "max_lr": -2.629,
                "cycle_peak": 0.454,
            },
            "ail_xnor": {
                "beta1": -0.787,
                "beta2": -3.254,
                "eps": -7.192,
                "wd": -3.012,
                "max_lr": -2.639,
                "cycle_peak": 0.447,
            },
            "bin_all_max_min": {
                "beta1": -0.631,
                "beta2": -1.804,
                "eps": -8.554,
                "wd": -3.473,
                "max_lr": -2.883,
                "cycle_peak": 0.374,
            },
        },
        "cifar100_old": {
            "max": {
                "beta1": -0.575,
                "beta2": -4.64,
                "eps": -6.56,
                "wd": -3.438,
                "max_lr": -2.525,
                "cycle_peak": 0.372,
            },
            "relu": {
                "beta1": -0.504,
                "beta2": -5.047,
                "eps": -6.813,
                "wd": -3.458,
                "max_lr": -2.605,
                "cycle_peak": 0.421,
            },
        },
    },
    "resnet": {
        "cifar10": {
            "max": {
                "beta1": -0.964,
                "beta2": -5.072,
                "eps": -6.962,
                "wd": -4.382,
                "max_lr": -2.694,
                "cycle_peak": 0.339,
            },
            "relu": {
                "beta1": -0.761,
                "beta2": -2.444,
                "eps": -6.324,
                "wd": -4.559,
                "max_lr": -3.338,
                "cycle_peak": 0.23,
            },
            "swish": {
                "beta1": -0.878,
                "beta2": -4.284,
                "eps": -9.783,
                "wd": -4.446,
                "max_lr": -2.898,
                "cycle_peak": 0.312,
            },
            "bin_all_max_min": {
                "beta1": -0.887,
                "beta2": -5.215,
                "eps": -6.307,
                "wd": -5.623,
                "max_lr": -2.972,
                "cycle_peak": 0.27,
            },
            "ail_or": {
                "beta1": -1.199,
                "beta2": -5.005,
                "eps": -7.926,
                "wd": -4.548,
                "max_lr": -2.752,
                "cycle_peak": 0.334,
            },
            "ail_xnor": {
                "beta1": -2.206,
                "beta2": -1.528,
                "eps": -6.216,
                "wd": -3.185,
                "max_lr": -2.95,
                "cycle_peak": 0.54,
            },
            "ail_all_or_and": {
                "beta1": -1.26,
                "beta2": -4.87,
                "eps": -8.916,
                "wd": -4.67,
                "max_lr": -2.933,
                "cycle_peak": 0.386,
            },
            "ail_all_or_xnor": {
                "beta1": -1.188,
                "beta2": -4.501,
                "eps": -6.091,
                "wd": -4.153,
                "max_lr": -2.833,
                "cycle_peak": 0.319,
            },
            "ail_all_or_and_xnor": {
                "beta1": -1.659,
                "beta2": -4.266,
                "eps": -8.564,
                "wd": -4.911,
                "max_lr": -2.994,
                "cycle_peak": 0.342,
            },
            "ail_part_or_xnor": {
                "beta1": -1.052,
                "beta2": -4.75,
                "eps": -7.848,
                "wd": -4.148,
                "max_lr": -2.822,
                "cycle_peak": 0.314,
            },
            "ail_part_or_and_xnor": {
                "beta1": -0.924,
                "beta2": -4.513,
                "eps": -8.425,
                "wd": -3.994,
                "max_lr": -3.129,
                "cycle_peak": 0.185,
            },
        },
        "cifar100": {
            "max": {
                "beta1": -0.964,
                "beta2": -5.072,
                "eps": -6.962,
                "wd": -4.382,
                "max_lr": -2.694,
                "cycle_peak": 0.339,
            },
            "relu": {
                "beta1": -0.761,
                "beta2": -2.444,
                "eps": -6.324,
                "wd": -4.559,
                "max_lr": -3.338,
                "cycle_peak": 0.23,
            },
            "swish": {
                "beta1": -0.878,
                "beta2": -4.284,
                "eps": -9.783,
                "wd": -4.446,
                "max_lr": -2.898,
                "cycle_peak": 0.312,
            },
            "bin_all_max_min": {
                "beta1": -0.887,
                "beta2": -5.215,
                "eps": -6.307,
                "wd": -5.623,
                "max_lr": -2.972,
                "cycle_peak": 0.27,
            },
            "ail_or": {
                "beta1": -1.199,
                "beta2": -5.005,
                "eps": -7.926,
                "wd": -4.548,
                "max_lr": -2.752,
                "cycle_peak": 0.334,
            },
            "ail_xnor": {
                "beta1": -2.206,
                "beta2": -1.528,
                "eps": -6.216,
                "wd": -3.185,
                "max_lr": -2.95,
                "cycle_peak": 0.54,
            },
            "ail_all_or_and": {
                "beta1": -1.26,
                "beta2": -4.87,
                "eps": -8.916,
                "wd": -4.67,
                "max_lr": -2.933,
                "cycle_peak": 0.386,
            },
            "ail_all_or_xnor": {
                "beta1": -1.188,
                "beta2": -4.501,
                "eps": -6.091,
                "wd": -4.153,
                "max_lr": -2.833,
                "cycle_peak": 0.319,
            },
            "ail_all_or_and_xnor": {
                "beta1": -1.659,
                "beta2": -4.266,
                "eps": -8.564,
                "wd": -4.911,
                "max_lr": -2.994,
                "cycle_peak": 0.342,
            },
            "ail_part_or_xnor": {
                "beta1": -1.052,
                "beta2": -4.75,
                "eps": -7.848,
                "wd": -4.148,
                "max_lr": -2.822,
                "cycle_peak": 0.314,
            },
            "ail_part_or_and_xnor": {
                "beta1": -0.924,
                "beta2": -4.513,
                "eps": -8.425,
                "wd": -3.994,
                "max_lr": -3.129,
                "cycle_peak": 0.185,
            },
        },
        "imagenet": {
            "max": {
                "beta1": -0.964,
                "beta2": -5.072,
                "eps": -6.962,
                "wd": -4.382,
                "max_lr": -2.694,
                "cycle_peak": 0.339,
            },
            "relu": {
                "beta1": -0.761,
                "beta2": -2.444,
                "eps": -6.324,
                "wd": -4.559,
                "max_lr": -3.338,
                "cycle_peak": 0.23,
            },
            "swish": {
                "beta1": -0.878,
                "beta2": -4.284,
                "eps": -9.783,
                "wd": -4.446,
                "max_lr": -2.898,
                "cycle_peak": 0.312,
            },
            "bin_all_max_min": {
                "beta1": -0.887,
                "beta2": -5.215,
                "eps": -6.307,
                "wd": -5.623,
                "max_lr": -2.972,
                "cycle_peak": 0.27,
            },
            "ail_or": {
                "beta1": -1.199,
                "beta2": -5.005,
                "eps": -7.926,
                "wd": -4.548,
                "max_lr": -2.752,
                "cycle_peak": 0.334,
            },
            "ail_xnor": {
                "beta1": -2.206,
                "beta2": -1.528,
                "eps": -6.216,
                "wd": -3.185,
                "max_lr": -2.95,
                "cycle_peak": 0.54,
            },
            "ail_all_or_and": {
                "beta1": -1.26,
                "beta2": -4.87,
                "eps": -8.916,
                "wd": -4.67,
                "max_lr": -2.933,
                "cycle_peak": 0.386,
            },
            "ail_all_or_xnor": {
                "beta1": -1.188,
                "beta2": -4.501,
                "eps": -6.091,
                "wd": -4.153,
                "max_lr": -2.833,
                "cycle_peak": 0.319,
            },
            "ail_all_or_and_xnor": {
                "beta1": -1.659,
                "beta2": -4.266,
                "eps": -8.564,
                "wd": -4.911,
                "max_lr": -2.994,
                "cycle_peak": 0.342,
            },
            "ail_part_or_xnor": {
                "beta1": -1.052,
                "beta2": -4.75,
                "eps": -7.848,
                "wd": -4.148,
                "max_lr": -2.822,
                "cycle_peak": 0.314,
            },
            "ail_part_or_and_xnor": {
                "beta1": -0.924,
                "beta2": -4.513,
                "eps": -8.425,
                "wd": -3.994,
                "max_lr": -3.129,
                "cycle_peak": 0.185,
            },
        },
    },
}

_TEST_BOUNDS = {
    "mlp": {
        "mnist": {
            "ail_all_or_and": {
                "beta1": [
                    -0.787,
                    -0.931,
                    -0.831,
                    -0.973,
                    -0.911,
                    -0.841,
                    -0.999,
                    -0.854,
                    -0.99,
                    -0.896,
                ],
                "beta2": [
                    -2.66,
                    -2.332,
                    -2.558,
                    -3.626,
                    -2.435,
                    -3.86,
                    -3.404,
                    -3.406,
                    -3.055,
                    -2.954,
                ],
                "eps": [
                    -9.642,
                    -10.123,
                    -10.067,
                    -8.966,
                    -10.393,
                    -9.707,
                    -9.223,
                    -9.944,
                    -9.45,
                    -10.041,
                ],
                "wd": [
                    -5.854,
                    -5.591,
                    -5.565,
                    -5.893,
                    -5.813,
                    -6.053,
                    -5.022,
                    -5.627,
                    -5.965,
                    -5.331,
                ],
                "max_lr": [
                    -2.788,
                    -2.946,
                    -2.943,
                    -2.962,
                    -2.98,
                    -2.189,
                    -2.867,
                    -2.95,
                    -2.967,
                    -2.943,
                ],
                "cycle_peak": [
                    0.255,
                    0.167,
                    0.292,
                    0.285,
                    0.166,
                    0.317,
                    0.239,
                    0.293,
                    0.16,
                    0.262,
                ],
            },
            "ail_all_or_and_xnor": {
                "beta1": [
                    -0.978,
                    -0.926,
                    -0.981,
                    -1.763,
                    -0.941,
                    -1.0,
                    -0.966,
                    -0.935,
                    -0.888,
                    -0.804,
                ],
                "beta2": [
                    -4.546,
                    -4.696,
                    -4.095,
                    -4.088,
                    -4.615,
                    -4.585,
                    -4.478,
                    -4.379,
                    -4.288,
                    -4.151,
                ],
                "eps": [
                    -9.224,
                    -9.453,
                    -9.731,
                    -8.978,
                    -9.096,
                    -9.616,
                    -9.588,
                    -9.491,
                    -9.102,
                    -8.91,
                ],
                "wd": [
                    -5.395,
                    -5.489,
                    -6.117,
                    -4.585,
                    -6.201,
                    -5.326,
                    -5.675,
                    -5.475,
                    -6.235,
                    -4.685,
                ],
                "max_lr": [
                    -2.778,
                    -2.743,
                    -2.69,
                    -2.491,
                    -2.267,
                    -2.778,
                    -2.91,
                    -2.75,
                    -2.862,
                    -2.417,
                ],
                "cycle_peak": [
                    0.388,
                    0.396,
                    0.322,
                    0.499,
                    0.323,
                    0.369,
                    0.398,
                    0.356,
                    0.381,
                    0.376,
                ],
            },
            "ail_all_or_xnor": {
                "beta1": [
                    -1.016,
                    -1.025,
                    -1.08,
                    -1.055,
                    -0.965,
                    -1.08,
                    -1.122,
                    -1.052,
                    -1.072,
                    -1.048,
                ],
                "beta2": [
                    -4.279,
                    -4.319,
                    -3.6,
                    -4.151,
                    -3.906,
                    -4.007,
                    -4.183,
                    -4.195,
                    -4.059,
                    -3.799,
                ],
                "eps": [
                    -9.249,
                    -9.344,
                    -9.167,
                    -9.337,
                    -8.736,
                    -9.13,
                    -8.839,
                    -9.328,
                    -9.273,
                    -9.392,
                ],
                "wd": [
                    -5.544,
                    -5.469,
                    -5.356,
                    -5.303,
                    -6.161,
                    -5.326,
                    -5.9,
                    -5.608,
                    -5.693,
                    -5.824,
                ],
                "max_lr": [
                    -1.874,
                    -3.256,
                    -2.909,
                    -3.232,
                    -3.35,
                    -3.17,
                    -2.871,
                    -3.18,
                    -3.045,
                    -3.214,
                ],
                "cycle_peak": [
                    0.211,
                    0.248,
                    0.19,
                    0.304,
                    0.347,
                    0.213,
                    0.343,
                    0.315,
                    0.169,
                    0.164,
                ],
            },
            "ail_or": {
                "beta1": [
                    -0.941,
                    -0.635,
                    -0.616,
                    -0.889,
                    -0.841,
                    -0.781,
                    -0.76,
                    -0.681,
                    -0.575,
                    -0.811,
                ],
                "beta2": [
                    -4.356,
                    -3.263,
                    -3.039,
                    -3.419,
                    -3.86,
                    -2.243,
                    -3.81,
                    -1.51,
                    -3.795,
                    -4.091,
                ],
                "eps": [
                    -9.341,
                    -9.801,
                    -9.717,
                    -9.893,
                    -9.707,
                    -9.445,
                    -9.86,
                    -7.661,
                    -9.623,
                    -9.772,
                ],
                "wd": [
                    -6.191,
                    -5.815,
                    -6.167,
                    -6.14,
                    -6.053,
                    -6.141,
                    -5.975,
                    -6.621,
                    -5.713,
                    -5.887,
                ],
                "max_lr": [
                    -2.226,
                    -1.861,
                    -1.988,
                    -2.087,
                    -2.189,
                    -1.672,
                    -2.232,
                    -2.733,
                    -1.9,
                    -1.977,
                ],
                "cycle_peak": [
                    0.351,
                    0.365,
                    0.329,
                    0.366,
                    0.317,
                    0.387,
                    0.371,
                    0.159,
                    0.364,
                    0.347,
                ],
            },
            "ail_part_or_and_xnor": {
                "beta1": [
                    -0.919,
                    -0.92,
                    -0.541,
                    -0.841,
                    -0.573,
                    -0.682,
                    -0.546,
                    -0.67,
                    -0.878,
                    -0.737,
                ],
                "beta2": [
                    -4.601,
                    -4.453,
                    -4.533,
                    -4.585,
                    -4.69,
                    -4.324,
                    -4.308,
                    -4.383,
                    -4.063,
                    -4.563,
                ],
                "eps": [
                    -9.388,
                    -9.816,
                    -10.759,
                    -10.383,
                    -10.238,
                    -10.419,
                    -10.754,
                    -7.8,
                    -9.168,
                    -10.485,
                ],
                "wd": [
                    -4.763,
                    -5.082,
                    -4.897,
                    -4.99,
                    -5.161,
                    -4.928,
                    -4.921,
                    -5.623,
                    -6.059,
                    -5.245,
                ],
                "max_lr": [
                    -2.883,
                    -2.611,
                    -2.752,
                    -2.695,
                    -3.044,
                    -2.69,
                    -2.716,
                    -2.902,
                    -2.606,
                    -2.789,
                ],
                "cycle_peak": [
                    0.315,
                    0.315,
                    0.326,
                    0.32,
                    0.341,
                    0.336,
                    0.332,
                    0.363,
                    0.302,
                    0.343,
                ],
            },
            "ail_part_or_xnor": {
                "beta1": [
                    -1.357,
                    -0.841,
                    -1.375,
                    -1.262,
                    -1.256,
                    -1.284,
                    -1.36,
                    -1.063,
                    -1.47,
                    -0.89,
                ],
                "beta2": [
                    -4.728,
                    -3.86,
                    -4.789,
                    -4.697,
                    -4.212,
                    -4.346,
                    -4.007,
                    -4.108,
                    -4.324,
                    -3.786,
                ],
                "eps": [
                    -9.205,
                    -9.707,
                    -8.877,
                    -8.237,
                    -8.002,
                    -8.172,
                    -9.296,
                    -10.195,
                    -8.256,
                    -9.568,
                ],
                "wd": [
                    -5.502,
                    -6.053,
                    -6.383,
                    -5.765,
                    -4.836,
                    -6.765,
                    -6.124,
                    -5.601,
                    -6.077,
                    -5.098,
                ],
                "max_lr": [
                    -2.285,
                    -2.189,
                    -2.352,
                    -2.132,
                    -2.206,
                    -2.142,
                    -2.174,
                    -2.866,
                    -2.819,
                    -2.534,
                ],
                "cycle_peak": [
                    0.216,
                    0.317,
                    0.315,
                    0.163,
                    0.173,
                    0.249,
                    0.202,
                    0.273,
                    0.16,
                    0.187,
                ],
            },
            "ail_xnor": {
                "beta1": [
                    -0.845,
                    -0.764,
                    -0.828,
                    -0.813,
                    -0.861,
                    -0.768,
                    -0.864,
                    -0.834,
                    -0.893,
                    -0.883,
                ],
                "beta2": [
                    -4.056,
                    -3.445,
                    -4.214,
                    -4.27,
                    -4.882,
                    -3.672,
                    -4.844,
                    -4.474,
                    -4.209,
                    -3.925,
                ],
                "eps": [
                    -7.4,
                    -7.269,
                    -7.735,
                    -7.098,
                    -8.19,
                    -6.715,
                    -7.257,
                    -7.99,
                    -7.833,
                    -6.645,
                ],
                "wd": [
                    -7.042,
                    -6.32,
                    -4.726,
                    -7.417,
                    -3.948,
                    -3.167,
                    -6.838,
                    -6.16,
                    -4.931,
                    -6.717,
                ],
                "max_lr": [
                    -2.684,
                    -2.485,
                    -2.619,
                    -2.506,
                    -3.139,
                    -3.569,
                    -2.576,
                    -2.778,
                    -2.288,
                    -2.926,
                ],
                "cycle_peak": [
                    0.255,
                    0.34,
                    0.293,
                    0.266,
                    0.293,
                    0.338,
                    0.317,
                    0.279,
                    0.23,
                    0.205,
                ],
            },
            "bin_all_max_min": {
                "beta1": [
                    -1.109,
                    -1.104,
                    -1.246,
                    -1.185,
                    -1.154,
                    -1.05,
                    -0.982,
                    -1.22,
                    -1.003,
                    -1.19,
                ],
                "beta2": [
                    -5.022,
                    -4.255,
                    -4.813,
                    -5.309,
                    -5.043,
                    -5.314,
                    -5.256,
                    -5.022,
                    -5.261,
                    -5.023,
                ],
                "eps": [
                    -9.514,
                    -9.68,
                    -9.104,
                    -9.189,
                    -9.306,
                    -9.703,
                    -8.453,
                    -8.614,
                    -9.587,
                    -9.411,
                ],
                "wd": [
                    -5.634,
                    -5.684,
                    -5.477,
                    -5.698,
                    -5.707,
                    -5.609,
                    -5.354,
                    -5.684,
                    -5.519,
                    -5.565,
                ],
                "max_lr": [
                    -2.668,
                    -2.833,
                    -2.366,
                    -2.713,
                    -2.737,
                    -2.84,
                    -2.444,
                    -2.787,
                    -2.842,
                    -2.824,
                ],
                "cycle_peak": [
                    0.375,
                    0.334,
                    0.292,
                    0.363,
                    0.317,
                    0.356,
                    0.22,
                    0.343,
                    0.321,
                    0.323,
                ],
            },
            "max": {
                "beta1": [
                    -0.681,
                    -1.158,
                    -1.218,
                    -1.342,
                    -1.339,
                    -1.195,
                    -1.153,
                    -0.543,
                    -1.199,
                    -1.113,
                ],
                "beta2": [
                    -1.51,
                    -4.641,
                    -5.763,
                    -3.668,
                    -4.677,
                    -5.414,
                    -4.285,
                    -1.334,
                    -2.669,
                    -4.077,
                ],
                "eps": [
                    -7.661,
                    -7.445,
                    -7.458,
                    -7.331,
                    -7.241,
                    -7.61,
                    -7.504,
                    -7.684,
                    -6.996,
                    -8.36,
                ],
                "wd": [
                    -6.621,
                    -7.019,
                    -6.745,
                    -7.079,
                    -7.67,
                    -6.203,
                    -7.927,
                    -4.662,
                    -7.49,
                    -5.317,
                ],
                "max_lr": [
                    -2.733,
                    -2.876,
                    -2.893,
                    -2.769,
                    -2.904,
                    -2.848,
                    -2.882,
                    -2.636,
                    -2.879,
                    -2.337,
                ],
                "cycle_peak": [
                    0.159,
                    0.317,
                    0.379,
                    0.14,
                    0.147,
                    0.349,
                    0.247,
                    0.171,
                    0.331,
                    0.251,
                ],
            },
            "relu": {
                "beta1": [
                    -0.988,
                    -0.659,
                    -0.948,
                    -1.089,
                    -0.682,
                    -0.662,
                    -1.125,
                    -1.055,
                    -0.908,
                    -0.886,
                ],
                "beta2": [
                    -2.957,
                    -3.51,
                    -3.598,
                    -3.729,
                    -3.323,
                    -2.842,
                    -3.958,
                    -3.719,
                    -2.861,
                    -3.083,
                ],
                "eps": [
                    -9.448,
                    -8.719,
                    -9.302,
                    -8.907,
                    -9.239,
                    -9.187,
                    -8.947,
                    -9.098,
                    -8.921,
                    -9.604,
                ],
                "wd": [
                    -6.701,
                    -6.846,
                    -6.489,
                    -6.639,
                    -6.32,
                    -6.77,
                    -6.126,
                    -6.206,
                    -6.538,
                    -6.756,
                ],
                "max_lr": [
                    -2.344,
                    -2.294,
                    -2.291,
                    -2.171,
                    -2.23,
                    -2.265,
                    -2.278,
                    -2.243,
                    -2.344,
                    -2.345,
                ],
                "cycle_peak": [
                    0.153,
                    0.453,
                    0.269,
                    0.154,
                    0.4,
                    0.229,
                    0.317,
                    0.281,
                    0.172,
                    0.147,
                ],
            },
        },
        "cifar100": {
            "max": {
                "beta1": -0.669,
                "beta2": -3.694,
                "eps": -10.372,
                "wd": -5.438,
                "max_lr": -2.328,
                "cycle_peak": 0.396,
            },
            "relu": {
                "beta1": -0.639,
                "beta2": -4.195,
                "eps": -7.136,
                "wd": -5.991,
                "max_lr": -2.023,
                "cycle_peak": 0.35,
            },
        },
    },
    "cnn": {
        "cifar10": {
            "ail_all_or_and": {
                "beta1": [
                    -1.033,
                    -1.122,
                    -0.927,
                    -0.941,
                    -0.899,
                    -1.06,
                    -1.053,
                    -1.069,
                    -1.034,
                    -0.903,
                ],
                "beta2": [
                    -2.624,
                    -1.865,
                    -2.193,
                    -2.815,
                    -2.206,
                    -1.801,
                    -2.03,
                    -1.717,
                    -1.908,
                    -2.209,
                ],
                "eps": [
                    -8.057,
                    -7.923,
                    -7.945,
                    -7.792,
                    -8.093,
                    -8.137,
                    -7.98,
                    -7.71,
                    -8.034,
                    -7.501,
                ],
                "wd": [
                    -3.678,
                    -3.378,
                    -4.136,
                    -3.557,
                    -4.537,
                    -4.454,
                    -3.808,
                    -4.137,
                    -3.497,
                    -3.606,
                ],
                "max_lr": [
                    -2.973,
                    -2.938,
                    -2.972,
                    -2.979,
                    -2.984,
                    -3.012,
                    -2.959,
                    -2.961,
                    -2.974,
                    -2.962,
                ],
                "cycle_peak": [
                    0.346,
                    0.442,
                    0.392,
                    0.287,
                    0.371,
                    0.303,
                    0.275,
                    0.481,
                    0.297,
                    0.284,
                ],
            },
            "ail_all_or_and_xnor": {
                "beta1": [
                    -0.839,
                    -0.856,
                    -1.068,
                    -0.968,
                    -0.927,
                    -0.92,
                    -0.928,
                    -0.834,
                    -1.011,
                    -0.916,
                ],
                "beta2": [
                    -2.333,
                    -2.105,
                    -1.671,
                    -2.343,
                    -2.492,
                    -2.096,
                    -2.02,
                    -2.327,
                    -1.761,
                    -1.174,
                ],
                "eps": [
                    -6.16,
                    -8.238,
                    -8.402,
                    -7.162,
                    -6.856,
                    -8.518,
                    -7.855,
                    -7.921,
                    -6.225,
                    -6.164,
                ],
                "wd": [
                    -4.752,
                    -5.246,
                    -4.903,
                    -5.478,
                    -5.713,
                    -5.552,
                    -4.295,
                    -5.929,
                    -4.56,
                    -5.891,
                ],
                "max_lr": [
                    -2.92,
                    -2.916,
                    -2.967,
                    -2.938,
                    -2.915,
                    -2.923,
                    -2.931,
                    -2.937,
                    -2.921,
                    -2.951,
                ],
                "cycle_peak": [
                    0.3,
                    0.393,
                    0.492,
                    0.308,
                    0.431,
                    0.473,
                    0.418,
                    0.368,
                    0.296,
                    0.474,
                ],
            },
            "ail_all_or_xnor": {
                "beta1": [
                    -0.821,
                    -0.905,
                    -0.84,
                    -0.924,
                    -0.971,
                    -0.961,
                    -0.975,
                    -1.009,
                    -0.974,
                    -0.9,
                ],
                "beta2": [
                    -2.763,
                    -2.449,
                    -2.769,
                    -2.822,
                    -2.845,
                    -2.876,
                    -2.783,
                    -2.741,
                    -2.692,
                    -2.872,
                ],
                "eps": [
                    -9.632,
                    -9.311,
                    -6.31,
                    -8.916,
                    -6.195,
                    -8.0,
                    -8.129,
                    -6.559,
                    -6.482,
                    -6.188,
                ],
                "wd": [
                    -2.854,
                    -3.411,
                    -3.022,
                    -2.868,
                    -2.965,
                    -2.901,
                    -2.883,
                    -2.918,
                    -2.857,
                    -2.842,
                ],
                "max_lr": [
                    -2.875,
                    -2.864,
                    -2.877,
                    -2.911,
                    -2.884,
                    -2.876,
                    -2.912,
                    -2.85,
                    -2.87,
                    -2.872,
                ],
                "cycle_peak": [
                    0.391,
                    0.324,
                    0.318,
                    0.39,
                    0.384,
                    0.374,
                    0.332,
                    0.343,
                    0.311,
                    0.352,
                ],
            },
            "ail_or": {
                "beta1": [
                    -0.88,
                    -0.878,
                    -0.992,
                    -0.747,
                    -1.013,
                    -0.774,
                    -0.969,
                    -1.005,
                    -1.005,
                    -0.92,
                ],
                "beta2": [
                    -1.919,
                    -1.9,
                    -2.022,
                    -1.926,
                    -2.017,
                    -1.951,
                    -1.915,
                    -1.928,
                    -1.993,
                    -2.031,
                ],
                "eps": [
                    -10.26,
                    -7.752,
                    -8.858,
                    -9.313,
                    -6.868,
                    -9.233,
                    -9.362,
                    -7.536,
                    -9.433,
                    -9.158,
                ],
                "wd": [
                    -3.992,
                    -3.033,
                    -3.978,
                    -3.592,
                    -3.086,
                    -3.181,
                    -3.6,
                    -3.148,
                    -3.439,
                    -3.376,
                ],
                "max_lr": [
                    -2.823,
                    -2.81,
                    -2.8,
                    -2.811,
                    -2.787,
                    -2.804,
                    -2.83,
                    -2.779,
                    -2.778,
                    -2.8,
                ],
                "cycle_peak": [
                    0.331,
                    0.424,
                    0.378,
                    0.354,
                    0.355,
                    0.333,
                    0.417,
                    0.368,
                    0.335,
                    0.363,
                ],
            },
            "ail_part_or_and_xnor": {
                "beta1": [
                    -0.845,
                    -0.67,
                    -0.709,
                    -0.829,
                    -0.757,
                    -0.82,
                    -0.666,
                    -0.794,
                    -0.564,
                    -0.647,
                ],
                "beta2": [
                    -4.598,
                    -4.722,
                    -5.072,
                    -4.389,
                    -4.737,
                    -4.952,
                    -4.951,
                    -4.324,
                    -3.175,
                    -4.536,
                ],
                "eps": [
                    -4.735,
                    -5.416,
                    -5.913,
                    -5.464,
                    -5.721,
                    -4.408,
                    -6.43,
                    -4.877,
                    -5.303,
                    -4.438,
                ],
                "wd": [
                    -3.622,
                    -3.516,
                    -3.577,
                    -3.631,
                    -3.588,
                    -3.526,
                    -3.683,
                    -3.558,
                    -3.983,
                    -3.563,
                ],
                "max_lr": [
                    -2.595,
                    -2.583,
                    -2.634,
                    -2.62,
                    -2.596,
                    -2.645,
                    -2.662,
                    -2.595,
                    -2.588,
                    -2.588,
                ],
                "cycle_peak": [
                    0.366,
                    0.414,
                    0.426,
                    0.393,
                    0.375,
                    0.364,
                    0.425,
                    0.377,
                    0.325,
                    0.36,
                ],
            },
            "ail_part_or_xnor": {
                "beta1": [
                    -0.807,
                    -0.869,
                    -0.807,
                    -0.863,
                    -0.86,
                    -0.865,
                    -0.845,
                    -0.835,
                    -0.85,
                    -0.847,
                ],
                "beta2": [
                    -4.379,
                    -4.102,
                    -4.299,
                    -4.219,
                    -4.132,
                    -4.388,
                    -4.485,
                    -4.071,
                    -3.524,
                    -4.469,
                ],
                "eps": [
                    -8.796,
                    -8.633,
                    -7.976,
                    -7.986,
                    -7.731,
                    -8.882,
                    -7.988,
                    -7.378,
                    -8.763,
                    -7.45,
                ],
                "wd": [
                    -3.379,
                    -3.386,
                    -3.267,
                    -3.523,
                    -3.318,
                    -3.324,
                    -3.414,
                    -3.502,
                    -3.649,
                    -3.455,
                ],
                "max_lr": [
                    -2.637,
                    -2.646,
                    -2.573,
                    -2.611,
                    -2.564,
                    -2.624,
                    -2.605,
                    -2.587,
                    -2.722,
                    -2.602,
                ],
                "cycle_peak": [
                    0.267,
                    0.337,
                    0.328,
                    0.273,
                    0.285,
                    0.314,
                    0.283,
                    0.301,
                    0.295,
                    0.28,
                ],
            },
            "ail_xnor": {
                "beta1": [
                    -0.732,
                    -0.729,
                    -0.723,
                    -0.747,
                    -0.739,
                    -0.664,
                    -0.729,
                    -0.755,
                    -0.653,
                    -0.706,
                ],
                "beta2": [
                    -2.786,
                    -3.32,
                    -3.537,
                    -3.789,
                    -3.315,
                    -3.346,
                    -2.848,
                    -3.696,
                    -3.645,
                    -3.382,
                ],
                "eps": [
                    -7.263,
                    -7.264,
                    -7.174,
                    -7.487,
                    -7.384,
                    -7.574,
                    -7.457,
                    -7.055,
                    -7.528,
                    -7.411,
                ],
                "wd": [
                    -3.124,
                    -3.194,
                    -3.15,
                    -3.233,
                    -3.457,
                    -3.207,
                    -3.21,
                    -3.257,
                    -3.473,
                    -3.42,
                ],
                "max_lr": [
                    -2.56,
                    -2.452,
                    -2.457,
                    -2.562,
                    -2.535,
                    -2.491,
                    -2.475,
                    -2.493,
                    -2.594,
                    -2.46,
                ],
                "cycle_peak": [
                    0.357,
                    0.365,
                    0.344,
                    0.375,
                    0.37,
                    0.344,
                    0.356,
                    0.454,
                    0.474,
                    0.386,
                ],
            },
            "bin_all_max_min": {
                "beta1": [
                    -0.863,
                    -0.812,
                    -0.804,
                    -0.776,
                    -0.804,
                    -0.781,
                    -0.911,
                    -0.728,
                    -0.831,
                    -0.88,
                ],
                "beta2": [
                    -1.927,
                    -1.64,
                    -1.819,
                    -1.862,
                    -1.378,
                    -1.494,
                    -1.794,
                    -1.444,
                    -1.805,
                    -1.386,
                ],
                "eps": [
                    -7.599,
                    -7.756,
                    -7.838,
                    -7.418,
                    -7.322,
                    -7.839,
                    -8.059,
                    -8.441,
                    -7.998,
                    -7.55,
                ],
                "wd": [
                    -6.709,
                    -6.01,
                    -5.76,
                    -6.659,
                    -6.675,
                    -6.172,
                    -5.925,
                    -5.911,
                    -6.643,
                    -6.329,
                ],
                "max_lr": [
                    -2.91,
                    -2.864,
                    -2.91,
                    -2.855,
                    -2.821,
                    -2.924,
                    -2.86,
                    -2.936,
                    -2.856,
                    -2.838,
                ],
                "cycle_peak": [
                    0.468,
                    0.397,
                    0.397,
                    0.409,
                    0.534,
                    0.514,
                    0.458,
                    0.532,
                    0.361,
                    0.504,
                ],
            },
            "max": {
                "beta1": [
                    -0.809,
                    -0.807,
                    -0.834,
                    -0.821,
                    -0.868,
                    -0.79,
                    -0.805,
                    -0.831,
                    -0.83,
                    -0.794,
                ],
                "beta2": [
                    -2.273,
                    -2.095,
                    -2.244,
                    -2.187,
                    -2.224,
                    -2.007,
                    -2.424,
                    -2.12,
                    -2.077,
                    -2.228,
                ],
                "eps": [
                    -6.569,
                    -6.489,
                    -6.912,
                    -6.906,
                    -6.472,
                    -6.684,
                    -6.739,
                    -6.921,
                    -6.531,
                    -6.637,
                ],
                "wd": [
                    -3.781,
                    -3.799,
                    -3.516,
                    -3.777,
                    -3.629,
                    -3.707,
                    -3.486,
                    -3.696,
                    -3.348,
                    -3.259,
                ],
                "max_lr": [
                    -2.591,
                    -2.611,
                    -2.619,
                    -2.606,
                    -2.609,
                    -2.601,
                    -2.627,
                    -2.634,
                    -2.622,
                    -2.64,
                ],
                "cycle_peak": [
                    0.302,
                    0.332,
                    0.267,
                    0.371,
                    0.294,
                    0.295,
                    0.387,
                    0.266,
                    0.391,
                    0.4,
                ],
            },
            "relu": {
                "beta1": [
                    -0.737,
                    -0.694,
                    -0.735,
                    -0.73,
                    -0.746,
                    -0.755,
                    -0.734,
                    -0.82,
                    -0.755,
                    -0.692,
                ],
                "beta2": [
                    -2.779,
                    -2.871,
                    -2.614,
                    -2.788,
                    -2.7,
                    -2.943,
                    -2.803,
                    -2.753,
                    -2.929,
                    -2.766,
                ],
                "eps": [
                    -6.498,
                    -6.287,
                    -5.617,
                    -6.394,
                    -6.168,
                    -7.034,
                    -6.927,
                    -7.338,
                    -7.027,
                    -6.976,
                ],
                "wd": [
                    -3.555,
                    -3.44,
                    -3.55,
                    -3.498,
                    -3.509,
                    -3.534,
                    -3.491,
                    -3.561,
                    -3.585,
                    -3.57,
                ],
                "max_lr": [
                    -2.338,
                    -2.339,
                    -2.361,
                    -2.362,
                    -2.369,
                    -2.373,
                    -2.383,
                    -2.378,
                    -2.355,
                    -2.37,
                ],
                "cycle_peak": [
                    0.32,
                    0.343,
                    0.35,
                    0.313,
                    0.334,
                    0.352,
                    0.328,
                    0.345,
                    0.303,
                    0.308,
                ],
            },
        },
        "cifar100": {
            "max": {
                "beta1": [
                    -0.527,
                    -0.47,
                    -0.531,
                    -0.519,
                    -0.651,
                    -0.527,
                    -0.518,
                    -0.585,
                    -0.56,
                    -0.636,
                ],
                "beta2": [
                    -2.788,
                    -2.824,
                    -2.88,
                    -2.915,
                    -2.646,
                    -2.851,
                    -2.795,
                    -2.794,
                    -2.911,
                    -2.643,
                ],
                "eps": [
                    -7.535,
                    -8.031,
                    -7.955,
                    -7.804,
                    -7.619,
                    -7.916,
                    -8.045,
                    -7.937,
                    -7.695,
                    -7.441,
                ],
                "wd": [
                    -3.784,
                    -3.482,
                    -3.506,
                    -3.542,
                    -3.753,
                    -3.734,
                    -3.778,
                    -3.605,
                    -3.796,
                    -3.721,
                ],
                "max_lr": [
                    -2.534,
                    -2.575,
                    -2.556,
                    -2.589,
                    -2.584,
                    -2.54,
                    -2.549,
                    -2.611,
                    -2.549,
                    -2.571,
                ],
                "cycle_peak": [
                    0.438,
                    0.444,
                    0.442,
                    0.456,
                    0.432,
                    0.434,
                    0.45,
                    0.456,
                    0.447,
                    0.437,
                ],
            },
            "relu": {
                "beta1": [
                    -0.445,
                    -0.39,
                    -0.511,
                    -0.429,
                    -0.51,
                    -0.564,
                    -0.378,
                    -0.54,
                    -0.605,
                    -0.417,
                ],
                "beta2": [
                    -2.333,
                    -2.353,
                    -2.332,
                    -2.591,
                    -2.906,
                    -2.362,
                    -2.567,
                    -2.997,
                    -3.233,
                    -2.905,
                ],
                "eps": [
                    -7.2,
                    -7.115,
                    -7.212,
                    -6.403,
                    -6.461,
                    -7.548,
                    -7.593,
                    -6.384,
                    -7.2,
                    -7.762,
                ],
                "wd": [
                    -3.964,
                    -3.996,
                    -3.775,
                    -4.287,
                    -3.702,
                    -3.886,
                    -3.69,
                    -3.693,
                    -3.615,
                    -3.865,
                ],
                "max_lr": [
                    -2.909,
                    -2.961,
                    -2.875,
                    -2.884,
                    -2.856,
                    -2.959,
                    -2.862,
                    -2.932,
                    -2.908,
                    -2.734,
                ],
                "cycle_peak": [
                    0.467,
                    0.472,
                    0.452,
                    0.465,
                    0.463,
                    0.475,
                    0.475,
                    0.453,
                    0.439,
                    0.461,
                ],
            },
            "ail_all_or_and": {
                "beta1": [
                    -0.662,
                    -0.834,
                    -0.797,
                    -0.795,
                    -0.657,
                    -0.707,
                    -0.714,
                    -0.814,
                    -0.808,
                    -0.701,
                ],
                "beta2": [
                    -2.12,
                    -1.421,
                    -2.523,
                    -2.638,
                    -2.322,
                    -2.04,
                    -2.065,
                    -1.098,
                    -2.489,
                    -1.925,
                ],
                "eps": [
                    -6.776,
                    -6.806,
                    -6.842,
                    -6.804,
                    -6.661,
                    -6.74,
                    -6.694,
                    -6.571,
                    -6.665,
                    -6.823,
                ],
                "wd": [
                    -3.868,
                    -4.175,
                    -3.643,
                    -3.504,
                    -4.476,
                    -3.477,
                    -4.298,
                    -4.584,
                    -4.176,
                    -4.256,
                ],
                "max_lr": [
                    -3.064,
                    -3.06,
                    -3.088,
                    -3.098,
                    -3.094,
                    -3.065,
                    -3.061,
                    -3.072,
                    -3.09,
                    -3.051,
                ],
                "cycle_peak": [
                    0.454,
                    0.395,
                    0.446,
                    0.448,
                    0.435,
                    0.453,
                    0.452,
                    0.326,
                    0.462,
                    0.399,
                ],
            },
            "ail_all_or_and_xnor": {
                "beta1": [
                    -0.88,
                    -0.805,
                    -0.8,
                    -0.83,
                    -0.784,
                    -0.792,
                    -0.885,
                    -0.825,
                    -0.895,
                    -0.741,
                ],
                "beta2": [
                    -1.455,
                    -1.491,
                    -1.424,
                    -1.561,
                    -1.465,
                    -1.47,
                    -1.493,
                    -1.528,
                    -1.498,
                    -1.654,
                ],
                "eps": [
                    -6.57,
                    -6.706,
                    -6.63,
                    -6.741,
                    -6.719,
                    -6.599,
                    -6.652,
                    -6.768,
                    -6.512,
                    -6.663,
                ],
                "wd": [
                    -3.26,
                    -3.495,
                    -4.395,
                    -3.216,
                    -3.327,
                    -3.866,
                    -4.333,
                    -3.32,
                    -3.206,
                    -3.479,
                ],
                "max_lr": [
                    -2.997,
                    -3.055,
                    -3.017,
                    -3.029,
                    -3.052,
                    -3.04,
                    -3.066,
                    -3.078,
                    -3.012,
                    -3.039,
                ],
                "cycle_peak": [
                    0.387,
                    0.402,
                    0.473,
                    0.39,
                    0.48,
                    0.378,
                    0.345,
                    0.348,
                    0.335,
                    0.37,
                ],
            },
            "ail_all_or_xnor": {
                "beta1": [
                    -0.935,
                    -1.01,
                    -0.917,
                    -0.926,
                    -0.907,
                    -0.982,
                    -0.886,
                    -0.997,
                    -0.909,
                    -0.951,
                ],
                "beta2": [
                    -1.828,
                    -1.746,
                    -2.116,
                    -1.801,
                    -1.843,
                    -1.728,
                    -2.16,
                    -1.744,
                    -2.251,
                    -1.954,
                ],
                "eps": [
                    -9.23,
                    -8.82,
                    -9.1,
                    -9.558,
                    -9.277,
                    -9.195,
                    -8.777,
                    -8.782,
                    -8.966,
                    -9.073,
                ],
                "wd": [
                    -3.358,
                    -3.727,
                    -3.505,
                    -3.384,
                    -3.446,
                    -3.433,
                    -3.739,
                    -3.634,
                    -3.45,
                    -3.711,
                ],
                "max_lr": [
                    -2.861,
                    -2.832,
                    -2.872,
                    -2.924,
                    -2.884,
                    -2.859,
                    -2.857,
                    -2.891,
                    -2.865,
                    -2.832,
                ],
                "cycle_peak": [
                    0.51,
                    0.473,
                    0.517,
                    0.51,
                    0.529,
                    0.483,
                    0.485,
                    0.52,
                    0.481,
                    0.488,
                ],
            },
            "ail_or": {
                "beta1": [
                    -0.84,
                    -0.855,
                    -0.918,
                    -0.899,
                    -0.948,
                    -0.868,
                    -0.839,
                    -0.811,
                    -0.857,
                    -0.916,
                ],
                "beta2": [
                    -3.853,
                    -3.76,
                    -3.811,
                    -3.743,
                    -3.705,
                    -3.747,
                    -3.698,
                    -3.453,
                    -3.836,
                    -3.866,
                ],
                "eps": [
                    -9.14,
                    -9.113,
                    -9.646,
                    -10.002,
                    -8.816,
                    -9.508,
                    -8.785,
                    -10.211,
                    -9.681,
                    -9.659,
                ],
                "wd": [
                    -4.19,
                    -4.21,
                    -4.245,
                    -4.176,
                    -4.271,
                    -4.187,
                    -4.151,
                    -4.161,
                    -4.209,
                    -4.237,
                ],
                "max_lr": [
                    -2.714,
                    -2.72,
                    -2.723,
                    -2.708,
                    -2.736,
                    -2.728,
                    -2.681,
                    -2.704,
                    -2.729,
                    -2.724,
                ],
                "cycle_peak": [
                    0.448,
                    0.456,
                    0.474,
                    0.467,
                    0.492,
                    0.442,
                    0.466,
                    0.505,
                    0.506,
                    0.444,
                ],
            },
            "ail_part_or_and_xnor": {
                "beta1": [
                    -0.557,
                    -0.712,
                    -0.6,
                    -0.64,
                    -0.64,
                    -0.855,
                    -0.61,
                    -0.731,
                    -0.574,
                    -0.561,
                ],
                "beta2": [
                    -2.378,
                    -2.764,
                    -2.713,
                    -2.436,
                    -2.535,
                    -2.487,
                    -2.521,
                    -2.471,
                    -2.807,
                    -2.265,
                ],
                "eps": [
                    -7.515,
                    -7.648,
                    -7.085,
                    -7.428,
                    -7.47,
                    -7.586,
                    -7.673,
                    -7.24,
                    -7.348,
                    -7.283,
                ],
                "wd": [
                    -3.413,
                    -3.323,
                    -3.322,
                    -3.378,
                    -3.379,
                    -3.488,
                    -3.434,
                    -3.517,
                    -3.444,
                    -3.4,
                ],
                "max_lr": [
                    -2.753,
                    -2.683,
                    -2.563,
                    -2.681,
                    -2.694,
                    -2.684,
                    -2.66,
                    -2.661,
                    -2.71,
                    -2.725,
                ],
                "cycle_peak": [
                    0.488,
                    0.451,
                    0.459,
                    0.478,
                    0.429,
                    0.467,
                    0.456,
                    0.486,
                    0.465,
                    0.41,
                ],
            },
            "ail_part_or_xnor": {
                "beta1": [
                    -0.686,
                    -0.647,
                    -0.804,
                    -0.682,
                    -0.727,
                    -0.748,
                    -0.76,
                    -0.596,
                    -0.61,
                    -0.789,
                ],
                "beta2": [
                    -2.772,
                    -2.969,
                    -2.777,
                    -2.798,
                    -3.265,
                    -2.091,
                    -3.454,
                    -2.709,
                    -2.941,
                    -3.047,
                ],
                "eps": [
                    -5.886,
                    -6.732,
                    -6.887,
                    -6.025,
                    -6.161,
                    -6.56,
                    -6.414,
                    -7.887,
                    -7.44,
                    -8.665,
                ],
                "wd": [
                    -3.534,
                    -3.461,
                    -3.538,
                    -3.548,
                    -3.485,
                    -3.484,
                    -3.547,
                    -3.562,
                    -3.519,
                    -3.523,
                ],
                "max_lr": [
                    -2.612,
                    -2.617,
                    -2.641,
                    -2.614,
                    -2.629,
                    -2.626,
                    -2.642,
                    -2.642,
                    -2.611,
                    -2.589,
                ],
                "cycle_peak": [
                    0.451,
                    0.456,
                    0.41,
                    0.437,
                    0.454,
                    0.4,
                    0.439,
                    0.45,
                    0.474,
                    0.402,
                ],
            },
            "ail_xnor": {
                "beta1": [
                    -0.55,
                    -0.554,
                    -0.729,
                    -0.782,
                    -0.643,
                    -0.787,
                    -0.686,
                    -0.501,
                    -0.574,
                    -0.602,
                ],
                "beta2": [
                    -3.369,
                    -2.651,
                    -2.797,
                    -2.854,
                    -3.348,
                    -3.254,
                    -2.745,
                    -3.551,
                    -3.034,
                    -3.208,
                ],
                "eps": [
                    -7.863,
                    -8.039,
                    -7.702,
                    -7.408,
                    -8.045,
                    -7.192,
                    -7.888,
                    -7.99,
                    -7.427,
                    -7.879,
                ],
                "wd": [
                    -3.042,
                    -2.994,
                    -3.042,
                    -3.037,
                    -3.003,
                    -3.012,
                    -3.005,
                    -3.073,
                    -3.044,
                    -3.023,
                ],
                "max_lr": [
                    -2.734,
                    -2.675,
                    -2.703,
                    -2.593,
                    -2.664,
                    -2.639,
                    -2.668,
                    -2.736,
                    -2.622,
                    -2.805,
                ],
                "cycle_peak": [
                    0.388,
                    0.461,
                    0.382,
                    0.394,
                    0.413,
                    0.447,
                    0.392,
                    0.502,
                    0.442,
                    0.384,
                ],
            },
            "bin_all_max_min": {
                "beta1": [
                    -0.688,
                    -0.784,
                    -0.729,
                    -0.631,
                    -0.765,
                    -0.756,
                    -0.738,
                    -0.699,
                    -0.606,
                    -0.797,
                ],
                "beta2": [
                    -1.899,
                    -1.897,
                    -1.851,
                    -1.804,
                    -1.804,
                    -1.994,
                    -2.337,
                    -2.096,
                    -2.502,
                    -1.878,
                ],
                "eps": [
                    -8.309,
                    -8.155,
                    -8.749,
                    -8.554,
                    -8.496,
                    -8.475,
                    -7.354,
                    -8.68,
                    -7.336,
                    -7.982,
                ],
                "wd": [
                    -3.258,
                    -4.835,
                    -4.484,
                    -3.473,
                    -3.78,
                    -4.92,
                    -3.603,
                    -4.069,
                    -4.198,
                    -4.36,
                ],
                "max_lr": [
                    -2.918,
                    -2.965,
                    -2.968,
                    -2.883,
                    -2.936,
                    -2.886,
                    -2.875,
                    -2.967,
                    -2.968,
                    -2.934,
                ],
                "cycle_peak": [
                    0.479,
                    0.402,
                    0.342,
                    0.374,
                    0.56,
                    0.478,
                    0.584,
                    0.441,
                    0.502,
                    0.462,
                ],
            },
        },
    },
}


def get_hparams(
    model, dataset, actfun, seed, epochs, search=False, hp_idx=None, oneshot=False
):

    if model == "efficientnet":
        hparams = {
            "beta1": 0.9,
            "beta2": 0.999,
            "eps": 1e-8,
            "wd": 1e-4,
            "max_lr": 0.01,
            "cycle_peak": 0.2,
        }
    else:
        util.seed_all(seed)
        rng = np.random.RandomState(seed)
        if epochs == 10:
            if oneshot:
                b = _TEST_BOUNDS[model][dataset][actfun]
            else:
                b = _BOUNDS10[model][dataset][actfun]
        elif epochs == 50:
            b = _BOUNDS50[model][dataset][actfun]
        else:
            b = _BOUNDS100[model][dataset][actfun]

        if search:
            hparams = {
                "beta1": 1 - np.power(10.0, rng.uniform(b["beta1"][0], b["beta1"][1])),
                "beta2": 1 - np.power(10.0, rng.uniform(b["beta2"][0], b["beta2"][1])),
                "eps": np.power(10.0, rng.uniform(b["eps"][0], b["eps"][1])),
                "wd": np.power(10.0, rng.uniform(b["wd"][0], b["wd"][1])),
                "max_lr": np.power(10.0, rng.uniform(b["max_lr"][0], b["max_lr"][1])),
                "cycle_peak": rng.uniform(b["cycle_peak"][0], b["cycle_peak"][1]),
            }
            if hp_idx is not None:
                hparams = {
                    "beta1": 1 - np.power(10.0, b["beta1"][hp_idx]),
                    "beta2": 1 - np.power(10.0, b["beta2"][hp_idx]),
                    "eps": np.power(10.0, b["eps"][hp_idx]),
                    "wd": np.power(10.0, b["wd"][hp_idx]),
                    "max_lr": np.power(10.0, b["max_lr"][hp_idx]),
                    "cycle_peak": b["cycle_peak"][hp_idx],
                }
        else:
            hparams = {
                "beta1": 1 - np.power(10.0, b["beta1"]),
                "beta2": 1 - np.power(10.0, b["beta2"]),
                "eps": np.power(10.0, b["eps"]),
                "wd": np.power(10.0, b["wd"]),
                "max_lr": np.power(10.0, b["max_lr"]),
                "cycle_peak": b["cycle_peak"],
            }

    return hparams
