Covertype experiments
=====================

Code for running the experiments in the paper
Logical Activation Functions: Logit-space equivalents of Probabilistic Boolean Operators
https://openreview.net/forum?id=m6HNNpQO8dc
on the Covertype dataset.

The dataset can be found at: https://archive.ics.uci.edu/ml/datasets/covertype

For convenience, we automatically download the dataset using `sklearn.datasets.fetch_covtype` the first time the training script is run.
The covertype dataset will be downloaded into a subfolder of the `~/scikit_learn_data` directory on your system.


Installation
------------

Set up environment and install dependencies.

```sh
# Example install
ENVNAME=ail-covertype
echo "Setting up environment $ENVNAME"
conda create --name "$ENVNAME" -q python=3.7.9 pip

# Activate the environment
conda activate "$ENVNAME"

# Install dependencies
conda install pytorch=1.3.1 torchvision=0.4.2 cudatoolkit=10.2 -c pytorch
pip install -r requirements.txt
```


Experiments
-----------

The experimental results shown in the paper can be replicated with the following bash code.

```sh
for NLAYER in 1 2 3; do
    for NHIDDEN in 8 16 32 64 128 256 512 1024 2048 4096; do
        for ACTFUN in relu maxout max_min_dup signedgeomean ail_xnor ail_or ail_and_or_dup ail_or_xnor_part ail_or_xnor_dup ail_and_or_xnor_part ail_and_or_xnor_dup; do
            for SEED in {0..9}; do
                python main_covtype.py \
                    --seed "$SEED" \
                    --actfun "$ACTFUN" \
                    --nlayer "$NLAYER" \
                    --nlatent "$NLATENT" \
                    --lr-recommender "min110"
            done
        done
    done
done

NLAYER=1;
NHIDDEN=8192;
for ACTFUN in relu maxout max_min_dup signedgeomean ail_xnor ail_or ail_and_or_dup ail_or_xnor_part ail_or_xnor_dup ail_and_or_xnor_part ail_and_or_xnor_dup; do
    for SEED in 0..9; do
        python main_covtype.py \
            --seed "$SEED" \
            --actfun "$ACTFUN" \
            --nlayer "$NLAYER" \
            --nlatent "$NLATENT" \
            --lr-recommender "min110"
    done
done
```


Plots
-----

Plots can be generated using the notebook `plot_covertype.ipynb`.

You will need either jupyterlab:
```sh
python -m pip install jupyterlab
python -m jupyterlab plot_covertype.ipynb
```
or jupyter-notebook:
```sh
python -m pip install jupyter[notebook]
python -m jupyter notebook plot_covertype.ipynb
```

