#!/bin/bash
#SBATCH --array=1-13
#SBATCH --partition=p100
#SBATCH --qos=normal
#SBATCH --nodes=1
#SBATCH --gpus-per-node=1
#SBATCH --mem=12G # per node
#SBATCH --time=2:00:00
#SBATCH --output=./logs/JSB_actfuns-%a.log
#SBATCH --open-mode=append
#SBATCH --job-name=JSB_actfuns

. /etc/profile.d/lmod.sh
module load pytorch1.7.1-cuda11.0-python3.6

srun --mem=12G --nodes=1 --ntasks=1 \
    python train_jsb_actfun_weights.py --epochs 150 --lr 0.001 --seq_len 4 --batch_size 32 --idx ${SLURM_ARRAY_TASK_ID}

wait