# this file generates the data for the synthetic linear plots
import numpy as np
import cascading_alg as c_alg
import other_alg as o_alg
import time

start = time.time()  # to see how long the entire experiment takes
n, L, trials = 100000, 100, 5  # horizon, number of items, and number of trials
values = np.arange(4, 18, 2)  # all values of d and K we want to test
all_tests = np.concatenate((np.stack((values, 10 * np.ones(7))), np.stack((10 * np.ones(7), values))), axis=1)
all_tests = np.transpose(all_tests)  # rows now contain all K, d pairs we want to test
num_tests = all_tests.shape[0]  # number of tests

for test_idx in range(num_tests):
    K, d = all_tests.astype(int)[test_idx, :]  # current values of K and d
    regret = np.zeros((2, n, trials))
    print('starting K = ' + str(K) + ', d = ' + str(d))
    for trial_idx in range(trials):
        # generate linear instance, run two linear algorithms, print progress update
        start_trial = time.time()
        phi, reward = o_alg.lin_instance(L, K, d)
        regret[0, :, trial_idx] = c_alg.cascade_linucb(n, K, phi, reward)
        regret[1, :, trial_idx] = c_alg.cascade_woful(n, K, phi, reward)
        print('trial ' + str(trial_idx + 1) + ' of ' + str(trials) + ' done, time = ' + str(time.time() - start_trial))
    np.savez('results/syn_lin_' + str(K) + '_' + str(d), regret)  # save results for later plotting

print('total time = ' + str(time.time() - start))  # show how long the entire experiment took
